/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rebind.context;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.rebind.context.StaticResourceContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class MhtmlResourceContext
extends StaticResourceContext {
    private static final String BOUNDARY = "_GWT";
    private static final String ID_PREFIX = "r";
    private String bundleBaseIdent;
    private int id = 0;
    private String isHttpsIdent;
    private final Map<String, String> strongNameToExpressions = new HashMap<String, String>();
    private ByteArrayOutputStream out;
    private String partialPath;
    private PrintWriter pw;

    MhtmlResourceContext(TreeLogger logger, GeneratorContext context, JClassType resourceBundleType) {
        super(logger, context, resourceBundleType);
    }

    public String deploy(String suggestedFileName, String mimeType, byte[] data, boolean xhrCompatible) throws UnableToCompleteException {
        String strongName = Util.computeStrongName((byte[])data);
        String toReturn = this.strongNameToExpressions.get(strongName);
        if (toReturn != null) {
            return toReturn;
        }
        assert (this.isHttpsIdent != null) : "isHttpsIdent";
        assert (this.bundleBaseIdent != null) : "bundleBaseIdent";
        String staticLocation = super.deploy(suggestedFileName, mimeType, data, xhrCompatible);
        if (xhrCompatible || data.length > 65536) {
            return staticLocation;
        }
        if (this.out == null) {
            this.out = new ByteArrayOutputStream();
            this.pw = new PrintWriter(this.out);
            this.pw.println("Content-Type: multipart/related; boundary=\"_GWT\"");
            this.pw.println();
        }
        String location = ID_PREFIX + this.id++;
        String base64 = MhtmlResourceContext.toBase64(data);
        this.pw.println("--_GWT");
        this.pw.println("Content-Id:<" + location + ">");
        this.pw.println("Content-Type:" + mimeType);
        this.pw.println("Content-Transfer-Encoding:base64");
        this.pw.println();
        this.pw.println(base64);
        this.pw.println();
        toReturn = this.isHttpsIdent + " ? (" + staticLocation + ") : (" + this.bundleBaseIdent + " + \"" + location + "\")";
        this.strongNameToExpressions.put(strongName, toReturn);
        return toReturn;
    }

    public void finish() throws UnableToCompleteException {
        if (this.out != null) {
            TreeLogger logger = this.getLogger().branch(TreeLogger.DEBUG, "Writing container to disk");
            this.pw.close();
            assert (this.partialPath != null) : "partialPath";
            OutputStream realOut = this.getContext().tryCreateResource(logger, this.partialPath);
            try {
                realOut.write(this.out.toByteArray());
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unable to write container file", (Throwable)e);
            }
            this.getContext().commitResource(logger, realOut);
        }
    }

    void setBundleBaseIdent(String ident) {
        this.bundleBaseIdent = ident;
    }

    void setIsHttpsIdent(String ident) {
        this.isHttpsIdent = ident;
    }

    void setPartialPath(String partialPath) {
        this.partialPath = partialPath;
    }
}

