/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.model.OwnerClass;

class HandlerEvaluator {
    private static final String HANDLER_BASE_NAME = "handlerMethodWithNameVeryUnlikelyToCollideWithUserFieldNames";
    private int varCounter = 0;
    private final MortalLogger logger;
    private final JClassType handlerRegistrationJClass;
    private final JClassType eventHandlerJClass;
    private final OwnerClass ownerClass;

    HandlerEvaluator(OwnerClass ownerClass, MortalLogger logger, TypeOracle oracle) {
        this.ownerClass = ownerClass;
        this.logger = logger;
        this.handlerRegistrationJClass = oracle.findType(HandlerRegistration.class.getName());
        this.eventHandlerJClass = oracle.findType(EventHandler.class.getName());
    }

    public void run(IndentedWriter writer, FieldManager fieldManager, String uiOwner) throws UnableToCompleteException {
        for (JMethod method : this.ownerClass.getUiHandlers()) {
            JClassType eventType;
            JClassType handlerType;
            JParameter[] parameters;
            String boundMethod = method.getName();
            if (method.isPrivate()) {
                this.logger.die("Method '%s' cannot be private.", boundMethod);
            }
            if ((parameters = method.getParameters()).length != 1) {
                this.logger.die("Method '%s' must have a single event parameter defined.", boundMethod);
            }
            if ((handlerType = this.getHandlerForEvent(eventType = parameters[0].getType().isClass())) == null) {
                this.logger.die("Parameter '%s' is not an event (subclass of GwtEvent).", eventType.getName());
            }
            String handlerVarName = HANDLER_BASE_NAME + ++this.varCounter;
            this.writeHandler(writer, uiOwner, handlerVarName, handlerType, eventType, boundMethod);
            UiHandler annotation = (UiHandler)method.getAnnotation(UiHandler.class);
            for (String objectName : annotation.value()) {
                JMethod addHandlerMethodType;
                FieldWriter fieldWriter = fieldManager.lookup(objectName);
                if (fieldWriter == null) {
                    this.logger.die("Method '%s' can not be bound. You probably missed ui:field='%s' in the template.", boundMethod, objectName);
                }
                if ((addHandlerMethodType = this.getAddHandlerMethodForObject(fieldWriter.getInstantiableType(), handlerType)) == null) {
                    this.logger.die("Field '%s' does not have an 'add%s' method associated.", objectName, handlerType.getName());
                }
                this.writeAddHandler(writer, handlerVarName, addHandlerMethodType.getName(), objectName);
            }
        }
    }

    protected void writeHandler(IndentedWriter writer, String uiOwner, String handlerVarName, JClassType handlerType, JClassType eventType, String boundMethod) throws UnableToCompleteException {
        JParameter[] parameters;
        JMethod[] methods = handlerType.getMethods();
        if (methods.length != 1) {
            this.logger.die("'%s' has more than one method defined.", handlerType.getName());
        }
        if ((parameters = methods[0].getParameters()).length != 1 || parameters[0].getType() != eventType) {
            this.logger.die("Method '%s' needs '%s' as parameter", methods[0].getName(), eventType.getName());
        }
        writer.newline();
        writer.write("final %1$s %2$s = new %1$s() {", handlerType.getParameterizedQualifiedSourceName(), handlerVarName);
        writer.indent();
        writer.write("public void %1$s(%2$s event) {", methods[0].getName(), eventType.getParameterizedQualifiedSourceName());
        writer.indent();
        writer.write("%1$s.%2$s(event);", uiOwner, boundMethod);
        writer.outdent();
        writer.write("}");
        writer.outdent();
        writer.write("};");
    }

    void writeAddHandler(IndentedWriter writer, String handlerVarName, String addHandlerMethodName, String objectName) {
        writer.write("%1$s.%2$s(%3$s);", objectName, addHandlerMethodName, handlerVarName);
    }

    private JMethod getAddHandlerMethodForObject(JClassType objectType, JClassType handlerType) throws UnableToCompleteException {
        JMethod handlerMethod = null;
        for (JMethod method : objectType.getOverridableMethods()) {
            JParameter[] parameters;
            if (method.getReturnType() != this.handlerRegistrationJClass || (parameters = method.getParameters()).length != 1 || !handlerType.equals((Object)parameters[0].getType())) continue;
            if (handlerMethod != null) {
                this.logger.die("This handler cannot be generated. Methods '%s' and '%s' are ambiguous. Which one to pick?", method, handlerMethod);
            }
            handlerMethod = method;
        }
        return handlerMethod;
    }

    private JClassType getHandlerForEvent(JClassType eventType) {
        if (eventType == null) {
            return null;
        }
        JMethod method = eventType.findMethod("getAssociatedType", new JType[0]);
        if (method == null) {
            this.logger.warn("Method 'getAssociatedType()' could not be found in the event '%s'.", eventType.getName());
            return null;
        }
        JType returnType = method.getReturnType();
        if (returnType == null) {
            this.logger.warn("The method 'getAssociatedType()' in the event '%s' returns void.", eventType.getName());
            return null;
        }
        JParameterizedType isParameterized = returnType.isParameterized();
        if (isParameterized == null) {
            this.logger.warn("The method 'getAssociatedType()' in '%s' does not return Type<? extends EventHandler>.", eventType.getName());
            return null;
        }
        JClassType[] argTypes = isParameterized.getTypeArgs();
        if (argTypes.length != 1 && !argTypes[0].isAssignableTo(this.eventHandlerJClass)) {
            this.logger.warn("The method 'getAssociatedType()' in '%s' does not return Type<? extends EventHandler>.", eventType.getName());
            return null;
        }
        return argTypes[0];
    }
}

