/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dom.client.TagName;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.uibinder.attributeparsers.AttributeParser;
import com.google.gwt.uibinder.attributeparsers.AttributeParsers;
import com.google.gwt.uibinder.attributeparsers.BundleAttributeParser;
import com.google.gwt.uibinder.attributeparsers.BundleAttributeParsers;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.elementparsers.AttributeMessageParser;
import com.google.gwt.uibinder.elementparsers.BeanParser;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.IsEmptyParser;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.HandlerEvaluator;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.Tokenator;
import com.google.gwt.uibinder.rebind.UiBinderParser;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.XMLElementProviderImpl;
import com.google.gwt.uibinder.rebind.messages.MessagesWriter;
import com.google.gwt.uibinder.rebind.model.ImplicitClientBundle;
import com.google.gwt.uibinder.rebind.model.ImplicitCssResource;
import com.google.gwt.uibinder.rebind.model.OwnerClass;
import com.google.gwt.uibinder.rebind.model.OwnerField;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiBinderWriter {
    private static final String PACKAGE_URI_SCHEME = "urn:import:";
    private static final String CLIENT_BUNDLE_FIELD = "clientBundleFieldNameUnlikelyToCollideWithUserSpecifiedFieldOkay";
    private final MortalLogger logger;
    private final Map<String, String> elementParsers = new HashMap<String, String>();
    private final List<String> initStatements = new ArrayList<String>();
    private final List<String> statements = new ArrayList<String>();
    private final HandlerEvaluator handlerEvaluator;
    private final MessagesWriter messages;
    private final Tokenator tokenator = new Tokenator();
    private final String templatePath;
    private final TypeOracle oracle;
    private final JClassType baseClass;
    private final String implClassName;
    private final JClassType uiOwnerType;
    private final JClassType uiRootType;
    private final OwnerClass ownerClass;
    private final FieldManager fieldManager;
    private final ImplicitClientBundle bundleClass;
    private int domId = 0;
    private int fieldIndex;
    private String gwtPrefix;
    private String rendered;
    private final LinkedList<String> attachSectionElements = new LinkedList();
    private final Map<String, String> attachedVars = new HashMap<String, String>();
    private int nextAttachVar = 0;
    private final LinkedList<List<String>> detachStatementsStack = new LinkedList();
    private final AttributeParsers attributeParsers;
    private final BundleAttributeParsers bundleParsers;

    public static String asCommaSeparatedList(String ... args) {
        StringBuilder b = new StringBuilder();
        for (String arg : args) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(arg);
        }
        return b.toString();
    }

    public static String escapeAttributeText(String text) {
        text = UiBinderWriter.escapeText(text, false);
        text = text.replaceAll("'", "&#39;");
        return text;
    }

    public static String escapeText(String text, boolean preserveWhitespace) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        if (!preserveWhitespace) {
            text = text.replaceAll("\\s+", " ");
        }
        return UiBinderWriter.escapeTextForJavaStringLiteral(text);
    }

    public static String escapeTextForJavaStringLiteral(String text) {
        text = text.replaceAll("\"", "\\\\\"");
        text = text.replaceAll("\n", "\\\\n");
        return text;
    }

    static Iterable<JClassType> getClassHierarchyBreadthFirst(JClassType type) {
        LinkedList<JClassType> list = new LinkedList<JClassType>();
        LinkedList<JClassType> q = new LinkedList<JClassType>();
        q.add(type);
        while (!q.isEmpty()) {
            JClassType curType = (JClassType)q.removeFirst();
            list.add(curType);
            for (JClassType intf : curType.getImplementedInterfaces()) {
                q.add(intf);
            }
            JClassType superClass = curType.getSuperclass();
            if (superClass == null) continue;
            q.add(superClass);
        }
        return list;
    }

    private static String capitalizePropName(String propName) {
        return propName.substring(0, 1).toUpperCase() + propName.substring(1);
    }

    public UiBinderWriter(JClassType baseClass, String implClassName, String templatePath, TypeOracle oracle, MortalLogger logger, FieldManager fieldManager, MessagesWriter messagesWriter) throws UnableToCompleteException {
        JClassType[] uiBinderTypes;
        this.baseClass = baseClass;
        this.implClassName = implClassName;
        this.oracle = oracle;
        this.logger = logger;
        this.templatePath = templatePath;
        this.fieldManager = fieldManager;
        this.messages = messagesWriter;
        JClassType uibinderItself = oracle.findType(UiBinder.class.getCanonicalName());
        if (uibinderItself.equals((Object)baseClass)) {
            this.die("You must use a subtype of UiBinder in GWT.create(). E.g.,\n  interface Binder extends UiBinder<Widget, MyClass> {}\n  GWT.create(Binder.class);");
        }
        if ((uiBinderTypes = baseClass.getImplementedInterfaces()).length == 0) {
            throw new RuntimeException("No implemented interfaces for " + baseClass.getName());
        }
        JClassType uiBinderType = uiBinderTypes[0];
        JClassType[] typeArgs = uiBinderType.isParameterized().getTypeArgs();
        if (typeArgs.length < 2) {
            throw new RuntimeException("Root and owner type parameters are required for type %s" + uiBinderType.getName());
        }
        this.uiRootType = typeArgs[0];
        this.uiOwnerType = typeArgs[1];
        this.ownerClass = new OwnerClass(this.uiOwnerType, logger);
        this.bundleClass = new ImplicitClientBundle(baseClass.getPackage().getName(), this.implClassName, CLIENT_BUNDLE_FIELD, logger);
        this.handlerEvaluator = new HandlerEvaluator(this.ownerClass, logger, oracle);
        this.attributeParsers = new AttributeParsers(oracle, fieldManager, logger);
        this.bundleParsers = new BundleAttributeParsers(oracle, logger, this.getOwnerClass(), templatePath, this.uiOwnerType);
    }

    public void addDetachStatement(String format, Object ... args) {
        this.detachStatementsStack.getFirst().add(String.format(format, args));
    }

    public void addInitStatement(String format, Object ... params) {
        this.initStatements.add(this.formatCode(format, params));
    }

    public void addStatement(String format, Object ... args) {
        this.statements.add(this.formatCode(format, args));
    }

    public void beginAttachedSection(String element) {
        this.attachSectionElements.addFirst(element);
        this.detachStatementsStack.addFirst(new ArrayList());
    }

    public String declareDomField(String fieldName, String parentElementExpression) throws UnableToCompleteException {
        this.ensureAttached(parentElementExpression);
        String name = this.declareDomIdHolder();
        this.setFieldInitializer(fieldName, "null");
        this.addInitStatement("%s = com.google.gwt.dom.client.Document.get().getElementById(%s).cast();", fieldName, name);
        this.addInitStatement("%s.removeAttribute(\"id\");", fieldName);
        return this.tokenForExpression(name);
    }

    public String declareDomIdHolder() throws UnableToCompleteException {
        String domHolderName = "domId" + this.domId++;
        FieldWriter domField = this.fieldManager.registerField(this.oracle.findType(String.class.getName()), domHolderName);
        domField.setInitializer("com.google.gwt.dom.client.Document.get().createUniqueId()");
        return domHolderName;
    }

    public String declareField(String typeName, XMLElement elem) throws UnableToCompleteException {
        String fieldName;
        JClassType type = this.oracle.findType(typeName);
        if (type == null) {
            this.die("In %s, unknown type %s", elem, typeName);
        }
        if ((fieldName = this.getFieldName(elem)) == null) {
            fieldName = "f_" + elem.getLocalName() + ++this.fieldIndex;
        }
        fieldName = this.normalizeFieldName(fieldName);
        this.fieldManager.registerField(type, fieldName);
        return fieldName;
    }

    public String declareFieldIfNeeded(XMLElement elem) throws UnableToCompleteException {
        String fieldName = this.getFieldName(elem);
        if (fieldName != null) {
            this.fieldManager.registerField(this.findFieldType(elem), fieldName);
        }
        return fieldName;
    }

    public String detokenate(String betokened) {
        return this.tokenator.detokenate(betokened);
    }

    public void die(String message) throws UnableToCompleteException {
        this.logger.die(message, new Object[0]);
    }

    public void die(String message, Object ... params) throws UnableToCompleteException {
        this.logger.die(message, params);
    }

    public void endAttachedSection() {
        String elementVar = this.attachSectionElements.removeFirst();
        List<String> detachStatements = this.detachStatementsStack.removeFirst();
        if (this.attachedVars.containsKey(elementVar)) {
            String attachedVar = this.attachedVars.remove(elementVar);
            this.addInitStatement("%s.detach();", attachedVar);
            for (String statement : detachStatements) {
                this.addInitStatement(statement, new Object[0]);
            }
        }
    }

    public void ensureAttached(String element) {
        String attachSectionElement = this.attachSectionElements.getFirst();
        if (!this.attachedVars.containsKey(attachSectionElement)) {
            String attachedVar = "attachRecord" + this.nextAttachVar;
            this.addInitStatement("UiBinderUtil.TempAttachment %s = UiBinderUtil.attachToDom(%s);", attachedVar, attachSectionElement);
            this.attachedVars.put(attachSectionElement, attachedVar);
            ++this.nextAttachVar;
        }
    }

    public void ensureFieldAttached(String field) {
        this.ensureAttached(field + ".getElement()");
    }

    public JClassType findFieldType(XMLElement elem) throws UnableToCompleteException {
        String tagName = elem.getLocalName();
        if (!this.isWidgetElement(elem)) {
            return this.findGwtDomElementTypeForTag(tagName);
        }
        String ns = elem.getNamespaceUri();
        JPackage pkg = this.parseNamespacePackage(ns);
        if (pkg == null) {
            throw new RuntimeException("No such package: " + ns);
        }
        JClassType rtn = null;
        rtn = pkg.findType(tagName);
        if (rtn == null) {
            this.die("No class matching \"%s\" in %s", tagName, ns);
        }
        return rtn;
    }

    public void genPropertySet(String fieldName, String propName, String value) {
        this.addStatement("%1$s.set%2$s(%3$s);", fieldName, UiBinderWriter.capitalizePropName(propName), value);
    }

    public void genStringPropertySet(String fieldName, String propName, String value) {
        this.genPropertySet(fieldName, propName, "\"" + value + "\"");
    }

    @Deprecated
    public AttributeParser getBundleAttributeParser(XMLAttribute attribute) throws UnableToCompleteException {
        return this.bundleParsers.get(attribute);
    }

    public ImplicitClientBundle getBundleClass() {
        return this.bundleClass;
    }

    public MortalLogger getLogger() {
        return this.logger;
    }

    public MessagesWriter getMessages() {
        return this.messages;
    }

    public TypeOracle getOracle() {
        return this.oracle;
    }

    public OwnerClass getOwnerClass() {
        return this.ownerClass;
    }

    public String getUiFieldAttributeName() {
        return this.gwtPrefix + ":field";
    }

    public boolean isBinderElement(XMLElement elem) {
        String uri = elem.getNamespaceUri();
        return uri != null && "urn:ui:com.google.gwt.uibinder".equals(uri);
    }

    public boolean isWidgetElement(XMLElement elem) {
        String uri = elem.getNamespaceUri();
        return uri != null && uri.startsWith(PACKAGE_URI_SCHEME);
    }

    public String parseElementToField(XMLElement elem) throws UnableToCompleteException {
        if (this.elementParsers.isEmpty()) {
            this.registerParsers();
        }
        JClassType type = this.findFieldType(elem);
        String fieldName = this.declareField(type.getQualifiedSourceName(), elem);
        FieldWriter field = this.fieldManager.lookup(fieldName);
        this.fieldManager.push(field);
        for (ElementParser parser : this.getParsersForClass(type)) {
            parser.parse(elem, fieldName, type, this);
        }
        this.fieldManager.pop();
        return fieldName;
    }

    public void setFieldInitializer(String fieldName, String factoryMethod) {
        this.fieldManager.lookup(fieldName).setInitializer(factoryMethod);
    }

    public void setFieldInitializerAsConstructor(String fieldName, JClassType type, String ... args) {
        this.setFieldInitializer(fieldName, this.formatCode("new %s(%s)", type.getQualifiedSourceName(), UiBinderWriter.asCommaSeparatedList(args)));
    }

    public String tokenForExpression(String expression) {
        return this.tokenator.nextToken("\" + " + expression + " + \"");
    }

    public void warn(String message) {
        this.logger.warn(message, new Object[0]);
    }

    public void warn(String message, Object ... params) {
        this.logger.warn(message, params);
    }

    void parseDocument(Document doc, PrintWriter printWriter) throws UnableToCompleteException {
        JClassType uiBinderClass = this.getOracle().findType(UiBinder.class.getName());
        if (!this.baseClass.isAssignableTo(uiBinderClass)) {
            this.die(this.baseClass.getName() + " must implement UiBinder");
        }
        Element documentElement = doc.getDocumentElement();
        this.gwtPrefix = documentElement.lookupPrefix("urn:ui:com.google.gwt.uibinder");
        XMLElement elem = new XMLElementProviderImpl(this.attributeParsers, this.bundleParsers, this.oracle, this.logger).get(documentElement);
        this.rendered = this.tokenator.detokenate(this.parseDocumentElement(elem));
        printWriter.print(this.rendered);
    }

    private void addElementParser(String gwtClass, String parser) {
        this.elementParsers.put(gwtClass, parser);
    }

    private void addWidgetParser(String className) {
        String gwtClass = "com.google.gwt.user.client.ui." + className;
        String parser = "com.google.gwt.uibinder.elementparsers." + className + "Parser";
        this.addElementParser(gwtClass, parser);
    }

    private String declareStaticField(BundleAttributeParser parser) {
        if (!parser.isBundleStatic()) {
            return null;
        }
        String fullBundleClassName = parser.fullBundleClassName();
        StringBuilder b = new StringBuilder();
        b.append("static ").append(fullBundleClassName).append(" ").append(parser.bundleInstance()).append(" = GWT.create(").append(fullBundleClassName).append(".class);");
        return b.toString();
    }

    private void ensureAttachmentCleanedUp() throws UnableToCompleteException {
        if (!this.attachSectionElements.isEmpty()) {
            throw new IllegalStateException("Attachments not cleaned up: " + this.attachSectionElements);
        }
        if (!this.detachStatementsStack.isEmpty()) {
            throw new IllegalStateException("Detach not cleaned up: " + this.detachStatementsStack);
        }
    }

    private JClassType findGwtDomElementTypeForTag(String tag) {
        JClassType[] types;
        JClassType elementClass = this.oracle.findType("com.google.gwt.dom.client.Element");
        for (JClassType type : types = elementClass.getSubtypes()) {
            TagName annotation = (TagName)type.getAnnotation(TagName.class);
            if (annotation == null) continue;
            for (String annotationTag : annotation.value()) {
                if (!annotationTag.equals(tag)) continue;
                return type;
            }
        }
        return elementClass;
    }

    private String formatCode(String format, Object ... params) {
        String r = String.format(Locale.US, format, params);
        return r;
    }

    private String getFieldName(XMLElement elem) throws UnableToCompleteException {
        String fieldName = null;
        boolean hasOldSchoolId = false;
        if (elem.hasAttribute("id") && this.isWidgetElement(elem)) {
            hasOldSchoolId = true;
            fieldName = elem.consumeRawAttribute("id");
            this.warn("Deprecated use of id=\"%1$s\" for field name. Please switch to gwt:field=\"%1$s\" instead. This will soon be a compile error!", fieldName);
        }
        if (elem.hasAttribute(this.getUiFieldAttributeName())) {
            if (hasOldSchoolId) {
                this.die("Cannot declare both id and field on the same element: " + elem);
            }
            fieldName = elem.consumeRawAttribute(this.getUiFieldAttributeName());
        }
        return fieldName;
    }

    private Class<? extends ElementParser> getParserForClass(JClassType uiClass) {
        String uiClassName = uiClass.getQualifiedSourceName();
        String parserClassName = this.elementParsers.get(uiClassName);
        if (parserClassName == null) {
            return null;
        }
        try {
            return Class.forName(parserClassName).asSubclass(ElementParser.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to instantiate parser", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException(parserClassName + " must extend ElementParser");
        }
    }

    private Iterable<ElementParser> getParsersForClass(JClassType type) {
        ArrayList<ElementParser> parsers = new ArrayList<ElementParser>();
        parsers.add(new AttributeMessageParser());
        for (JClassType curType : UiBinderWriter.getClassHierarchyBreadthFirst(type)) {
            try {
                Class<? extends ElementParser> cls = this.getParserForClass(curType);
                if (cls == null) continue;
                ElementParser parser = cls.newInstance();
                parsers.add(parser);
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Unable to instantiate " + curType.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unable to instantiate " + curType.getName(), e);
            }
        }
        parsers.add(new BeanParser());
        parsers.add(new IsEmptyParser());
        return parsers;
    }

    private void maybeWriteFieldSetter(IndentedWriter niceWriter, OwnerField ownerField, JClassType templateClass, String templateField) throws UnableToCompleteException {
        JClassType fieldType = ownerField.getType().getRawType();
        if (!templateClass.isAssignableTo(fieldType)) {
            this.die("Template field and owner field types don't match: %s != %s", templateClass.getQualifiedSourceName(), fieldType.getQualifiedSourceName());
        }
        if (!ownerField.isProvided()) {
            niceWriter.write("owner.%1$s = %2$s;", ownerField.getName(), templateField);
        }
    }

    private String normalizeFieldName(String fieldName) {
        return fieldName.replace('.', '$');
    }

    private String parseDocumentElement(XMLElement elem) throws UnableToCompleteException {
        this.fieldManager.registerFieldOfGeneratedType(this.oracle.findType(ClientBundle.class.getName()), this.bundleClass.getPackageName(), this.bundleClass.getClassName(), this.bundleClass.getFieldName());
        String rootField = new UiBinderParser(this, this.messages, this.fieldManager, this.oracle, this.bundleClass).parse(elem);
        this.fieldManager.validate();
        StringWriter stringWriter = new StringWriter();
        IndentedWriter niceWriter = new IndentedWriter(new PrintWriter(stringWriter));
        this.writeBinder(niceWriter, rootField);
        this.ensureAttachmentCleanedUp();
        return stringWriter.toString();
    }

    private JPackage parseNamespacePackage(String ns) throws UnableToCompleteException {
        if (ns.startsWith(PACKAGE_URI_SCHEME)) {
            String pkgName = ns.substring(PACKAGE_URI_SCHEME.length());
            JPackage pkg = this.oracle.findPackage(pkgName);
            if (pkg == null) {
                this.die("Package not found: " + pkgName);
            }
            return pkg;
        }
        return null;
    }

    private void registerParsers() {
        this.addElementParser("com.google.gwt.dom.client.Element", "com.google.gwt.uibinder.elementparsers.DomElementParser");
        this.addWidgetParser("UIObject");
        this.addWidgetParser("HasText");
        this.addWidgetParser("HasHTML");
        this.addWidgetParser("HasWidgets");
        this.addWidgetParser("HTMLPanel");
        this.addWidgetParser("DockPanel");
        this.addWidgetParser("StackPanel");
        this.addWidgetParser("DisclosurePanel");
        this.addWidgetParser("TabPanel");
        this.addWidgetParser("MenuItem");
        this.addWidgetParser("MenuBar");
        this.addWidgetParser("CellPanel");
        this.addWidgetParser("CustomButton");
        this.addWidgetParser("DialogBox");
        this.addWidgetParser("LayoutPanel");
        this.addWidgetParser("DockLayoutPanel");
        this.addWidgetParser("StackLayoutPanel");
        this.addWidgetParser("TabLayoutPanel");
        this.addWidgetParser("Image");
    }

    private void writeAddedStatements(IndentedWriter niceWriter) {
        for (String s : this.statements) {
            niceWriter.write(s);
        }
    }

    private void writeBinder(IndentedWriter w, String rootField) throws UnableToCompleteException {
        this.writePackage(w);
        this.writeImports(w);
        w.newline();
        this.writeClassOpen(w);
        this.writeStatics(w);
        w.newline();
        w.write("public %s createAndBindUi(final %s owner) {", this.uiRootType.getParameterizedQualifiedSourceName(), this.uiOwnerType.getParameterizedQualifiedSourceName());
        w.indent();
        w.newline();
        this.writeGwtFields(w);
        w.newline();
        this.writeAddedStatements(w);
        w.newline();
        this.writeInitStatements(w);
        w.newline();
        this.writeHandlers(w);
        w.newline();
        this.writeOwnerFieldSetters(w);
        this.writeCssInjectors(w);
        w.write("return %s;", rootField);
        w.outdent();
        w.write("}");
        w.outdent();
        w.write("}");
    }

    private void writeClassOpen(IndentedWriter w) {
        w.write("public class %s implements UiBinder<%s, %s>, %s {", this.implClassName, this.uiRootType.getParameterizedQualifiedSourceName(), this.uiOwnerType.getParameterizedQualifiedSourceName(), this.baseClass.getParameterizedQualifiedSourceName());
        w.indent();
    }

    private void writeCssInjectors(IndentedWriter w) {
        for (ImplicitCssResource css : this.bundleClass.getCssMethods()) {
            w.write("%s.%s().ensureInjected();", this.bundleClass.getFieldName(), css.getName());
        }
        w.newline();
    }

    private void writeGwtFields(IndentedWriter niceWriter) throws UnableToCompleteException {
        Collection<OwnerField> ownerFields = this.getOwnerClass().getUiFields();
        for (OwnerField ownerField : ownerFields) {
            String fieldName;
            FieldWriter fieldWriter;
            if (!ownerField.isProvided() || (fieldWriter = this.fieldManager.lookup(fieldName = ownerField.getName())) == null) continue;
            this.fieldManager.lookup(fieldName).setInitializerMaybe(this.formatCode("owner.%1$s", fieldName));
        }
        this.fieldManager.writeGwtFieldsDeclaration(niceWriter, this.uiOwnerType.getName());
    }

    private void writeHandlers(IndentedWriter w) throws UnableToCompleteException {
        this.handlerEvaluator.run(w, this.fieldManager, "owner");
    }

    private void writeImports(IndentedWriter w) {
        w.write("import com.google.gwt.core.client.GWT;");
        w.write("import com.google.gwt.uibinder.client.UiBinder;");
        w.write("import com.google.gwt.uibinder.client.UiBinderUtil;");
        w.write("import %s.%s;", this.uiRootType.getPackage().getName(), this.uiRootType.getName());
    }

    private void writeInitStatements(IndentedWriter niceWriter) {
        for (String s : this.initStatements) {
            niceWriter.write(s);
        }
    }

    private void writeOwnerFieldSetters(IndentedWriter niceWriter) throws UnableToCompleteException {
        for (OwnerField ownerField : this.getOwnerClass().getUiFields()) {
            String fieldName = ownerField.getName();
            FieldWriter fieldWriter = this.fieldManager.lookup(fieldName);
            BundleAttributeParser bundleParser = this.bundleParsers.get(ownerField.getType());
            if (bundleParser != null) {
                this.maybeWriteFieldSetter(niceWriter, ownerField, bundleParser.bundleClass(), bundleParser.bundleInstance());
                continue;
            }
            if (fieldWriter != null) {
                JClassType type = fieldWriter.getInstantiableType();
                if (type != null) {
                    this.maybeWriteFieldSetter(niceWriter, ownerField, fieldWriter.getInstantiableType(), fieldName);
                    continue;
                }
                if (ownerField.isProvided()) continue;
                niceWriter.write("owner.%1$s = %1$s;", fieldName);
                continue;
            }
            this.die("Template %s has no %s attribute for %s.%s#%s", this.templatePath, this.getUiFieldAttributeName(), this.uiOwnerType.getPackage().getName(), this.uiOwnerType.getName(), fieldName);
        }
    }

    private void writePackage(IndentedWriter w) {
        String packageName = this.baseClass.getPackage().getName();
        if (packageName.length() > 0) {
            w.write("package %1$s;", packageName);
            w.newline();
        }
    }

    private void writeStaticBundleInstances(IndentedWriter niceWriter) {
        Map<String, BundleAttributeParser> bpMap = this.bundleParsers.getMap();
        for (String key : bpMap.keySet()) {
            String declaration = this.declareStaticField(bpMap.get(key));
            if (declaration == null) continue;
            niceWriter.write(declaration);
        }
    }

    private void writeStaticMessagesInstance(IndentedWriter niceWriter) {
        if (this.messages.hasMessages()) {
            niceWriter.write(this.messages.getDeclaration());
        }
    }

    private void writeStatics(IndentedWriter w) {
        this.writeStaticMessagesInstance(w);
        this.writeStaticBundleInstances(w);
    }
}

