/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.uibinder.rebind.GwtResourceEntityResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class W3cDomHelper {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder builder;

    public W3cDomHelper(final TreeLogger logger) {
        this.factory.setNamespaceAware(true);
        this.factory.setExpandEntityReferences(true);
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.builder.setEntityResolver(new GwtResourceEntityResolver());
        this.builder.setErrorHandler(new ErrorHandler(){

            public void error(SAXParseException exception) throws SAXException {
                logger.log(TreeLogger.Type.ERROR, exception.getMessage());
                logger.log(TreeLogger.Type.DEBUG, "SAXParseException", (Throwable)exception);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                logger.log(TreeLogger.Type.ERROR, exception.getMessage());
                logger.log(TreeLogger.Type.DEBUG, "SAXParseException", (Throwable)exception);
            }

            public void warning(SAXParseException exception) throws SAXException {
                logger.log(TreeLogger.Type.WARN, exception.getMessage());
                logger.log(TreeLogger.Type.DEBUG, "SAXParseException", (Throwable)exception);
            }
        });
    }

    public Document documentFor(String string) throws SAXException, IOException {
        return this.builder.parse(new ByteArrayInputStream(string.getBytes()));
    }

    public Document documentFor(URL url) throws SAXParseException {
        try {
            InputStream stream = url.openStream();
            InputSource input = new InputSource(stream);
            input.setSystemId(url.toExternalForm());
            return this.builder.parse(input);
        }
        catch (SAXParseException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

