/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.messages;

import com.google.gwt.uibinder.rebind.IndentedWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenerateAnnotationWriter {
    private final String[] formats;
    private final String fileName;
    private final String[] locales;

    private static String toArgsList(List<String> strings) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                b.append(",\n  ");
            }
            b.append(s);
        }
        return b.toString();
    }

    private static String toArrayLiteral(String[] strings) {
        StringBuilder b = new StringBuilder("{");
        for (String s : strings) {
            b.append(String.format("\"%s\", ", s));
        }
        b.append('}');
        return b.toString();
    }

    public GenerateAnnotationWriter(String[] formats, String fileName, String[] locales) {
        this.formats = formats;
        this.fileName = fileName;
        this.locales = locales;
    }

    public void write(IndentedWriter w) {
        boolean hasLocales;
        boolean hasFormats = this.formats.length > 0;
        boolean hasFileName = this.fileName.length() > 0;
        boolean bl = hasLocales = this.locales.length > 0;
        if (hasFormats || hasFileName || hasLocales) {
            ArrayList<String> args = new ArrayList<String>();
            if (hasFormats) {
                args.add(String.format("format = %s", GenerateAnnotationWriter.toArrayLiteral(this.formats)));
            }
            if (hasFileName) {
                args.add(String.format("fileName = \"%s\"", this.fileName));
            }
            if (hasLocales) {
                args.add(String.format("locales = %s", GenerateAnnotationWriter.toArrayLiteral(this.locales)));
            }
            w.write("@Generate(");
            w.indent();
            w.write(GenerateAnnotationWriter.toArgsList(args));
            w.outdent();
            w.write(")");
        }
    }
}

