/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JTypeParameter;
import com.google.gwt.user.rebind.rpc.ProblemReport;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracleBuilder;
import com.google.gwt.user.rebind.rpc.TypeFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

class TypeParameterExposureComputer {
    static final int EXPOSURE_DIRECT = 0;
    static final int EXPOSURE_MIN_BOUNDED_ARRAY = 1;
    static final int EXPOSURE_NONE = -1;
    private TypeFilter typeFilter;
    private final Map<JTypeParameter, TypeParameterFlowInfo> typeParameterToFlowInfo = new IdentityHashMap<JTypeParameter, TypeParameterFlowInfo>();
    private final Set<TypeParameterFlowInfo> worklist = new LinkedHashSet<TypeParameterFlowInfo>();

    TypeParameterExposureComputer(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
    }

    public TypeParameterFlowInfo computeTypeParameterExposure(JGenericType type, int index) {
        JTypeParameter[] typeParameters = type.getTypeParameters();
        assert (index < typeParameters.length);
        JTypeParameter typeParameter = typeParameters[index];
        TypeParameterFlowInfo queryFlow = this.typeParameterToFlowInfo.get(typeParameter);
        if (queryFlow != null) {
            return queryFlow;
        }
        queryFlow = this.getFlowInfo(type, index);
        while (!this.worklist.isEmpty()) {
            TypeParameterFlowInfo info = this.worklist.iterator().next();
            this.worklist.remove(info);
            boolean didChange = info.updateFlowInfo();
            if (!didChange) continue;
            for (TypeParameterFlowInfo listener : info.getListeners()) {
                this.worklist.add(listener);
            }
        }
        return queryFlow;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
    }

    private TypeParameterFlowInfo getFlowInfo(JGenericType type, int index) {
        JTypeParameter typeParameter = type.getTypeParameters()[index];
        TypeParameterFlowInfo info = this.typeParameterToFlowInfo.get(typeParameter);
        if (info == null) {
            info = new TypeParameterFlowInfo(type, index);
            this.typeParameterToFlowInfo.put(typeParameter, info);
            this.worklist.add(info);
        }
        return info;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeParameterFlowInfo {
        private final JGenericType baseType;
        private final Map<TypeParameterFlowInfo, Integer> causesExposure = new LinkedHashMap<TypeParameterFlowInfo, Integer>();
        private int exposure = -1;
        private final Map<TypeParameterFlowInfo, Boolean> isTransitivelyAffectedByCache = new HashMap<TypeParameterFlowInfo, Boolean>();
        private final Set<TypeParameterFlowInfo> listeners = new LinkedHashSet<TypeParameterFlowInfo>();
        private boolean mightNotBeExposed = true;
        private final int ordinal;
        private boolean visited;

        TypeParameterFlowInfo(JGenericType baseType, int ordinal) {
            this.baseType = baseType;
            this.ordinal = ordinal;
        }

        public boolean checkDirectExposure() {
            boolean didChange = false;
            for (JGenericType type = this.baseType; type != null; type = type.getSuperclass()) {
                JField[] fields;
                if (!SerializableTypeOracleBuilder.shouldConsiderFieldsForSerialization((JClassType)type, TypeParameterExposureComputer.this.typeFilter, new ProblemReport())) continue;
                for (JField field : fields = type.getFields()) {
                    if (!SerializableTypeOracleBuilder.shouldConsiderForSerialization(TreeLogger.NULL, true, field) || field.getType().getLeafType() != this.getTypeParameter()) continue;
                    this.markExposedAsArray(0);
                    this.mightNotBeExposed = false;
                    didChange = true;
                    JArrayType fieldTypeAsArray = field.getType().isArray();
                    if (fieldTypeAsArray == null) continue;
                    this.markExposedAsArray(fieldTypeAsArray.getRank());
                }
            }
            return didChange;
        }

        public Map<TypeParameterFlowInfo, Integer> getCausesExposure() {
            return this.causesExposure;
        }

        public int getExposure() {
            return this.exposure;
        }

        public Set<TypeParameterFlowInfo> getListeners() {
            return this.listeners;
        }

        public boolean getMightNotBeExposed() {
            return this.mightNotBeExposed;
        }

        public boolean infiniteArrayExpansionPathBetween(TypeParameterFlowInfo other) {
            Integer dimensionDelta = this.getCausesExposure().get(other);
            if (dimensionDelta == null) {
                return false;
            }
            return dimensionDelta > 0 && other.isTransitivelyAffectedBy(this);
        }

        public String toString() {
            return this.getTypeParameter().getName() + " in " + this.baseType.getName();
        }

        public boolean updateFlowInfo() {
            boolean didChange = false;
            if (!this.wasVisited()) {
                didChange |= this.initializeExposure();
                this.markVisited();
            }
            for (Map.Entry<TypeParameterFlowInfo, Integer> entry : this.getCausesExposure().entrySet()) {
                TypeParameterFlowInfo info2 = entry.getKey();
                int dimensionDelta = entry.getValue();
                if (info2.getExposure() < 0 || this.infiniteArrayExpansionPathBetween(info2)) continue;
                didChange |= this.markExposedAsArray(dimensionDelta + info2.getExposure());
            }
            return didChange;
        }

        void addListener(TypeParameterFlowInfo listener) {
            this.listeners.add(listener);
        }

        JTypeParameter getTypeParameter() {
            return this.baseType.getTypeParameters()[this.ordinal];
        }

        boolean initializeExposure() {
            this.computeIndirectExposureCauses();
            return this.checkDirectExposure();
        }

        boolean isTransitivelyAffectedBy(TypeParameterFlowInfo flowInfo) {
            Boolean result = this.isTransitivelyAffectedByCache.get(flowInfo);
            if (result != null) {
                return result;
            }
            HashSet<TypeParameterFlowInfo> affectedBy = new HashSet<TypeParameterFlowInfo>();
            LinkedHashSet<? extends TypeParameterFlowInfo> affectedByWorklist = new LinkedHashSet<TypeParameterFlowInfo>();
            affectedByWorklist.add(this);
            result = false;
            while (!affectedByWorklist.isEmpty()) {
                TypeParameterFlowInfo currFlowInfo = (TypeParameterFlowInfo)affectedByWorklist.iterator().next();
                affectedByWorklist.remove(currFlowInfo);
                if (currFlowInfo == flowInfo) {
                    result = true;
                    break;
                }
                if (!affectedBy.add(currFlowInfo)) continue;
                affectedByWorklist.addAll(currFlowInfo.getAffectedBy());
            }
            this.isTransitivelyAffectedByCache.put(flowInfo, result);
            return result;
        }

        boolean markExposedAsArray(int dim) {
            if (this.exposure >= dim) {
                return false;
            }
            this.exposure = dim;
            return true;
        }

        void markVisited() {
            this.visited = true;
        }

        boolean wasVisited() {
            return this.visited;
        }

        private void computeIndirectExposureCauses() {
            JClassType[] subtypes;
            for (JClassType subtype : subtypes = this.baseType.getSubtypes()) {
                JGenericType isGeneric = subtype.isGenericType();
                if (isGeneric == null || !SerializableTypeOracleBuilder.shouldConsiderFieldsForSerialization(subtype, TypeParameterExposureComputer.this.typeFilter, new ProblemReport())) continue;
                JParameterizedType asParameterizationOf = subtype.asParameterizationOf(this.baseType);
                LinkedHashSet<JTypeParameter> paramsUsed = new LinkedHashSet<JTypeParameter>();
                SerializableTypeOracleBuilder.recordTypeParametersIn((JType)asParameterizationOf.getTypeArgs()[this.ordinal], paramsUsed);
                for (JTypeParameter paramUsed : paramsUsed) {
                    this.recordCausesExposure(isGeneric, paramUsed.getOrdinal(), 0);
                }
            }
            for (JGenericType type = this.baseType; type != null; type = type.getSuperclass()) {
                JField[] fields;
                if (!SerializableTypeOracleBuilder.shouldConsiderFieldsForSerialization((JClassType)type, TypeParameterExposureComputer.this.typeFilter, new ProblemReport())) continue;
                for (JField field : fields = type.getFields()) {
                    JParameterizedType isParameterized;
                    if (!SerializableTypeOracleBuilder.shouldConsiderForSerialization(TreeLogger.NULL, true, field) || (isParameterized = field.getType().getLeafType().isParameterized()) == null) continue;
                    JClassType[] typeArgs = isParameterized.getTypeArgs();
                    for (int i = 0; i < typeArgs.length; ++i) {
                        if (!this.referencesTypeParameter(typeArgs[i], this.getTypeParameter())) continue;
                        JGenericType genericFieldType = isParameterized.getBaseType();
                        this.recordCausesExposure(genericFieldType, i, 0);
                        JArrayType typeArgIsArray = typeArgs[i].isArray();
                        if (typeArgIsArray == null || typeArgIsArray.getLeafType() != this.getTypeParameter()) continue;
                        int dims = typeArgIsArray.getRank();
                        this.recordCausesExposure(genericFieldType, i, dims);
                    }
                }
            }
        }

        private Collection<? extends TypeParameterFlowInfo> getAffectedBy() {
            return this.causesExposure.keySet();
        }

        private TypeParameterFlowInfo getFlowInfo(JGenericType type, int index) {
            TypeParameterFlowInfo flowInfo = TypeParameterExposureComputer.this.getFlowInfo(type, index);
            flowInfo.addListener(this);
            return flowInfo;
        }

        private void recordCausesExposure(JGenericType type, int index, int level) {
            assert (index < type.getTypeParameters().length);
            TypeParameterFlowInfo flowInfo = this.getFlowInfo(type, index);
            Integer oldLevel = this.causesExposure.get(flowInfo);
            if (oldLevel == null || oldLevel < level) {
                this.causesExposure.put(flowInfo, level);
            }
        }

        private boolean referencesTypeParameter(JClassType classType, JTypeParameter typeParameter) {
            LinkedHashSet<JTypeParameter> typeParameters = new LinkedHashSet<JTypeParameter>();
            SerializableTypeOracleBuilder.recordTypeParametersIn((JType)classType, typeParameters);
            return typeParameters.contains(typeParameter);
        }
    }
}

