/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.tools.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatorUtilities {
    public static String appendPaths(String delimiter, List<String> paths) {
        if (paths == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String value : paths) {
            buf.append(delimiter);
            buf.append(value);
        }
        return buf.toString();
    }

    public static String createEclipseExtraLaunchPaths(List<String> extraClassPaths) throws FileNotFoundException {
        if (extraClassPaths == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String path : extraClassPaths) {
            File f = new File(path);
            if (!f.exists()) {
                throw new FileNotFoundException("extraClassPath: " + path + "Must be present before .launch file can be created");
            }
            String lcPath = path.toLowerCase();
            if (f.isDirectory()) {
                buf.append("<listEntry value=\"&lt;?xml version=&quot;1.0&quot; ");
                buf.append("encoding=&quot;UTF-8&quot; standalone=&quot;no&quot;");
                buf.append("?&gt;&#13;&#10;&lt;runtimeClasspathEntry ");
                buf.append("internalArchive=&quot;");
                buf.append(path);
                buf.append("&quot; path=&quot;3&quot; type=&quot;2&quot;/&gt;&#13;&#10;\"/>");
                buf.append("\n");
                continue;
            }
            if (lcPath.endsWith(".jar") || lcPath.endsWith(".zip")) {
                buf.append("<listEntry value=\"&lt;?xml version=&quot;1.0&quot; ");
                buf.append("encoding=&quot;UTF-8&quot;?&gt;&#13;&#10;&lt;runtimeClasspathEntry ");
                buf.append("externalArchive=&quot;");
                buf.append(path);
                buf.append("&quot; path=&quot;3&quot; type=&quot;2&quot;/&gt;&#13;&#10;\"/>");
                buf.append("\n");
                continue;
            }
            throw new RuntimeException("Don't know how to handle path: " + path + ". It doesn't appear to be a directory or a .jar/.zip file");
        }
        return buf.toString();
    }

    public static boolean isValidModuleName(String moduleName) {
        return moduleName.matches("[\\w]+(\\.[\\w]+)+");
    }

    public static boolean validatePathsAndModules(String userJar, List<String> pathList, List<String> moduleList) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (!CreatorUtilities.addURL(urlList, userJar)) {
            return false;
        }
        if (pathList != null) {
            for (String path : pathList) {
                if (CreatorUtilities.addURL(urlList, path)) continue;
                return false;
            }
        }
        final URL[] urlArray = urlList.toArray(new URL[urlList.size()]);
        URLClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(urlArray, CreatorUtilities.class.getClassLoader());
            }
        });
        if (moduleList != null) {
            for (String module : moduleList) {
                String modulePath = module.replace(".", "/") + ".gwt.xml";
                URL found = classLoader.getResource(modulePath);
                if (found != null) continue;
                System.err.println("Couldn't find module definition file " + modulePath + " in class path.");
                return false;
            }
        }
        return true;
    }

    private static boolean addURL(List<URL> urls, String pathToAdd) {
        File f = new File(pathToAdd);
        if (!pathToAdd.matches(".*gwt-user.jar") && !f.exists()) {
            System.err.println("Couldn't find library file or path " + pathToAdd);
            return false;
        }
        try {
            urls.add(f.toURI().toURL());
        }
        catch (MalformedURLException urlEx) {
            urlEx.printStackTrace();
            return false;
        }
        return true;
    }
}

