/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHover;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControlCreator;
import org.eclipse.mylyn.internal.reviews.ui.annotations.IReviewCompareSourceViewer;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.editors.ruler.CommentAnnotationRulerColumn;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.AnnotationColumn;
import org.eclipse.ui.internal.texteditor.PropertyEventDispatcher;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class ReviewCompareAnnotationModel {
    private final ReviewAnnotationModel leftAnnotationModel;
    private final ReviewAnnotationModel rightAnnotationModel;
    private CrucibleViewerTextInputListener leftViewerListener;
    private CrucibleViewerTextInputListener rightViewerListener;
    private final ITopic commentToFocus;
    private TextMergeViewer fMergeViewer;
    private MergeSourceViewer fRightSourceViewer;
    private MergeSourceViewer fLeftSourceViewer;

    private static SourceViewer getSourceViewer(MergeSourceViewer sourceViewer) {
        if (SourceViewer.class.isInstance(sourceViewer)) {
            return (SourceViewer)SourceViewer.class.cast(sourceViewer);
        }
        try {
            Method getSourceViewerRefl = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerRefl.setAccessible(true);
            Object returnValue = getSourceViewerRefl.invoke((Object)sourceViewer, new Object[0]);
            if (returnValue instanceof SourceViewer) {
                return (SourceViewer)returnValue;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public ReviewCompareAnnotationModel(IFileItem crucibleFile, ITopic commentToFocus) {
        this.leftAnnotationModel = new ReviewAnnotationModel(null, null, null, crucibleFile, crucibleFile.getBase());
        this.rightAnnotationModel = new ReviewAnnotationModel(null, null, null, crucibleFile, crucibleFile.getTarget());
        this.commentToFocus = commentToFocus;
    }

    public void attachToViewer(TextMergeViewer viewer, MergeSourceViewer fLeft, MergeSourceViewer fRight) {
        this.fMergeViewer = viewer;
        this.fLeftSourceViewer = fLeft;
        this.fRightSourceViewer = fRight;
        if (!this.isListenerFor(this.leftViewerListener, fLeft, this.leftAnnotationModel)) {
            this.leftViewerListener = this.addTextInputListener(fLeft, this.leftAnnotationModel, false);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ReviewCompareAnnotationModel.this.leftViewerListener.forceCustomAnnotationHover();
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching Crucible annotation hover", (Throwable)e));
                    }
                }
            });
        }
        if (!this.isListenerFor(this.rightViewerListener, fRight, this.rightAnnotationModel)) {
            this.rightViewerListener = this.addTextInputListener(fRight, this.rightAnnotationModel, true);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ReviewCompareAnnotationModel.this.rightViewerListener.forceCustomAnnotationHover();
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching Crucible annotation hover", (Throwable)e));
                    }
                }
            });
        }
    }

    private boolean isListenerFor(CrucibleViewerTextInputListener listener, MergeSourceViewer viewer, ReviewAnnotationModel annotationModel) {
        if (listener == null) {
            return false;
        }
        return listener.isListenerFor(viewer, annotationModel);
    }

    private CrucibleViewerTextInputListener addTextInputListener(MergeSourceViewer sourceViewer, ReviewAnnotationModel crucibleAnnotationModel, boolean oldFile) {
        CrucibleViewerTextInputListener listener = new CrucibleViewerTextInputListener(sourceViewer, crucibleAnnotationModel, oldFile);
        SourceViewer viewer = ReviewCompareAnnotationModel.getSourceViewer(sourceViewer);
        if (viewer != null) {
            viewer.addTextInputListener((ITextInputListener)listener);
        }
        return listener;
    }

    public void updateCrucibleFile(IReview newReview) {
    }

    public void focusOnComment() {
        this.focusOnComment(this.commentToFocus);
    }

    public void focusOnComment(ITopic commentToFocus) {
    }

    private void setActiveViewer(MergeSourceViewer focusViewer) {
        try {
            Method setActiveViewer = TextMergeViewer.class.getDeclaredMethod("setActiveViewer", MergeSourceViewer.class, Boolean.TYPE);
            setActiveViewer.setAccessible(true);
            setActiveViewer.invoke((Object)this.fMergeViewer, focusViewer, true);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Failed to activate viewer", (Throwable)e));
        }
    }

    public void registerContextMenu() {
        this.rightViewerListener.registerContextMenu();
        this.leftViewerListener.registerContextMenu();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.leftAnnotationModel == null ? 0 : this.leftAnnotationModel.hashCode());
        result = 31 * result + (this.rightAnnotationModel == null ? 0 : this.rightAnnotationModel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewCompareAnnotationModel other = (ReviewCompareAnnotationModel)obj;
        if (this.leftAnnotationModel == null ? other.leftAnnotationModel != null : !this.leftAnnotationModel.equals(other.leftAnnotationModel)) {
            return false;
        }
        return !(this.rightAnnotationModel == null ? other.rightAnnotationModel != null : !this.rightAnnotationModel.equals(other.rightAnnotationModel));
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CrucibleViewerTextInputListener
    implements ITextInputListener,
    IReviewCompareSourceViewer {
        private final SourceViewer sourceViewer;
        private final ReviewAnnotationModel crucibleAnnotationModel;
        private final boolean oldFile;
        private final MergeSourceViewer mergeSourceViewer;
        private String initialText;

        private CrucibleViewerTextInputListener(MergeSourceViewer sourceViewer, ReviewAnnotationModel crucibleAnnotationModel, boolean oldFile) {
            this.sourceViewer = ReviewCompareAnnotationModel.getSourceViewer(sourceViewer);
            this.mergeSourceViewer = sourceViewer;
            this.crucibleAnnotationModel = crucibleAnnotationModel;
            this.oldFile = oldFile;
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput != null) {
                this.crucibleAnnotationModel.disconnect(oldInput);
            }
            if (newInput != null && this.sourceViewer != null) {
                IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
                if (annotationModel instanceof IAnnotationModelExtension) {
                    IAnnotationModelExtension annotationModelExtension = (IAnnotationModelExtension)annotationModel;
                    annotationModelExtension.addAnnotationModel((Object)"test", (IAnnotationModel)this.crucibleAnnotationModel);
                    this.crucibleAnnotationModel.setEditorDocument(this.sourceViewer.getDocument());
                } else {
                    try {
                        Class<SourceViewer> sourceViewerClazz = SourceViewer.class;
                        Field declaredField2 = sourceViewerClazz.getDeclaredField("fVisualAnnotationModel");
                        declaredField2.setAccessible(true);
                        Method declaredMethod = sourceViewerClazz.getDeclaredMethod("createVisualAnnotationModel", IAnnotationModel.class);
                        declaredMethod.setAccessible(true);
                        annotationModel = (IAnnotationModel)declaredMethod.invoke((Object)this.sourceViewer, this.crucibleAnnotationModel);
                        declaredField2.set(this.sourceViewer, annotationModel);
                        annotationModel.connect(newInput);
                        this.sourceViewer.showAnnotations(true);
                        this.crucibleAnnotationModel.setEditorDocument(this.sourceViewer.getDocument());
                        this.createVerticalRuler(newInput, sourceViewerClazz);
                        this.createHighlighting(sourceViewerClazz);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching Crucible annotation model", t));
                    }
                }
            }
        }

        private void createHighlighting(Class<SourceViewer> sourceViewerClazz) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
            StyledText styledText = this.sourceViewer.getTextWidget();
            styledText.addLineBackgroundListener((LineBackgroundListener)new ColoringLineBackgroundListener(styledText));
        }

        private void createOverviewRuler(IDocument newInput, Class<SourceViewer> sourceViewerClazz) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.sourceViewer.setOverviewRulerAnnotationHover((IAnnotationHover)new CommentAnnotationHover(null));
            OverviewRuler ruler = new OverviewRuler((IAnnotationAccess)new DefaultMarkerAnnotationAccess(), 15, EditorsPlugin.getDefault().getSharedTextColors());
            Field compositeField = sourceViewerClazz.getDeclaredField("fComposite");
            compositeField.setAccessible(true);
            ruler.createControl((Composite)compositeField.get(this.sourceViewer), (ITextViewer)this.sourceViewer);
            ruler.setModel((IAnnotationModel)ReviewCompareAnnotationModel.this.leftAnnotationModel);
            ruler.update();
            Field overViewRulerField = sourceViewerClazz.getDeclaredField("fOverviewRuler");
            overViewRulerField.setAccessible(true);
            if (overViewRulerField.get(this.sourceViewer) == null) {
                overViewRulerField.set(this.sourceViewer, ruler);
            }
            Method declareMethod = sourceViewerClazz.getDeclaredMethod("ensureOverviewHoverManagerInstalled", new Class[0]);
            declareMethod.setAccessible(true);
            declareMethod.invoke((Object)this.sourceViewer, new Object[0]);
            Field hoverManager = sourceViewerClazz.getDeclaredField("fOverviewRulerHoveringController");
            hoverManager.setAccessible(true);
            AnnotationBarHoverManager manager = (AnnotationBarHoverManager)hoverManager.get(this.sourceViewer);
            if (manager != null) {
                Field annotationHover = AnnotationBarHoverManager.class.getDeclaredField("fAnnotationHover");
                annotationHover.setAccessible(true);
                IAnnotationHover cfr_ignored_0 = (IAnnotationHover)annotationHover.get(manager);
                annotationHover.set(manager, new CommentAnnotationHover(null));
            }
            this.sourceViewer.showAnnotations(true);
            this.sourceViewer.showAnnotationsOverview(true);
            declareMethod = sourceViewerClazz.getDeclaredMethod("showAnnotationsOverview", Boolean.TYPE);
            declareMethod.setAccessible(true);
        }

        private void createVerticalRuler(IDocument newInput, Class<SourceViewer> sourceViewerClazz) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
            this.forceCustomAnnotationHover();
            Method declaredMethod2 = sourceViewerClazz.getDeclaredMethod("getVerticalRuler", new Class[0]);
            declaredMethod2.setAccessible(true);
            CompositeRuler ruler = (CompositeRuler)declaredMethod2.invoke((Object)this.sourceViewer, new Object[0]);
            boolean hasDecorator = false;
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof AnnotationColumn)) continue;
                hasDecorator = true;
            }
            if (!hasDecorator) {
                AnnotationColumn annotationColumn = new AnnotationColumn();
                annotationColumn.createControl(ruler, ruler.getControl().getParent());
                ruler.addDecorator(0, (IVerticalRulerColumn)annotationColumn);
            }
        }

        public void forceCustomAnnotationHover() throws NoSuchFieldException, IllegalAccessException {
            Class<SourceViewer> sourceViewerClazz = SourceViewer.class;
            this.sourceViewer.setAnnotationHover((IAnnotationHover)new CommentAnnotationHover(null));
            try {
                Field hoverControlCreator = TextViewer.class.getDeclaredField("fHoverControlCreator");
                hoverControlCreator.setAccessible(true);
                hoverControlCreator.set(this.sourceViewer, new CommentInformationControlCreator());
            }
            catch (Throwable throwable) {}
            try {
                Method ensureMethod = sourceViewerClazz.getDeclaredMethod("ensureAnnotationHoverManagerInstalled", new Class[0]);
                ensureMethod.setAccessible(true);
                ensureMethod.invoke((Object)this.sourceViewer, new Object[0]);
            }
            catch (Throwable throwable) {}
            Field hoverManager = SourceViewer.class.getDeclaredField("fVerticalRulerHoveringController");
            hoverManager.setAccessible(true);
            AnnotationBarHoverManager manager = (AnnotationBarHoverManager)hoverManager.get(this.sourceViewer);
            if (manager != null) {
                Field annotationHover = AnnotationBarHoverManager.class.getDeclaredField("fAnnotationHover");
                annotationHover.setAccessible(true);
                IAnnotationHover hover = (IAnnotationHover)annotationHover.get(manager);
                annotationHover.set(manager, new CommentAnnotationHover(hover));
            }
            this.sourceViewer.showAnnotations(true);
            this.sourceViewer.showAnnotationsOverview(true);
        }

        @Override
        public void focusOnLines(ILocation range) {
            if (range instanceof ILineLocation) {
                IDocument document;
                ILineLocation lineLocation = (ILineLocation)range;
                int startLine = lineLocation.getTotalMin() - 1;
                int endLine = lineLocation.getTotalMax() - 1;
                if (this.sourceViewer != null && (document = this.sourceViewer.getDocument()) != null) {
                    try {
                        int offset = document.getLineOffset(startLine);
                        int length = document.getLineOffset(endLine) - offset;
                        StyledText widget = this.sourceViewer.getTextWidget();
                        try {
                            widget.setRedraw(false);
                            this.sourceViewer.setSelection((ISelection)new TextSelection(offset, length), true);
                        }
                        finally {
                            widget.setRedraw(true);
                        }
                    }
                    catch (BadLocationException e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", e.getMessage(), (Throwable)e));
                    }
                }
            }
        }

        @Override
        public void registerContextMenu() {
        }

        @Override
        public LineRange getSelection() {
            if (this.sourceViewer != null) {
                TextSelection selection = (TextSelection)this.sourceViewer.getSelection();
                return new LineRange(selection.getStartLine() + 1, selection.getEndLine() - selection.getStartLine());
            }
            return null;
        }

        public boolean isListenerFor(MergeSourceViewer viewer, ReviewAnnotationModel annotationModel) {
            return this.mergeSourceViewer == viewer && this.crucibleAnnotationModel == annotationModel;
        }

        private final class ColoringLineBackgroundListener
        implements LineBackgroundListener {
            private final StyledText styledText;
            private Color colorCommented;
            private PropertyEventDispatcher fDispatcher;

            private ColoringLineBackgroundListener(StyledText styledText) {
                this.styledText = styledText;
                this.initialize();
            }

            private void updateCommentedColor(AnnotationPreference pref, IPreferenceStore store) {
                if (pref != null) {
                    RGB rgb = CommentAnnotationRulerColumn.getColorFromAnnotationPreference(store, pref);
                    this.colorCommented = ReviewCompareAnnotationModel.this.getSharedColors().getColor(rgb);
                }
            }

            private void initialize() {
                final IPreferenceStore store = EditorsUI.getPreferenceStore();
                if (store == null) {
                    return;
                }
                AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
                final AnnotationPreference commentedPref = lookup.getAnnotationPreference("org.eclipse.mylyn.reviews.ui.comment.Annotation");
                this.updateCommentedColor(commentedPref, store);
                this.fDispatcher = new PropertyEventDispatcher(store);
                if (commentedPref != null) {
                    this.fDispatcher.addPropertyChangeListener(commentedPref.getColorPreferenceKey(), new IPropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent event) {
                            ColoringLineBackgroundListener.this.updateCommentedColor(commentedPref, store);
                        }
                    });
                }
            }

            public void lineGetBackground(LineBackgroundEvent event) {
                int documentOffset = 0;
                documentOffset = this.getDocumentOffset(event);
                int lineNr = this.styledText.getLineAtOffset(event.lineOffset) + 1 + documentOffset;
                Iterator<CommentAnnotation> it = CrucibleViewerTextInputListener.this.crucibleAnnotationModel.getAnnotationIterator();
                while (it.hasNext()) {
                    AnnotationPreference pref;
                    CommentAnnotation annotation = it.next();
                    ITopic comment = annotation.getTopic();
                    int startLine = ((ILineLocation)comment.getLocation()).getTotalMin();
                    int endLine = ((ILineLocation)comment.getLocation()).getTotalMax();
                    if (lineNr < startLine || lineNr > endLine || !(pref = new AnnotationPreferenceLookup().getAnnotationPreference((Annotation)annotation)).getHighlightPreferenceValue()) continue;
                    event.lineBackground = this.colorCommented;
                }
            }

            private int getDocumentOffset(LineBackgroundEvent event) {
                if (event.widget instanceof StyledText) {
                    String currentText = ((StyledText)event.widget).getText();
                    if (CrucibleViewerTextInputListener.this.initialText == null) {
                        CrucibleViewerTextInputListener.this.initialText = currentText;
                        return 0;
                    }
                    if (currentText.equals(CrucibleViewerTextInputListener.this.initialText)) {
                        return 0;
                    }
                    if (CrucibleViewerTextInputListener.this.initialText.contains(currentText)) {
                        int charoffset = CrucibleViewerTextInputListener.this.initialText.indexOf(currentText);
                        int lineOffset = 0;
                        String delimiter = ((StyledText)event.widget).getLineDelimiter();
                        String[] stringArray = CrucibleViewerTextInputListener.this.initialText.split(delimiter);
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String line = stringArray[n2];
                            if (charoffset <= 0) break;
                            charoffset -= line.length() + delimiter.length();
                            ++lineOffset;
                            ++n2;
                        }
                        return lineOffset;
                    }
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Could not find text offset for annotation highlighting - current text not contained in initial text."));
                }
                return 0;
            }
        }
    }
}

