/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.ruler;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.editors.ruler.CommentAnnotationRulerHover;
import org.eclipse.mylyn.reviews.internal.core.model.Review;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.texteditor.PropertyEventDispatcher;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentAnnotationRulerColumn
extends AbstractRulerColumn
implements IContributedRulerColumn {
    private RulerColumnDescriptor fDescriptor;
    private ReviewAnnotationModel annotationModel;
    private ITextEditor fEditor;
    private Color colorCommented;
    private ISourceViewer fViewer;
    private PropertyEventDispatcher fDispatcher;
    private IDocumentProvider fDocumentProvider;

    public CommentAnnotationRulerColumn() {
        this.setTextInset(10);
        this.setHover(new CommentAnnotationRulerHover(this));
    }

    public void dispose() {
        this.colorCommented.dispose();
        super.dispose();
    }

    public RulerColumnDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(RulerColumnDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    public void setEditor(ITextEditor editor) {
        this.fEditor = editor;
        this.fDocumentProvider = this.fEditor.getDocumentProvider();
    }

    public ITextEditor getEditor() {
        return this.fEditor;
    }

    public void columnCreated() {
    }

    public void columnRemoved() {
    }

    protected Color computeLeftBackground(int line) {
        List<CommentAnnotation> annotations = this.getAnnotations(line);
        if (annotations == null || annotations.size() == 0) {
            return super.computeBackground(line);
        }
        return this.colorCommented;
    }

    protected Color computeForeground(int line) {
        return Display.getDefault().getSystemColor(2);
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        gc.setBackground(this.computeLeftBackground(modelLine));
        gc.fillRectangle(0, linePixel, this.getWidth(), lineHeight);
    }

    public List<CommentAnnotation> getAnnotations(int startLine) {
        try {
            int offset = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput()).getLineOffset(startLine);
            return this.annotationModel == null ? null : this.annotationModel.getAnnotationsForOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    public static RGB getColorFromAnnotationPreference(IPreferenceStore store, AnnotationPreference pref) {
        String key = pref.getColorPreferenceKey();
        RGB rgb = null;
        if (store.contains(key)) {
            rgb = store.isDefault(key) ? pref.getColorPreferenceValue() : PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        }
        if (rgb == null) {
            rgb = pref.getColorPreferenceValue();
        }
        return rgb;
    }

    private void updateCommentedColor(AnnotationPreference pref, IPreferenceStore store) {
        if (pref != null) {
            RGB rgb = CommentAnnotationRulerColumn.getColorFromAnnotationPreference(store, pref);
            this.colorCommented = this.getSharedColors().getColor(rgb);
        }
    }

    private void initialize() {
        final IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (store == null) {
            return;
        }
        AnnotationPreferenceLookup lookup = EditorsUI.getAnnotationPreferenceLookup();
        final AnnotationPreference commentedPref = lookup.getAnnotationPreference("org.eclipse.mylyn.reviews.ui.comment.Annotation");
        this.updateCommentedColor(commentedPref, store);
        this.redraw();
        this.fDispatcher = new PropertyEventDispatcher(store);
        if (commentedPref != null) {
            this.fDispatcher.addPropertyChangeListener(commentedPref.getColorPreferenceKey(), new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    CommentAnnotationRulerColumn.this.updateCommentedColor(commentedPref, store);
                    CommentAnnotationRulerColumn.this.redraw();
                }
            });
        }
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        ITextViewer viewer = parentRuler.getTextViewer();
        Assert.isLegal((boolean)(viewer instanceof ISourceViewer));
        this.fViewer = (ISourceViewer)viewer;
        this.fViewer.showAnnotations(true);
        IAnnotationModel model = this.fViewer.getAnnotationModel();
        if (model == null) {
            this.fViewer.setDocument(this.fViewer.getDocument(), (IAnnotationModel)new AnnotationModel());
        }
        this.fViewer.getAnnotationModel().addAnnotationModelListener(new IAnnotationModelListener(){

            public void modelChanged(IAnnotationModel model) {
            }
        });
        this.initialize();
        return super.createControl(parentRuler, parentControl);
    }

    public void reviewActivated(ITask task, Review review) {
    }

    public void reviewDeactivated(ITask task, Review review) {
        this.annotationModel = null;
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                CommentAnnotationRulerColumn.this.redraw();
            }
        });
    }
}

