/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.i18n.client.impl.LocaleInfoImpl;
import com.google.gwt.i18n.rebind.CachedGeneratorContext;
import com.google.gwt.i18n.rebind.LocaleUtils;
import com.google.gwt.i18n.rebind.LocalizableGenerator;
import com.google.gwt.i18n.server.GwtLocaleImpl;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry.util.text.LocalizedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleInfoGenerator
extends Generator {
    private static final String GENERATED_LOCALE_NATIVE_DISPLAY_NAMES = "com/google/gwt/i18n/client/impl/cldr/LocaleNativeDisplayNames-generated.properties";
    private static final String MANUAL_LOCALE_NATIVE_DISPLAY_NAMES = "com/google/gwt/i18n/client/impl/cldr/LocaleNativeDisplayNames-manual.properties";
    private static final String OVERRIDE_LOCALE_NATIVE_DISPLAY_NAMES = "com/google/gwt/i18n/client/impl/cldr/LocaleNativeDisplayNames-override.properties";

    public final String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        JClassType targetClass;
        TypeOracle typeOracle = context.getTypeOracle();
        PropertyOracle propertyOracle = context.getPropertyOracle();
        LocaleUtils localeUtils = LocaleUtils.getInstance(logger, propertyOracle);
        try {
            targetClass = typeOracle.getType(typeName);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "No such type " + typeName, (Throwable)e);
            throw new UnableToCompleteException();
        }
        assert (LocaleInfoImpl.class.getName().equals(targetClass.getQualifiedSourceName()));
        String packageName = targetClass.getPackage().getName();
        String superClassName = targetClass.getName().replace('.', '_') + "_shared";
        Set<GwtLocale> localeSet = localeUtils.getAllLocales();
        Object[] allLocales = localeSet.toArray(new GwtLocaleImpl[localeSet.size()]);
        Arrays.sort(allLocales);
        PrintWriter pw = context.tryCreate(logger, packageName, superClassName);
        if (pw != null) {
            String qualName = packageName + "." + superClassName;
            ClassSourceFileComposerFactory factory = new ClassSourceFileComposerFactory(packageName, superClassName);
            factory.setSuperclass(targetClass.getQualifiedSourceName());
            factory.addImport("com.google.gwt.core.client.JavaScriptObject");
            SourceWriter writer = factory.createSourceWriter(context, pw);
            writer.println("private JavaScriptObject nativeDisplayNames;");
            writer.println();
            writer.println("@Override");
            writer.println("public String[] getAvailableLocaleNames() {");
            writer.println("  return new String[] {");
            for (Object possibleLocale : allLocales) {
                writer.println("    \"" + ((GwtLocaleImpl)possibleLocale).toString().replaceAll("\"", "\\\"") + "\",");
            }
            writer.println("  };");
            writer.println("}");
            writer.println();
            writer.println("@Override");
            writer.println("public native String getLocaleNativeDisplayName(String localeName) /*-{");
            writer.println("  this.@" + qualName + "::ensureNativeDisplayNames()();");
            writer.println("  return this.@" + qualName + "::nativeDisplayNames[localeName];");
            writer.println("}-*/;");
            writer.println();
            writer.println("private native void ensureNativeDisplayNames() /*-{");
            writer.println("  if (this.@" + qualName + "::nativeDisplayNames != null) {");
            writer.println("    return;");
            writer.println("  }");
            writer.println("  this.@" + qualName + "::nativeDisplayNames = {");
            LocalizedProperties displayNames = new LocalizedProperties();
            LocalizedProperties displayNamesManual = new LocalizedProperties();
            LocalizedProperties displayNamesOverride = new LocalizedProperties();
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                InputStream str = classLoader.getResourceAsStream(GENERATED_LOCALE_NATIVE_DISPLAY_NAMES);
                if (str != null) {
                    displayNames.load(str, "UTF-8");
                }
                if ((str = classLoader.getResourceAsStream(MANUAL_LOCALE_NATIVE_DISPLAY_NAMES)) != null) {
                    displayNamesManual.load(str, "UTF-8");
                }
                if ((str = classLoader.getResourceAsStream(OVERRIDE_LOCALE_NATIVE_DISPLAY_NAMES)) != null) {
                    displayNamesOverride.load(str, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.log(TreeLogger.ERROR, "UTF-8 encoding is not defined", (Throwable)e);
                throw new UnableToCompleteException();
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Exception reading locale display names", (Throwable)e);
                throw new UnableToCompleteException();
            }
            boolean needComma = false;
            for (Object possibleLocale : allLocales) {
                String localeName = ((GwtLocaleImpl)possibleLocale).toString();
                String displayName = displayNamesOverride.getProperty(localeName);
                if (displayName == null) {
                    displayName = displayNamesManual.getProperty(localeName);
                }
                if (displayName == null) {
                    displayName = displayNames.getProperty(localeName);
                }
                if (displayName == null || displayName.length() == 0) continue;
                localeName = this.quoteQuotes(localeName);
                displayName = this.quoteQuotes(displayName);
                if (needComma) {
                    writer.println(",");
                }
                writer.print("    \"" + localeName + "\": \"" + displayName + "\"");
                needComma = true;
            }
            if (needComma) {
                writer.println();
            }
            writer.println("  };");
            writer.println("}-*/;");
            writer.commit(logger);
        }
        GwtLocale locale = localeUtils.getCompileLocale();
        String className = targetClass.getName().replace('.', '_') + "_" + locale.getAsString();
        Set<GwtLocale> runtimeLocales = localeUtils.getRuntimeLocales();
        if (!runtimeLocales.isEmpty()) {
            className = className + "_runtimeSelection";
        }
        if ((pw = context.tryCreate(logger, packageName, className)) != null) {
            ClassSourceFileComposerFactory factory = new ClassSourceFileComposerFactory(packageName, className);
            factory.setSuperclass(superClassName);
            factory.addImport("com.google.gwt.core.client.GWT");
            factory.addImport("com.google.gwt.i18n.client.LocaleInfo");
            factory.addImport("com.google.gwt.i18n.client.constants.NumberConstants");
            factory.addImport("com.google.gwt.i18n.client.constants.NumberConstantsImpl");
            factory.addImport("com.google.gwt.i18n.client.constants.DateTimeConstants");
            factory.addImport("com.google.gwt.i18n.client.constants.DateTimeConstantsImpl");
            SourceWriter writer = factory.createSourceWriter(context, pw);
            writer.println("@Override");
            writer.println("public String getLocaleName() {");
            if (runtimeLocales.isEmpty()) {
                writer.println("  return \"" + locale + "\";");
            } else {
                writer.println("  String rtLocale = getRuntimeLocale();");
                writer.println("  return rtLocale != null ? rtLocale : \"" + locale + "\";");
            }
            writer.println("}");
            writer.println();
            writer.println("@Override");
            writer.println("public DateTimeConstants getDateTimeConstants() {");
            LocalizableGenerator localizableGenerator = new LocalizableGenerator();
            CachedGeneratorContext subContext = new CachedGeneratorContext(context);
            this.generateConstantsLookup(logger, subContext, writer, localizableGenerator, runtimeLocales, locale, "com.google.gwt.i18n.client.constants.DateTimeConstantsImpl");
            writer.println("}");
            writer.println();
            writer.println("@Override");
            writer.println("public NumberConstants getNumberConstants() {");
            this.generateConstantsLookup(logger, subContext, writer, localizableGenerator, runtimeLocales, locale, "com.google.gwt.i18n.client.constants.NumberConstantsImpl");
            writer.println("}");
            writer.commit(logger);
        }
        return packageName + "." + className;
    }

    private void generateConstantsLookup(TreeLogger logger, GeneratorContext context, SourceWriter writer, LocalizableGenerator localizableGenerator, Set<GwtLocale> runtimeLocales, GwtLocale locale, String typeName) throws UnableToCompleteException {
        writer.indent();
        boolean fetchedRuntimeLocale = false;
        HashMap<String, Set<GwtLocale>> localeMap = new HashMap<String, Set<GwtLocale>>();
        this.generateOneLocale(logger, context, localizableGenerator, typeName, localeMap, locale);
        for (GwtLocale gwtLocale : runtimeLocales) {
            this.generateOneLocale(logger, context, localizableGenerator, typeName, localeMap, gwtLocale);
        }
        if (localeMap.size() > 1) {
            for (Map.Entry entry : localeMap.entrySet()) {
                if (!fetchedRuntimeLocale) {
                    writer.println("String runtimeLocale = getLocaleName();");
                    fetchedRuntimeLocale = true;
                }
                writer.print("if (");
                boolean firstLocale = true;
                String generatedClass = (String)entry.getKey();
                for (GwtLocale runtimeLocale : (Set)entry.getValue()) {
                    if (firstLocale) {
                        firstLocale = false;
                    } else {
                        writer.println();
                        writer.print("    || ");
                    }
                    writer.print("\"" + ((Object)runtimeLocale).toString() + "\".equals(runtimeLocale)");
                }
                writer.println(") {");
                writer.println("  return new " + generatedClass + "();");
                writer.println("}");
            }
        }
        writer.println("return GWT.create(" + typeName + ".class);");
        writer.outdent();
    }

    private void generateOneLocale(TreeLogger logger, GeneratorContext context, LocalizableGenerator localizableGenerator, String typeName, Map<String, Set<GwtLocale>> localeMap, GwtLocale locale) throws UnableToCompleteException {
        String generatedClass = localizableGenerator.generate(logger, context, typeName, ((Object)locale).toString());
        if (generatedClass == null) {
            logger.log(TreeLogger.ERROR, "Failed to generate " + typeName + " in locale " + ((Object)locale).toString());
            return;
        }
        Set<GwtLocale> locales = localeMap.get(generatedClass);
        if (locales == null) {
            locales = new HashSet<GwtLocale>();
            localeMap.put(generatedClass, locales);
        }
        locales.add(locale);
    }

    private String quoteQuotes(String val) {
        return val.replace("\"", "\\\"");
    }
}

