/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind.format;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.i18n.client.PluralRule;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.AnnotationsResource;
import com.google.gwt.i18n.rebind.format.MessageCatalogFormat;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Set;

public class PropertiesFormat
implements MessageCatalogFormat {
    public String getExtension() {
        return ".properties";
    }

    public void write(TreeLogger logger, String locale, AbstractResource.ResourceList resourceList, PrintWriter out, JClassType messageInterface) {
        this.writeComment(out, "Generated from " + messageInterface.getQualifiedSourceName());
        if (locale != null) {
            this.writeComment(out, "for locale " + locale);
        }
        Set<String> keySet = resourceList.keySet();
        Object[] sortedKeys = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(sortedKeys);
        for (Object key : sortedKeys) {
            PluralRule.PluralForm[] pluralForms;
            out.println();
            AnnotationsResource annotResource = resourceList.getAnnotationsResource(logger, (String)key);
            if (annotResource != null) {
                this.writeAnnotComments(out, annotResource, (String)key);
            }
            if ((pluralForms = resourceList.getPluralForms((String)key)) != null) {
                for (PluralRule.PluralForm form : pluralForms) {
                    String name = form.getName();
                    if ("other".equals(name)) {
                        this.writeComment(out, "- " + form.getDescription());
                        this.write(out, (String)key, resourceList.getString((String)key));
                        continue;
                    }
                    String comment = "- plural form '" + form.getName() + "': " + form.getDescription();
                    if (!form.getWarnIfMissing()) {
                        comment = comment + " (optional)";
                    }
                    this.writeComment(out, comment);
                    String translated = resourceList.getStringExt((String)key, form.getName());
                    if (translated == null) {
                        translated = "";
                    }
                    this.write(out, (String)key + "[" + form.getName() + "]", translated);
                }
                continue;
            }
            this.write(out, (String)key, resourceList.getString((String)key));
        }
    }

    private String quoteKey(String str) {
        str = str.replace("\\", "\\\\");
        str = str.replace(" ", "\\ ");
        return this.quoteSpecial(str);
    }

    private String quoteSpecial(String str) {
        return str.replaceAll("([\f\t\n\r$!=:#])", "\\\\$1");
    }

    private String quoteValue(String str) {
        if ((str = str.replace("\\", "\\\\")).startsWith(" ")) {
            int n;
            for (n = 0; n < str.length() && str.charAt(n) == ' '; ++n) {
            }
            str = str.substring(n);
            while (n-- > 0) {
                str = "\\ " + str;
            }
        }
        return this.quoteSpecial(str);
    }

    private void write(PrintWriter out, String key, String value) {
        out.print(this.quoteKey(key));
        out.print('=');
        out.println(this.quoteValue(value));
    }

    private void writeAnnotComments(PrintWriter out, AnnotationsResource annotResource, String key) {
        String meaning;
        String desc = annotResource.getDescription(key);
        if (desc != null) {
            this.writeComment(out, "Description: " + desc);
        }
        if ((meaning = annotResource.getMeaning(key)) != null) {
            this.writeComment(out, "Meaning: " + meaning);
        }
        Iterable<AnnotationsResource.ArgumentInfo> arguments = annotResource.argumentsIterator(key);
        StringBuffer buf = new StringBuffer();
        if (arguments != null) {
            int i = 0;
            for (AnnotationsResource.ArgumentInfo argInfo : arguments) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(i++ + "=");
                buf.append(argInfo.name);
                boolean inParen = false;
                if (argInfo.optional) {
                    buf.append(" (Optional");
                    inParen = true;
                }
                if (argInfo.isPluralCount) {
                    if (inParen) {
                        buf.append("; ");
                    } else {
                        buf.append(" (");
                        inParen = true;
                    }
                    buf.append("Plural Count");
                }
                if (argInfo.example != null) {
                    if (inParen) {
                        buf.append("; ");
                    } else {
                        buf.append(" (");
                        inParen = true;
                    }
                    buf.append("Example: " + argInfo.example);
                }
                if (!inParen) continue;
                buf.append(')');
            }
            if (i > 0) {
                this.writeComment(out, buf.toString());
            }
        }
    }

    private void writeComment(PrintWriter out, String comment) {
        out.println("# " + comment);
    }
}

