/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.attributeparsers.CssNameConverter;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.model.ImplicitCssResource;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;

public class CssResourceWriter {
    private static final JType[] NO_PARAMS = new JType[0];
    private final ImplicitCssResource css;
    private final IndentedWriter writer;
    private final JClassType cssResourceType;
    private final JClassType stringType;
    private final CssNameConverter nameConverter;
    private final MortalLogger logger;

    public CssResourceWriter(ImplicitCssResource css, TypeOracle types, PrintWriter writer, MortalLogger logger) {
        this.css = css;
        this.writer = new IndentedWriter(writer);
        this.cssResourceType = types.findType(CssResource.class.getName());
        this.stringType = types.findType(String.class.getName());
        this.nameConverter = new CssNameConverter();
        this.logger = logger;
    }

    public void write() throws UnableToCompleteException {
        JClassType superType;
        String packageName = this.css.getPackageName();
        if (packageName.length() > 0) {
            this.writer.write("package %1$s;", packageName);
            this.writer.newline();
        }
        if ((superType = this.css.getExtendedInterface()) == null) {
            superType = this.cssResourceType;
        }
        this.writer.write("import %s;", superType.getQualifiedSourceName());
        this.writer.newline();
        this.writer.write("public interface %s extends %s {", this.css.getClassName(), superType.getSimpleSourceName());
        this.writer.indent();
        this.writeCssMethods(superType);
        this.writer.outdent();
        this.writer.write("}");
    }

    private boolean isOverride(String methodName, JClassType superType) {
        JMethod method = superType.findMethod(methodName, NO_PARAMS);
        return method != null && this.stringType.equals((Object)method.getReturnType());
    }

    private void writeCssMethods(JClassType superType) throws UnableToCompleteException {
        Set<String> rawClassNames = this.css.getCssClassNames();
        Map<String, String> convertedClassNames = null;
        try {
            convertedClassNames = this.nameConverter.convertSet(rawClassNames);
        }
        catch (CssNameConverter.Failure e) {
            this.logger.die(e.getMessage(), new Object[0]);
        }
        for (Map.Entry<String, String> entry : convertedClassNames.entrySet()) {
            String className = entry.getValue();
            if (this.isOverride(className, superType)) continue;
            if (!rawClassNames.contains(className)) {
                this.writer.write("@ClassName(\"%s\")", entry.getKey());
            }
            this.writer.write("String %s();", className);
        }
    }
}

