/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;

class ClassSourceFileComposer
implements SourceWriter {
    private static final String STAR_COMMENT_LINE = " * ";
    private boolean atStart;
    private String commentIndicator;
    private final GeneratorContext ctx;
    private boolean inComment;
    private int indent;
    private final PrintWriter printWriter;

    ClassSourceFileComposer(GeneratorContext ctx, PrintWriter printWriter, String targetPackageName, String[] annotationDeclarations, String targetClassShortName, String superClassName, String[] interfaceNames, String[] imports, ClassSourceFileComposerFactory.JavaSourceCategory category, String classJavaDocComment) {
        this.ctx = ctx;
        this.printWriter = printWriter;
        if (targetPackageName == null) {
            throw new IllegalArgumentException("Cannot supply a null package name to" + targetClassShortName);
        }
        if (targetPackageName.length() > 0) {
            this.println("package " + targetPackageName + ";");
        }
        if (imports != null && imports.length > 0) {
            this.println();
            int n = imports.length;
            for (int i = 0; i < n; ++i) {
                this.println("import " + imports[i] + ";");
            }
        }
        if (classJavaDocComment != null) {
            this.beginJavaDocComment();
            this.print(classJavaDocComment);
            this.endJavaDocComment();
        } else {
            this.println();
        }
        for (String annotation : annotationDeclarations) {
            this.println(annotation);
        }
        if (category == ClassSourceFileComposerFactory.JavaSourceCategory.CLASS) {
            this.emitClassDecl(targetClassShortName, superClassName, interfaceNames);
        } else {
            this.emitInterfaceDecl(targetClassShortName, superClassName, interfaceNames);
        }
        this.println(" {");
        this.indent();
    }

    public void beginJavaDocComment() {
        this.println("\n/**");
        this.inComment = true;
        this.commentIndicator = STAR_COMMENT_LINE;
    }

    public void commit(TreeLogger logger) {
        this.outdent();
        this.println("}");
        this.printWriter.close();
        if (this.ctx != null) {
            this.ctx.commit(logger, this.printWriter);
        }
    }

    public void endJavaDocComment() {
        this.inComment = false;
        this.println("\n */");
    }

    public void indent() {
        ++this.indent;
    }

    public void indentln(String s) {
        this.indent();
        this.println(s);
        this.outdent();
    }

    public void outdent() {
        --this.indent;
    }

    public void print(String s) {
        if (this.atStart) {
            for (int j = 0; j < this.indent; ++j) {
                this.printWriter.print("  ");
            }
            if (this.inComment) {
                this.printWriter.print(this.commentIndicator);
            }
            this.atStart = false;
        }
        String rest = null;
        int i = s.indexOf("\n");
        if (i > -1 && i < s.length() - 1) {
            rest = s.substring(i + 1);
            s = s.substring(0, i + 1);
        }
        this.printWriter.print(s);
        if (rest != null) {
            this.atStart = true;
            this.print(rest);
        }
    }

    public void println() {
        this.print("\n");
        this.atStart = true;
    }

    public void println(String s) {
        this.print(s + "\n");
        this.atStart = true;
    }

    private void emitClassDecl(String targetClassShortName, String superClassName, String[] interfaceNames) {
        this.print("public class " + targetClassShortName);
        if (superClassName != null) {
            this.print(" extends " + superClassName);
        }
        if (interfaceNames != null && interfaceNames.length > 0) {
            this.print(" implements ");
            int n = interfaceNames.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.print(", ");
                }
                this.print(interfaceNames[i]);
            }
        }
    }

    private void emitInterfaceDecl(String targetClassShortName, String superClassName, String[] interfaceNames) {
        if (superClassName != null) {
            throw new IllegalArgumentException("Cannot set superclass name " + superClassName + " on a interface.");
        }
        this.print("public interface " + targetClassShortName);
        if (interfaceNames != null && interfaceNames.length > 0) {
            this.print(" extends ");
            for (int i = 0; i < interfaceNames.length; ++i) {
                if (i > 0) {
                    this.print(", ");
                }
                this.print(interfaceNames[i]);
            }
        }
    }
}

