/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Shared {
    private static final String RPC_PROP_SUPPRESS_NON_STATIC_FINAL_FIELD_WARNINGS = "gwt.suppressNonStaticFinalFieldWarnings";
    private static final String RPC_ENHANCED_CLASSES = "rpc.enhancedClasses";

    Shared() {
    }

    static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
    }

    static Set<String> getEnhancedTypes(PropertyOracle propertyOracle) {
        try {
            ConfigurationProperty prop = propertyOracle.getConfigurationProperty(RPC_ENHANCED_CLASSES);
            return Collections.unmodifiableSet(new HashSet(prop.getValues()));
        }
        catch (BadPropertyValueException e) {
            return null;
        }
    }

    static String getStreamReadMethodNameFor(JType type) {
        return "read" + Shared.getCallSuffix(type);
    }

    static String getStreamWriteMethodNameFor(JType type) {
        return "write" + Shared.getCallSuffix(type);
    }

    static boolean shouldSuppressNonStaticFinalFieldWarnings(TreeLogger logger, PropertyOracle propertyOracle) {
        return Shared.getBooleanProperty(logger, propertyOracle, RPC_PROP_SUPPRESS_NON_STATIC_FINAL_FIELD_WARNINGS, false);
    }

    static String[] synthesizeTopLevelClassName(JClassType type, String suffix) {
        String packageName;
        String className;
        JType leafType = type.getLeafType();
        if (leafType.isPrimitive() != null) {
            className = leafType.getSimpleSourceName();
            packageName = "";
        } else {
            JClassType classOrInterface = leafType.isClassOrInterface();
            assert (classOrInterface != null);
            className = classOrInterface.getName();
            packageName = classOrInterface.getPackage().getName();
        }
        JArrayType isArray = type.isArray();
        if (isArray != null) {
            className = className + "_Array_Rank_" + isArray.getRank();
        }
        className = className + suffix;
        className = className.replace('.', '_');
        return new String[]{packageName, className};
    }

    static boolean typeNeedsCast(JType type) {
        return type.isPrimitive() == null && !type.getQualifiedSourceName().equals("java.lang.String") && !type.getQualifiedSourceName().equals("java.lang.Object");
    }

    private static boolean getBooleanProperty(TreeLogger logger, PropertyOracle propertyOracle, String propertyName, boolean defaultValue) {
        try {
            SelectionProperty prop = propertyOracle.getSelectionProperty(logger, propertyName);
            String propVal = prop.getCurrentValue();
            if (propVal != null && propVal.length() > 0) {
                return Boolean.valueOf(propVal);
            }
        }
        catch (BadPropertyValueException e) {
            // empty catch block
        }
        return defaultValue;
    }

    private static String getCallSuffix(JType type) {
        JParameterizedType isParameterized = type.isParameterized();
        if (isParameterized != null) {
            return Shared.getCallSuffix((JType)isParameterized.getRawType());
        }
        if (type.isPrimitive() != null) {
            if (type == JPrimitiveType.BOOLEAN) {
                return "Boolean";
            }
            if (type == JPrimitiveType.BYTE) {
                return "Byte";
            }
            if (type == JPrimitiveType.CHAR) {
                return "Char";
            }
            if (type == JPrimitiveType.DOUBLE) {
                return "Double";
            }
            if (type == JPrimitiveType.FLOAT) {
                return "Float";
            }
            if (type == JPrimitiveType.INT) {
                return "Int";
            }
            if (type == JPrimitiveType.LONG) {
                return "Long";
            }
            if (type == JPrimitiveType.SHORT) {
                return "Short";
            }
            return null;
        }
        if (type.getQualifiedSourceName().equals("java.lang.String")) {
            return "String";
        }
        return "Object";
    }
}

