/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.tools;

import com.google.gwt.dev.About;
import com.google.gwt.dev.ArgProcessorBase;
import com.google.gwt.dev.Compiler;
import com.google.gwt.dev.DevMode;
import com.google.gwt.dev.GwtVersion;
import com.google.gwt.dev.util.Util;
import com.google.gwt.user.tools.util.ArgHandlerIgnore;
import com.google.gwt.user.tools.util.ArgHandlerOverwrite;
import com.google.gwt.user.tools.util.CreatorUtilities;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerExtra;
import com.google.gwt.util.tools.ArgHandlerFlag;
import com.google.gwt.util.tools.ArgHandlerOutDir;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class WebAppCreator {
    private boolean ignore = false;
    private String moduleName;
    private boolean noEclipse;
    private boolean onlyEclipse;
    private File outDir;
    private boolean overwrite = false;
    private String junitPath = null;

    public static void main(String[] args) {
        WebAppCreator creator = new WebAppCreator();
        ArgProcessor argProcessor = creator.new ArgProcessor();
        if (argProcessor.processArgs(args) && creator.run()) {
            return;
        }
        System.exit(1);
    }

    protected void doRun() throws IOException {
        File file;
        String installPath = Utility.getInstallPath();
        String gwtUserPath = installPath + '/' + "gwt-user.jar";
        String gwtDevPath = installPath + '/' + "gwt-dev.jar";
        String gwtServletPath = installPath + '/' + "gwt-servlet.jar";
        String gwtOophmPath = installPath + '/' + "gwt-dev-oophm.jar";
        String gwtModuleDtd = "";
        GwtVersion gwtVersion = About.getGwtVersionObject();
        if (gwtVersion.isNoNagVersion()) {
            gwtModuleDtd = "\n<!DOCTYPE module PUBLIC \"-//Google Inc.//DTD Google Web Toolkit " + About.getGwtVersionNum() + "//EN\" \"http://google-web-toolkit.googlecode.com/svn/tags/" + About.getGwtVersionNum() + "/distro-source/core/src/gwt-module.dtd\">";
        }
        int pos = this.moduleName.lastIndexOf(46);
        String modulePackageName = this.moduleName.substring(0, pos);
        String moduleShortName = this.moduleName.substring(pos + 1);
        if (this.junitPath == null) {
            System.err.println("Not creating tests because -junit argument was not specified.\n");
        }
        File srcDir = Utility.getDirectory((File)this.outDir, (String)"src", (boolean)true);
        File warDir = Utility.getDirectory((File)this.outDir, (String)"war", (boolean)true);
        File webInfDir = Utility.getDirectory((File)warDir, (String)"WEB-INF", (boolean)true);
        File libDir = Utility.getDirectory((File)webInfDir, (String)"lib", (boolean)true);
        File moduleDir = Utility.getDirectory((File)srcDir, (String)modulePackageName.replace('.', '/'), (boolean)true);
        File clientDir = Utility.getDirectory((File)moduleDir, (String)"client", (boolean)true);
        File serverDir = Utility.getDirectory((File)moduleDir, (String)"server", (boolean)true);
        File sharedDir = Utility.getDirectory((File)moduleDir, (String)"shared", (boolean)true);
        File moduleTestDir = Utility.getDirectory((File)this.outDir, (String)("test/" + modulePackageName.replace('.', '/')), (boolean)true);
        File clientTestDir = Utility.getDirectory((File)moduleTestDir, (String)"client", (boolean)true);
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("@moduleShortName", moduleShortName);
        replacements.put("@moduleName", this.moduleName);
        replacements.put("@clientPackage", modulePackageName + ".client");
        replacements.put("@serverPackage", modulePackageName + ".server");
        replacements.put("@sharedPackage", modulePackageName + ".shared");
        replacements.put("@gwtSdk", installPath);
        replacements.put("@gwtUserPath", gwtUserPath);
        replacements.put("@gwtDevPath", gwtDevPath);
        replacements.put("@gwtOophmPath", gwtOophmPath);
        replacements.put("@gwtVersion", About.getGwtVersionNum());
        replacements.put("@gwtModuleDtd", gwtModuleDtd);
        replacements.put("@shellClass", DevMode.class.getName());
        replacements.put("@compileClass", Compiler.class.getName());
        replacements.put("@startupUrl", moduleShortName + ".html");
        replacements.put("@renameTo", moduleShortName.toLowerCase());
        String antEclipseRule = "";
        antEclipseRule = this.noEclipse ? "\n\n  <target name=\"eclipse.generate\" depends=\"libs\" description=\"Generate eclipse project\">\n    <java failonerror=\"true\" fork=\"true\" classname=\"" + this.getClass().getName() + "\">\n" + "      <classpath>\n" + "        <path refid=\"project.class.path\"/>\n" + "      </classpath>\n" + "      <arg value=\"-XonlyEclipse\"/>\n" + "      <arg value=\"-ignore\"/>\n" + "      <arg value=\"" + this.moduleName + "\"/>\n" + "    </java>\n" + "  </target>" : "";
        replacements.put("@antEclipseRule", antEclipseRule);
        String testTargetsBegin = "";
        String testTargetsEnd = "";
        String junitJarPath = this.junitPath;
        String eclipseTestDir = "";
        if (this.junitPath != null) {
            eclipseTestDir = "\n   <classpathentry kind=\"src\" path=\"test\"/>";
        } else {
            testTargetsBegin = "\n<!--\nTest targets suppressed because -junit argument was not specified when running webAppCreator.\n";
            testTargetsEnd = "-->\n";
            junitJarPath = "path_to_the_junit_jar";
        }
        replacements.put("@testTargetsBegin", testTargetsBegin);
        replacements.put("@testTargetsEnd", testTargetsEnd);
        replacements.put("@junitJar", junitJarPath);
        replacements.put("@eclipseTestDir", eclipseTestDir);
        ArrayList<FileCreator> files = new ArrayList<FileCreator>();
        ArrayList<FileCreator> libs = new ArrayList<FileCreator>();
        if (!this.onlyEclipse) {
            files.add(new FileCreator(moduleDir, moduleShortName + ".gwt.xml", "Module.gwt.xml"));
            files.add(new FileCreator(warDir, moduleShortName + ".html", "AppHtml.html"));
            files.add(new FileCreator(warDir, moduleShortName + ".css", "AppCss.css"));
            files.add(new FileCreator(webInfDir, "web.xml", "web.xml"));
            files.add(new FileCreator(clientDir, moduleShortName + ".java", "AppClassTemplate.java"));
            files.add(new FileCreator(clientDir, "GreetingService.java", "RpcClientTemplate.java"));
            files.add(new FileCreator(clientDir, "GreetingServiceAsync.java", "RpcAsyncClientTemplate.java"));
            files.add(new FileCreator(serverDir, "GreetingServiceImpl.java", "RpcServerTemplate.java"));
            files.add(new FileCreator(sharedDir, "FieldVerifier.java", "SharedClassTemplate.java"));
            files.add(new FileCreator(this.outDir, "build.xml", "project.ant.xml"));
            files.add(new FileCreator(this.outDir, "README.txt", "README.txt"));
            if (this.junitPath != null) {
                files.add(new FileCreator(moduleTestDir, moduleShortName + "JUnit.gwt.xml", "JUnit.gwt.xml"));
                files.add(new FileCreator(clientTestDir, moduleShortName + "Test" + ".java", "JUnitClassTemplate.java"));
            }
        }
        if (!this.noEclipse) {
            assert (new File(gwtDevPath).isAbsolute());
            libs.add(new FileCreator(libDir, "gwt-servlet.jar", gwtServletPath));
            files.add(new FileCreator(this.outDir, ".project", ".project"));
            files.add(new FileCreator(this.outDir, ".classpath", ".classpath"));
            files.add(new FileCreator(this.outDir, moduleShortName + ".launch", "App.launch"));
            if (this.junitPath != null) {
                files.add(new FileCreator(this.outDir, moduleShortName + "Test-dev.launch", "JUnit-dev.launch"));
                files.add(new FileCreator(this.outDir, moduleShortName + "Test-prod.launch", "JUnit-prod.launch"));
            }
        }
        for (FileCreator fileCreator : files) {
            URL url = WebAppCreator.class.getResource(fileCreator.sourceName + "src");
            if (url == null) {
                throw new FileNotFoundException(fileCreator.sourceName + "src");
            }
            file = Utility.createNormalFile((File)fileCreator.destDir, (String)fileCreator.destName, (boolean)this.overwrite, (boolean)this.ignore);
            if (file == null) continue;
            String data = Util.readURLAsString((URL)url);
            Utility.writeTemplateFile((File)file, (String)data, replacements);
        }
        for (FileCreator fileCreator : libs) {
            FileInputStream is = new FileInputStream(fileCreator.sourceName);
            file = Utility.createNormalFile((File)fileCreator.destDir, (String)fileCreator.destName, (boolean)this.overwrite, (boolean)this.ignore);
            if (file == null) continue;
            FileOutputStream os = new FileOutputStream(file);
            Util.copy((InputStream)is, (OutputStream)os);
        }
    }

    protected boolean run() {
        try {
            this.doRun();
            return true;
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
    }

    private final class ArgHandlerIgnoreExtension
    extends ArgHandlerIgnore {
        private ArgHandlerIgnoreExtension() {
        }

        public boolean setFlag() {
            if (WebAppCreator.this.overwrite) {
                System.err.println("-ignore cannot be used with -overwrite");
                return false;
            }
            WebAppCreator.this.ignore = true;
            return true;
        }
    }

    private final class ArgHandlerJUnitPath
    extends ArgHandlerString {
        private ArgHandlerJUnitPath() {
        }

        public String[] getDefaultArgs() {
            return null;
        }

        public String getPurpose() {
            return "Specifies the path to your junit.jar (optional)";
        }

        public String getTag() {
            return "-junit";
        }

        public String[] getTagArgs() {
            return new String[]{"pathToJUnitJar"};
        }

        public boolean isRequired() {
            return false;
        }

        public boolean setString(String str) {
            File f = new File(str);
            if (!f.exists() || !f.isFile()) {
                System.err.println("File not found: " + str);
                return false;
            }
            WebAppCreator.this.junitPath = str;
            return true;
        }
    }

    private final class ArgHandlerModuleName
    extends ArgHandlerExtra {
        private ArgHandlerModuleName() {
        }

        public boolean addExtraArg(String arg) {
            if (WebAppCreator.this.moduleName != null) {
                System.err.println("Too many arguments.");
                return false;
            }
            if (!CreatorUtilities.isValidModuleName(arg)) {
                System.err.println("'" + arg + "' does not appear to be a valid fully-qualified Java class name.");
                return false;
            }
            WebAppCreator.this.moduleName = arg;
            return true;
        }

        public String getPurpose() {
            return "The name of the module to create (e.g. com.example.myapp.MyApp)";
        }

        public String[] getTagArgs() {
            return new String[]{"moduleName"};
        }

        public boolean isRequired() {
            return true;
        }
    }

    private final class ArgHandlerNoEclipse
    extends ArgHandlerFlag {
        private ArgHandlerNoEclipse() {
        }

        public String getPurpose() {
            return "Do not generate eclipse files";
        }

        public String getTag() {
            return "-XnoEclipse";
        }

        public boolean isUndocumented() {
            return true;
        }

        public boolean setFlag() {
            WebAppCreator.this.noEclipse = true;
            return true;
        }
    }

    private final class ArgHandlerOnlyEclipse
    extends ArgHandlerFlag {
        private ArgHandlerOnlyEclipse() {
        }

        public String getPurpose() {
            return "Generate only eclipse files";
        }

        public String getTag() {
            return "-XonlyEclipse";
        }

        public boolean isUndocumented() {
            return true;
        }

        public boolean setFlag() {
            WebAppCreator.this.onlyEclipse = true;
            return true;
        }
    }

    private final class ArgHandlerOverwriteExtension
    extends ArgHandlerOverwrite {
        private ArgHandlerOverwriteExtension() {
        }

        public boolean setFlag() {
            if (WebAppCreator.this.ignore) {
                System.err.println("-overwrite cannot be used with -ignore");
                return false;
            }
            WebAppCreator.this.overwrite = true;
            return true;
        }
    }

    class ArgProcessor
    extends ArgProcessorBase {
        public ArgProcessor() {
            this.registerHandler((ArgHandler)new ArgHandlerOverwriteExtension());
            this.registerHandler((ArgHandler)new ArgHandlerIgnoreExtension());
            this.registerHandler((ArgHandler)new ArgHandlerModuleName());
            this.registerHandler((ArgHandler)new ArgHandlerOutDirExtension());
            this.registerHandler((ArgHandler)new ArgHandlerNoEclipse());
            this.registerHandler((ArgHandler)new ArgHandlerOnlyEclipse());
            this.registerHandler((ArgHandler)new ArgHandlerJUnitPath());
        }

        protected String getName() {
            return WebAppCreator.class.getName();
        }

        private final class ArgHandlerOutDirExtension
        extends ArgHandlerOutDir {
            private ArgHandlerOutDirExtension() {
            }

            public void setDir(File dir) {
                WebAppCreator.this.outDir = dir;
            }
        }
    }

    private static final class FileCreator {
        private final File destDir;
        private final String destName;
        private final String sourceName;

        public FileCreator(File destDir, String destName, String sourceName) {
            this.destDir = destDir;
            this.sourceName = sourceName;
            this.destName = destName;
        }
    }
}

