/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.PatchSetPublishDetail;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.fetch.FetchGerritChangeWizard;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritPatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.egit.GerritProjectToGitRepositoryMapping;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.editor.AbstractGerritSection;
import org.eclipse.mylyn.internal.gerrit.ui.editor.ReviewItemLabelProvider;
import org.eclipse.mylyn.internal.gerrit.ui.operations.AbandonDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.PublishDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.RestoreDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.SubmitDialog;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewCompareAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.operations.ReviewCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.reviews.ui.ReviewUi;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PatchSetSection
extends AbstractGerritSection {
    private Composite composite;
    private final List<Job> jobs;
    private FormToolkit toolkit;
    private int addedDrafts;

    public PatchSetSection() {
        this.setPartName("Patch Sets");
        this.jobs = new ArrayList<Job>();
    }

    public void dispose() {
        for (Job job : this.jobs) {
            job.cancel();
        }
        super.dispose();
    }

    public String getTextClientText(PatchSetDetail patchSetDetail) {
        int numComments = this.getNumComments(patchSetDetail);
        if (numComments > 0) {
            return NLS.bind((String)"{0} Comments", (Object)numComments);
        }
        return " ";
    }

    public void initialize(AbstractTaskEditorPage taskEditorPage) {
        super.initialize(taskEditorPage);
    }

    private Composite createActions(final ChangeDetail changeDetail, final PatchSetDetail patchSetDetail, final PatchSetPublishDetail publishDetail, Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.spacing = 10;
        buttonComposite.setLayout((Layout)layout);
        boolean canPublish = this.getTaskData().getAttributeMapper().getBooleanValue(this.getTaskData().getRoot().getAttribute(GerritTaskSchema.getDefault().CAN_PUBLISH.getKey()));
        boolean canSubmit = false;
        if (changeDetail.getCurrentActions() != null) {
            canSubmit = changeDetail.getCurrentActions().contains(ApprovalCategory.SUBMIT);
        }
        if (canPublish) {
            Button publishButton = this.toolkit.createButton(buttonComposite, "Publish Comments...", 8);
            publishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchSetSection.this.doPublish(publishDetail);
                }
            });
        }
        Button fetchButton = this.toolkit.createButton(buttonComposite, "Fetch...", 8);
        fetchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatchSetSection.this.doFetch(changeDetail, patchSetDetail);
            }
        });
        if (canSubmit) {
            Button submitButton = this.toolkit.createButton(buttonComposite, "Submit", 8);
            submitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PatchSetSection.this.doSubmit(patchSetDetail.getPatchSet());
                }
            });
        }
        if (changeDetail != null && changeDetail.isCurrentPatchSet(patchSetDetail)) {
            if (changeDetail.canAbandon()) {
                Button abondonButton = this.toolkit.createButton(buttonComposite, "Abandon...", 8);
                abondonButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PatchSetSection.this.doAbandon(patchSetDetail.getPatchSet());
                    }
                });
            } else if (changeDetail.canRestore()) {
                Button restoreButton = this.toolkit.createButton(buttonComposite, "Restore...", 8);
                restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        PatchSetSection.this.doRestore(patchSetDetail.getPatchSet());
                    }
                });
            }
        }
        return buttonComposite;
    }

    private void createSubSection(final ChangeDetail changeDetail, final PatchSetDetail patchSetDetail, final PatchSetPublishDetail publishDetail, Section section) {
        int style = 8210;
        if (changeDetail.isCurrentPatchSet(patchSetDetail)) {
            style |= 0x40;
        }
        final Section subSection = this.toolkit.createSection(this.composite, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setText(NLS.bind((String)"Patch Set {0}", (Object)patchSetDetail.getPatchSet().getId().get()));
        String message = this.getTextClientText(patchSetDetail);
        this.addTextClient(this.toolkit, subSection, message);
        if (subSection.isExpanded()) {
            this.createSubSectionContents(changeDetail, patchSetDetail, publishDetail, subSection);
        }
        subSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (subSection.getClient() == null) {
                    PatchSetSection.this.createSubSectionContents(changeDetail, patchSetDetail, publishDetail, subSection);
                }
            }
        });
    }

    private int getNumComments(PatchSetDetail patchSetDetail) {
        int numComments = 0;
        for (Patch patch : patchSetDetail.getPatches()) {
            numComments += patch.getCommentCount();
        }
        return numComments;
    }

    private void subSectionExpanded(final PatchSetDetail patchSetDetail, final Section composite, final Viewer viewer) {
        final Label progressLabel = (Label)composite.getTextClient();
        progressLabel.setText("  Caching contents...");
        progressLabel.setVisible(true);
        final GetPatchSetContentJob job = new GetPatchSetContentJob(this.getTaskEditorPage().getTaskRepository(), patchSetDetail);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PatchSetSection.this.getControl() != null && !PatchSetSection.this.getControl().isDisposed()) {
                            GerritPatchSetContent content;
                            if (event.getResult().isOK() && (content = job.getPatchSetContent()) != null && content.getPatchScriptByPatchKey() != null) {
                                List items = GerritUtil.toReviewItems((PatchSetDetail)patchSetDetail, (Map)content.getPatchScriptByPatchKey());
                                viewer.setInput((Object)items);
                            }
                            progressLabel.setText("  " + PatchSetSection.this.getTextClientText(patchSetDetail));
                            progressLabel.setVisible(!composite.isExpanded());
                            PatchSetSection.this.getTaskEditorPage().reflow();
                        }
                    }
                });
            }
        });
        this.jobs.add(job);
        job.schedule();
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(this.composite);
        GerritChange change = GerritUtil.getChange((TaskData)this.getTaskData());
        if (change != null) {
            for (PatchSetDetail patchSetDetail : change.getPatchSetDetails()) {
                PatchSet.Id patchSetId = patchSetDetail.getPatchSet().getId();
                PatchSetPublishDetail publishDetail = (PatchSetPublishDetail)change.getPublishDetailByPatchSetId().get(patchSetId);
                this.createSubSection(change.getChangeDetail(), patchSetDetail, publishDetail, this.getSection());
            }
        }
        return this.composite;
    }

    protected void doAbandon(PatchSet patchSet) {
        AbandonDialog dialog = new AbandonDialog(this.getShell(), this.getTask(), patchSet);
        this.openOperationDialog(dialog);
    }

    protected void doPublish(PatchSetPublishDetail publishDetail) {
        PublishDialog dialog = new PublishDialog(this.getShell(), this.getTask(), publishDetail, this.addedDrafts);
        this.openOperationDialog(dialog);
    }

    protected void doFetch(ChangeDetail changeDetail, PatchSetDetail patchSetDetail) {
        String gerritProject;
        String gerritHost = this.getGerritHost(this.getGerritUrl());
        Repository repository = this.findGitRepository(gerritHost, gerritProject = this.getGerritProject(changeDetail));
        if (repository != null) {
            String refName = patchSetDetail.getPatchSet().getRefName();
            FetchGerritChangeWizard wizard = new FetchGerritChangeWizard(repository, refName);
            WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            wizardDialog.setHelpAvailable(false);
            wizardDialog.open();
        } else {
            String message = "No Git repository found for fetching Gerrit change " + this.getTask().getTaskKey();
            String reason = "No remote config found that has fetch URL with host '" + gerritHost + "' and path matching '" + gerritProject + "'";
            GerritCorePlugin.logError((String)message, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Gerrit Fetch Change Error", (String)message, (IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", reason));
        }
    }

    protected Repository findGitRepository(String gerritHost, String gerritProject) {
        try {
            if (gerritHost != null && gerritProject != null) {
                GerritProjectToGitRepositoryMapping mapper = new GerritProjectToGitRepositoryMapping(gerritHost, gerritProject);
                return mapper.findRepository();
            }
        }
        catch (IOException e) {
            GerritCorePlugin.logWarning((String)"Error accessing Git repository", (Throwable)e);
        }
        return null;
    }

    private String getGerritProject(ChangeDetail changeDetail) {
        return changeDetail.getChange().getProject().get();
    }

    private String getGerritUrl() {
        return this.getTaskEditorPage().getTaskRepository().getRepositoryUrl();
    }

    private String getGerritHost(String gerritUrl) {
        try {
            return new URL(gerritUrl).getHost();
        }
        catch (MalformedURLException e) {
            GerritCorePlugin.logWarning((String)("Error in task repository URL " + gerritUrl), (Throwable)e);
            return null;
        }
    }

    protected void doRestore(PatchSet patchSet) {
        RestoreDialog dialog = new RestoreDialog(this.getShell(), this.getTask(), patchSet);
        this.openOperationDialog(dialog);
    }

    protected void doSubmit(PatchSet patchSet) {
        SubmitDialog dialog = new SubmitDialog(this.getShell(), this.getTask(), patchSet);
        this.openOperationDialog(dialog);
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }

    void createSubSectionContents(ChangeDetail changeDetail, PatchSetDetail patchSetDetail, PatchSetPublishDetail publishDetail, Section subSection) {
        Composite composite = this.toolkit.createComposite((Composite)subSection);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        subSection.setClient((Control)composite);
        TableViewer viewer = new TableViewer(composite, 268438020);
        GridDataFactory.fillDefaults().grab(true, true).hint(500, -1).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            private EContentAdapter modelAdapter;

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
                if (oldInput instanceof List && this.modelAdapter != null) {
                    for (Object item : (List)oldInput) {
                        ((EObject)item).eAdapters().remove((Object)this.modelAdapter);
                    }
                    PatchSetSection.this.addedDrafts = 0;
                }
                if (newInput instanceof List) {
                    this.modelAdapter = new EContentAdapter(){

                        public void notifyChanged(Notification notification) {
                            if (notification.getEventType() == 3) {
                                viewer.refresh();
                                PatchSetSection patchSetSection = PatchSetSection.this;
                                patchSetSection.addedDrafts = patchSetSection.addedDrafts + 1;
                            }
                        }
                    };
                    for (Object item : (List)newInput) {
                        ((EObject)item).eAdapters().add((Object)this.modelAdapter);
                    }
                }
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ReviewItemLabelProvider()));
        viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IFileItem item = (IFileItem)selection.getFirstElement();
                ReviewUi.setActiveReview((ReviewBehavior)new GerritReviewBehavior(PatchSetSection.this.getTask(), item));
                ReviewCompareAnnotationModel model = new ReviewCompareAnnotationModel(item, null);
                CompareConfiguration configuration = new CompareConfiguration();
                if (item.getBase() != null && item.getTarget() != null) {
                    CompareUI.openCompareEditor((CompareEditorInput)new ReviewCompareEditorInput(item, model, configuration));
                } else {
                    PatchSetSection.this.getTaskEditorPage().getEditor().setMessage("The selected file is not available, yet", 2);
                }
            }
        });
        List items = GerritUtil.toReviewItems((PatchSetDetail)patchSetDetail, null);
        viewer.setInput((Object)items);
        this.createActions(changeDetail, patchSetDetail, publishDetail, composite);
        this.subSectionExpanded(patchSetDetail, subSection, (Viewer)viewer);
        this.getTaskEditorPage().reflow();
    }

    private class GetPatchSetContentJob
    extends Job {
        private GerritPatchSetContent patchSetContent;
        private final PatchSetDetail patchSetDetail;
        private final TaskRepository repository;

        public GetPatchSetContentJob(TaskRepository repository, PatchSetDetail patchSetDetail) {
            super("Caching Patch Set Content");
            this.repository = repository;
            this.patchSetDetail = patchSetDetail;
        }

        public GerritPatchSetContent getPatchSetContent() {
            return this.patchSetContent;
        }

        protected IStatus run(IProgressMonitor monitor) {
            GerritConnector connector = (GerritConnector)TasksUi.getRepositoryConnector((String)this.repository.getConnectorKind());
            GerritClient client = connector.getClient(this.repository);
            try {
                int reviewId = this.patchSetDetail.getInfo().getKey().getParentKey().get();
                this.patchSetContent = client.getPatchSetContent(String.valueOf(reviewId), this.patchSetDetail.getPatchSet().getId().get(), monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
            catch (GerritException e) {
                return new Status(4, "org.eclipse.mylyn.gerrit.ui", "Review retrieval failed", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

