/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.ApprovalDetail;
import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.reviewdb.ApprovalCategory;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.ui.editor.AbstractGerritSection;
import org.eclipse.mylyn.internal.gerrit.ui.operations.AddReviewersDialog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ReviewSection
extends AbstractGerritSection {
    private Composite composite;
    private FormToolkit toolkit;

    public ReviewSection() {
        this.setPartName("Review");
    }

    protected Control createContent(FormToolkit toolkit, Composite parent) {
        this.toolkit = toolkit;
        this.composite = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(this.composite);
        GerritChange review = GerritUtil.getChange((TaskData)this.getTaskData());
        if (review != null) {
            this.createReviewContent(toolkit, this.composite, review.getChangeDetail());
        }
        return this.composite;
    }

    private void createReviewContent(FormToolkit toolkit, Composite composite, ChangeDetail changeDetail) {
        GerritConfig config = this.getConfig();
        this.createPeopleSubSection(composite, changeDetail, config);
        if (changeDetail.getMissingApprovals() != null && changeDetail.getMissingApprovals().size() > 0) {
            this.createRequirementsSubSection(toolkit, composite, config, changeDetail);
        }
        if (changeDetail.getDependsOn() != null && changeDetail.getDependsOn().size() > 0) {
            this.createDependenciesSubSection(toolkit, composite, "Depends On", changeDetail, changeDetail.getDependsOn());
        }
        if (changeDetail.getNeededBy() != null && changeDetail.getNeededBy().size() > 0) {
            this.createDependenciesSubSection(toolkit, composite, "Needed By", changeDetail, changeDetail.getNeededBy());
        }
    }

    void createPeopleSubSection(Composite parent, ChangeDetail changeDetail, GerritConfig config) {
        if (changeDetail.getApprovals().isEmpty() && !this.canAddReviewers(changeDetail)) {
            return;
        }
        int style = 8210;
        Section subSection = this.toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setText("Reviewers");
        List approvalTypes = config != null ? config.getApprovalTypes().getApprovalTypes() : Collections.emptyList();
        Composite composite = this.toolkit.createComposite((Composite)subSection);
        int numColumns = approvalTypes.size() + 1;
        GridLayoutFactory.fillDefaults().numColumns(numColumns).extendedMargins(0, 0, 0, 5).spacing(20, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        if (changeDetail.getApprovals().size() > 0) {
            StringBuilder names = new StringBuilder();
            Label label = new Label(composite, 0);
            label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            label.setText(" ");
            for (ApprovalType approvalType : approvalTypes) {
                label = new Label(composite, 0);
                label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                label.setText(approvalType.getCategory().getName());
            }
            for (ApprovalDetail approvalDetail : changeDetail.getApprovals()) {
                AccountInfo user = changeDetail.getAccounts().get(approvalDetail.getAccount());
                label = new Label(composite, 0);
                label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                label.setText(GerritUtil.getUserLabel((AccountInfo)user));
                for (ApprovalType approvalType : approvalTypes) {
                    PatchSetApproval approval = (PatchSetApproval)approvalDetail.getApprovalMap().get(approvalType.getCategory().getId());
                    if (approval != null) {
                        label = new Label(composite, 0);
                        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)label);
                        ApprovalCategoryValue approvalValue = approvalType.getValue(approval.getValue());
                        if (approvalValue != null) {
                            label.setText(approvalValue.formatValue());
                            label.setToolTipText(approvalValue.format());
                            continue;
                        }
                        label.setText(String.valueOf(approval.getValue()));
                        continue;
                    }
                    label = new Label(composite, 0);
                    label.setText(" ");
                }
                if (names.length() > 0) {
                    names.append(", ");
                }
                names.append(GerritUtil.getUserLabel((AccountInfo)user));
            }
            if (names.length() > 0) {
                this.addTextClient(this.toolkit, subSection, names.toString());
            }
        }
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().span(numColumns, 1).applyTo((Control)buttonComposite);
        RowLayout layout = new RowLayout();
        layout.center = true;
        layout.spacing = 10;
        buttonComposite.setLayout((Layout)layout);
        Button addReviewersButton = this.toolkit.createButton(buttonComposite, "Add Reviewers...", 8);
        addReviewersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReviewSection.this.doAddReviewers();
            }
        });
    }

    private void doAddReviewers() {
        AddReviewersDialog dialog = new AddReviewersDialog(this.getShell(), this.getTask());
        this.openOperationDialog(dialog);
    }

    private boolean canAddReviewers(ChangeDetail changeDetail) {
        return changeDetail.getChange().getStatus() == Change.Status.NEW;
    }

    private void createRequirementsSubSection(FormToolkit toolkit, Composite parent, GerritConfig config, ChangeDetail changeDetail) {
        if (config == null) {
            return;
        }
        int style = 8210;
        Section subSection = toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setText("Requirements");
        Composite composite = toolkit.createComposite((Composite)subSection);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(20, 5).extendedMargins(0, 0, 0, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        StringBuilder sb = new StringBuilder();
        for (ApprovalCategory.Id approvalCategoryId : changeDetail.getMissingApprovals()) {
            ApprovalCategoryValue approvalValue;
            ApprovalType type = config.getApprovalTypes().getApprovalType(approvalCategoryId);
            if (type == null || (approvalValue = type.getMax()) == null) continue;
            Label label1 = new Label(composite, 0);
            label1.setText(type.getCategory().getName());
            label1.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Label label2 = new Label(composite, 0);
            label2.setText(approvalValue.format());
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(type.getCategory().getName());
        }
        this.addTextClient(toolkit, subSection, sb.toString());
    }

    private void createDependenciesSubSection(FormToolkit toolkit, Composite parent, String title, ChangeDetail changeDetail, List<ChangeInfo> changeInfos) {
        int style = 18;
        Section subSection = toolkit.createSection(parent, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subSection);
        subSection.setText(title);
        Composite composite = toolkit.createComposite((Composite)subSection);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 5).applyTo(composite);
        subSection.setClient((Control)composite);
        for (final ChangeInfo changeInfo : changeInfos) {
            AccountInfo user = changeDetail.getAccounts().get(changeInfo.getOwner());
            Link link = new Link(composite, 0);
            link.setText(NLS.bind((String)"<a>{0}</a>: {1} ({3}) by {2}", (Object[])new String[]{changeInfo.getKey().abbreviate(), changeInfo.getSubject(), GerritUtil.getUserLabel((AccountInfo)user), String.valueOf(changeInfo.getStatus())}));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TasksUiUtil.openTask((TaskRepository)ReviewSection.this.getTaskEditorPage().getTaskRepository(), (String)("" + changeInfo.getId()));
                }
            });
        }
    }

    private GerritConfig getConfig() {
        GerritConnector connector = (GerritConnector)TasksUi.getRepositoryConnector((String)this.getTaskData().getConnectorKind());
        GerritClient client = connector.getClient(this.getTaskEditorPage().getTaskRepository());
        return client.getConfig();
    }

    protected boolean shouldExpandOnCreate() {
        return true;
    }
}

