/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchSetPublishDetail;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.PublishRequest;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PublishDialog
extends GerritOperationDialog {
    private static final String KEY_ID = "ApprovalCategoryValue.Id";
    private final PatchSetPublishDetail publishDetail;
    private RichTextEditor messageEditor;
    private Composite approvalComposite;
    private final List<Button> approvalButtons;
    private Label statusLabel;
    private final int addedDrafts;

    public PublishDialog(Shell parentShell, ITask task, PatchSetPublishDetail patchSet, int addedDrafts) {
        super(parentShell, task);
        this.publishDetail = patchSet;
        this.addedDrafts = addedDrafts;
        this.approvalButtons = new ArrayList<Button>();
        this.setNeedsConfig(true);
    }

    public GerritOperation<Object> createOperation() {
        int patchSetId = this.publishDetail.getPatchSetInfo().getKey().get();
        PublishRequest request = new PublishRequest(this.task.getTaskId(), patchSetId, this.getApprovals());
        request.setMessage(this.messageEditor.getText());
        return this.getOperationFactory().createPublishOperation(this.task, request);
    }

    private Set<ApprovalCategoryValue.Id> getApprovals() {
        HashSet<ApprovalCategoryValue.Id> approvals = new HashSet<ApprovalCategoryValue.Id>();
        for (Button button : this.approvalButtons) {
            if (!button.getSelection()) continue;
            approvals.add((ApprovalCategoryValue.Id)button.getData(KEY_ID));
        }
        return approvals;
    }

    protected Control createPageControls(Composite parent) {
        String changeId = this.publishDetail.getChange().getKey().abbreviate();
        this.setTitle("Publish Comments");
        this.setMessage(NLS.bind((String)"Change {0} - {1}", (Object)changeId, (Object)this.publishDetail.getPatchSetInfo().getSubject()));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.approvalComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.approvalComposite);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.approvalComposite.setLayout((Layout)layout);
        this.messageEditor = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).minSize(400, 150).applyTo(this.messageEditor.getControl());
        this.messageEditor.getControl().setFocus();
        this.statusLabel = new Label(composite, 0);
        this.statusLabel.setText(NLS.bind((String)"Publishes {0} draft(s).", (Object)(this.publishDetail.getDrafts().size() + this.addedDrafts)));
        return composite;
    }

    @Override
    protected void doRefresh(GerritConfig config) {
        Control[] children;
        Control[] controlArray = children = this.approvalComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.approvalButtons.clear();
        if (config == null) {
            return;
        }
        for (ApprovalType approvalType : config.getApprovalTypes().getApprovalTypes()) {
            PatchSetApproval approval;
            Set allowed = this.publishDetail.getAllowed(approvalType.getCategory().getId());
            if (allowed == null || allowed.size() <= 0) continue;
            Group group = new Group(this.approvalComposite, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setText(approvalType.getCategory().getName());
            group.setLayout((Layout)new RowLayout(512));
            short givenValue = 0;
            if (this.publishDetail.getGiven() != null && (approval = (PatchSetApproval)this.publishDetail.getGiven().get(approvalType.getCategory().getId())) != null) {
                givenValue = approval.getValue();
            }
            ArrayList allowedList = new ArrayList(allowed);
            Collections.sort(allowedList, new Comparator<ApprovalCategoryValue.Id>(){

                @Override
                public int compare(ApprovalCategoryValue.Id o1, ApprovalCategoryValue.Id o2) {
                    return o2.get() - o1.get();
                }
            });
            for (ApprovalCategoryValue.Id valueId : allowedList) {
                ApprovalCategoryValue approvalValue = approvalType.getValue(valueId.get());
                Button button = new Button((Composite)group, 16);
                button.setText(approvalValue.format());
                if (approvalValue.getValue() == givenValue) {
                    button.setSelection(true);
                }
                button.setData(KEY_ID, (Object)valueId);
                this.approvalButtons.add(button);
            }
        }
    }
}

