/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.wizards;

import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GerritCustomQueryPage
extends AbstractRepositoryQueryPage {
    private final IRepositoryQuery query;
    private Button myChangesButton;
    private Button allOpenChangesButton;
    private Button byProjectButton;
    private Text titleText;
    private Text projectText;

    public GerritCustomQueryPage(TaskRepository repository, String pageName, IRepositoryQuery query) {
        super(pageName, repository, query);
        this.query = query;
        this.setDescription("Enter title and type of the query.");
    }

    public void createControl(Composite parent) {
        GridData gd2;
        Composite control = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout(3, false);
        control.setLayout((Layout)layout);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GerritCustomQueryPage.this.updateButtons();
            }
        };
        if (this.getSearchContainer() == null) {
            Label titleLabel = new Label(control, 0);
            titleLabel.setText("Query Title:");
            this.titleText = new Text(control, 2048);
            gd2 = new GridData(768);
            gd2.horizontalSpan = 2;
            this.titleText.setLayoutData((Object)gd2);
            this.titleText.addModifyListener(modifyListener);
        }
        Label typeLabel = new Label(control, 0);
        typeLabel.setText("Query type:");
        this.myChangesButton = new Button(control, 16);
        this.myChangesButton.setText("My changes");
        gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        this.myChangesButton.setLayoutData((Object)gd2);
        new Label(control, 0);
        this.allOpenChangesButton = new Button(control, 16);
        this.allOpenChangesButton.setText("All open changes");
        this.allOpenChangesButton.setLayoutData((Object)gd2);
        new Label(control, 0);
        this.byProjectButton = new Button(control, 16);
        this.byProjectButton.setText("Open changes by project");
        this.projectText = new Text(control, 2048);
        this.projectText.setLayoutData((Object)new GridData(768));
        this.projectText.addModifyListener(modifyListener);
        if (this.query != null) {
            if (this.titleText != null) {
                this.titleText.setText(this.query.getSummary());
            }
            if ("my changes".equals(this.query.getAttribute("gerrit query type"))) {
                this.myChangesButton.setSelection(true);
            } else if ("open changes by project".equals(this.query.getAttribute("gerrit query type"))) {
                this.byProjectButton.setSelection(true);
            } else {
                this.allOpenChangesButton.setSelection(true);
            }
            if (this.query.getAttribute("gerrit query project") != null) {
                this.projectText.setText(this.query.getAttribute("gerrit query project"));
            }
        } else {
            this.myChangesButton.setSelection(true);
        }
        SelectionAdapter buttonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GerritCustomQueryPage.this.projectText.setEnabled(GerritCustomQueryPage.this.byProjectButton.getSelection());
                GerritCustomQueryPage.this.updateButtons();
            }
        };
        buttonSelectionListener.widgetSelected(null);
        this.byProjectButton.addSelectionListener((SelectionListener)buttonSelectionListener);
        this.setControl((Control)control);
    }

    protected void updateButtons() {
        IWizardContainer c = this.getContainer();
        if (c != null && c.getCurrentPage() != null) {
            c.updateButtons();
        }
    }

    public boolean isPageComplete() {
        boolean ret;
        boolean bl = ret = this.titleText != null && this.titleText.getText().length() > 0;
        if (this.byProjectButton != null && this.byProjectButton.getSelection()) {
            ret &= this.projectText != null && this.projectText.getText().length() > 0;
        }
        return ret;
    }

    public void applyTo(IRepositoryQuery query) {
        query.setSummary(this.getTitleText());
        if (this.myChangesButton.getSelection()) {
            query.setAttribute("gerrit query type", "my changes");
        } else if (this.byProjectButton.getSelection()) {
            query.setAttribute("gerrit query type", "open changes by project");
        } else {
            query.setAttribute("gerrit query type", "all open changes");
        }
        query.setAttribute("gerrit query project", this.projectText.getText());
    }

    private String getTitleText() {
        return this.titleText != null ? this.titleText.getText() : "<search>";
    }

    public String getQueryTitle() {
        return "Gerrit Query";
    }
}

