/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.reviews.core.model.ITopic;

public class CommentAnnotation
extends Annotation {
    public static final String COMMENT_ANNOTATION_ID = "org.eclipse.mylyn.reviews.ui.comment.Annotation";
    private final Position position;
    private final ITopic comment;

    public CommentAnnotation(int offset, int length, ITopic comment) {
        super(COMMENT_ANNOTATION_ID, false, null);
        this.position = new Position(offset, length);
        this.comment = comment;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getText() {
        return String.valueOf(this.comment.getAuthor().getDisplayName()) + " - " + this.comment.getTitle();
    }

    public ITopic getTopic() {
        return this.comment;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentAnnotation)) {
            return false;
        }
        CommentAnnotation other = (CommentAnnotation)((Object)obj);
        if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
            return false;
        }
        return !(this.position == null ? other.position != null : !this.position.equals((Object)other.position));
    }
}

