/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.eclipse.mylyn.reviews.ui.ProgressDialog;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorExtension;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.statushandlers.StatusManager;

public class AddCommentDialog
extends ProgressDialog {
    private RichTextEditor commentEditor;
    private final ILocation location;
    private final ReviewBehavior reviewBehavior;
    protected final ITask task;
    protected FormToolkit toolkit;
    private final IReviewItem item;

    public AddCommentDialog(Shell parentShell, ReviewBehavior reviewBehavior, IReviewItem item, ILocation location) {
        super(parentShell);
        this.reviewBehavior = reviewBehavior;
        this.item = item;
        this.location = location;
        this.task = reviewBehavior.getTask();
    }

    public boolean close() {
        boolean shouldClose;
        if (this.getReturnCode() == 0 && !(shouldClose = this.performOperation(this.getTopic()))) {
            return false;
        }
        return super.close();
    }

    public ILocation getLocation() {
        return this.location;
    }

    public ITask getTask() {
        return this.task;
    }

    private ITopic getTopic() {
        ITopic topic = ReviewsFactory.eINSTANCE.createTopic();
        topic.setDraft(true);
        IUser user = ReviewsFactory.eINSTANCE.createUser();
        user.setDisplayName("Me");
        topic.setAuthor(user);
        topic.setDescription(this.commentEditor.getText());
        topic.setLocation(this.getLocation());
        topic.setItem(this.item);
        IComment comment = ReviewsFactory.eINSTANCE.createComment();
        comment.setDescription(topic.getDescription());
        comment.setAuthor(topic.getAuthor());
        comment.setCreationDate(new Date());
        topic.getComments().add(comment);
        return topic;
    }

    private boolean performOperation(final ITopic topic) {
        final AtomicReference result = new AtomicReference();
        try {
            this.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result.set(AddCommentDialog.this.reviewBehavior.addTopic(topic, monitor));
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Unexpected error during execution of operation", (Throwable)e), 3);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (((IStatus)result.get()).getSeverity() == 8) {
            return false;
        }
        if (((IStatus)result.get()).isOK()) {
            this.item.getTopics().add(topic);
            return true;
        }
        StatusManager.getManager().handle((IStatus)result.get(), 3);
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(TasksUiPlugin.getDefault().getFormColors(parent.getDisplay()));
        Control control = super.createDialogArea(parent);
        return control;
    }

    protected Control createPageControls(Composite parent) {
        this.setTitle("Add Comment");
        this.setMessage("");
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.commentEditor = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.commentEditor.getControl());
        return composite;
    }

    protected RichTextEditor createRichTextEditor(Composite composite, String value) {
        int style = 8390722;
        TaskRepository repository = TasksUi.getRepositoryManager().getRepository(this.task.getConnectorKind(), this.task.getRepositoryUrl());
        AbstractTaskEditorExtension extension = TaskEditorExtensions.getTaskEditorExtension((TaskRepository)repository);
        final RichTextEditor editor = new RichTextEditor(repository, style, null, extension, this.task);
        editor.setText(value);
        editor.createControl(composite, this.toolkit);
        editor.getViewer().getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                editor.getViewer().getTextWidget().setSelection(0);
            }
        });
        return editor;
    }
}

