/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewCompareAnnotationModel;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileRevision;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ReviewCompareEditorInput
extends CompareEditorInput {
    private final byte[] content1;
    private final byte[] content2;
    private final ReviewCompareAnnotationModel annotationModel;
    private final IFileItem file;

    public ReviewCompareEditorInput(IFileItem file, ReviewCompareAnnotationModel annotationModel, CompareConfiguration compareConfiguration) {
        super(compareConfiguration);
        this.content1 = this.getContent(file.getBase());
        this.content2 = this.getContent(file.getTarget());
        this.annotationModel = annotationModel;
        this.file = file;
        this.setTitle("Compare " + file.getName() + " " + file.getBase().getRevision() + " and " + file.getTarget().getRevision());
    }

    private byte[] getContent(IFileRevision revision) {
        String content = revision.getContent();
        return content != null ? content.getBytes() : new byte[]{};
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Differencer d = new Differencer();
        Object diff = d.findDifferences(false, monitor, null, null, (Object)new ByteArrayInput(this.content1, this.file.getBase().getPath()), (Object)new ByteArrayInput(this.content2, this.file.getTarget().getPath()));
        return diff;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer contentViewer = super.findContentViewer(oldViewer, input, parent);
        return ReviewCompareEditorInput.findContentViewer(contentViewer, input, parent, this.annotationModel);
    }

    private static Viewer findContentViewer(Viewer contentViewer, ICompareInput input, Composite parent, ReviewCompareAnnotationModel annotationModel) {
        if (contentViewer instanceof TextMergeViewer) {
            TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
            try {
                Class<TextMergeViewer> clazz = TextMergeViewer.class;
                Field declaredField = clazz.getDeclaredField("fLeft");
                declaredField.setAccessible(true);
                MergeSourceViewer fLeft = (MergeSourceViewer)declaredField.get(textMergeViewer);
                declaredField = clazz.getDeclaredField("fRight");
                declaredField.setAccessible(true);
                MergeSourceViewer fRight = (MergeSourceViewer)declaredField.get(textMergeViewer);
                annotationModel.attachToViewer(textMergeViewer, fLeft, fRight);
                annotationModel.focusOnComment();
                annotationModel.registerContextMenu();
                Method setActiveViewer = clazz.getDeclaredMethod("setActiveViewer", MergeSourceViewer.class, Boolean.TYPE);
                setActiveViewer.setAccessible(true);
                setActiveViewer.invoke((Object)textMergeViewer, fRight, true);
                ReviewCompareEditorInput.hackGalileo(contentViewer, textMergeViewer, fLeft, fRight);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Could not initialize annotation model for " + input.getName(), t));
            }
        }
        return contentViewer;
    }

    private static void hackGalileo(Viewer contentViewer, TextMergeViewer textMergeViewer, MergeSourceViewer fLeft, MergeSourceViewer fRight) {
        try {
            Method getCompareConfiguration = ContentMergeViewer.class.getDeclaredMethod("getCompareConfiguration", new Class[0]);
            getCompareConfiguration.setAccessible(true);
            CompareConfiguration cc = (CompareConfiguration)getCompareConfiguration.invoke((Object)textMergeViewer, new Object[0]);
            Method getMergeContentProvider = ContentMergeViewer.class.getDeclaredMethod("getMergeContentProvider", new Class[0]);
            getMergeContentProvider.setAccessible(true);
            IMergeViewerContentProvider cp = (IMergeViewerContentProvider)getMergeContentProvider.invoke((Object)textMergeViewer, new Object[0]);
            Method getSourceViewer = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            Method configureSourceViewer = TextMergeViewer.class.getDeclaredMethod("configureSourceViewer", SourceViewer.class, Boolean.TYPE);
            configureSourceViewer.setAccessible(true);
            configureSourceViewer.invoke((Object)contentViewer, getSourceViewer.invoke((Object)fLeft, new Object[0]), cc.isLeftEditable() && cp.isLeftEditable(textMergeViewer.getInput()));
            configureSourceViewer.invoke((Object)contentViewer, getSourceViewer.invoke((Object)fRight, new Object[0]), cc.isRightEditable() && cp.isRightEditable(textMergeViewer.getInput()));
            Field isConfiguredField = TextMergeViewer.class.getDeclaredField("isConfigured");
            isConfiguredField.setAccessible(true);
            isConfiguredField.set(contentViewer, true);
        }
        catch (Throwable throwable) {}
    }

    public ReviewCompareAnnotationModel getAnnotationModelToAttach() {
        return this.annotationModel;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.annotationModel == null ? 0 : this.annotationModel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ReviewCompareEditorInput other = (ReviewCompareEditorInput)((Object)obj);
        return !(this.annotationModel == null ? other.annotationModel != null : !this.annotationModel.equals(other.annotationModel));
    }

    public IFileItem getFile() {
        return this.file;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        this.getAnnotationModelToAttach().focusOnComment();
    }

    static class ByteArrayInput
    implements ITypedElement,
    IStreamContentAccessor {
        byte[] content;
        private final String name;

        public ByteArrayInput(byte[] content, String name) {
            this.content = content;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            String extension = FilenameUtils.getExtension((String)this.name);
            return extension != null && extension.length() > 0 ? extension : "txt";
        }

        public InputStream getContents() throws CoreException {
            return new ByteArrayInputStream(this.content);
        }
    }
}

