/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin.callback;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdmin;

public class AbstractServiceCallbackAssociator {
    public static final String ECF_RSA_PROP_PREFIX = "ecf.x.rsa.";
    private RemoteServiceAdmin rsa;
    private IContainerManager containerManager;
    private BundleContext context;

    protected IContainerManager getContainerManager() {
        return this.containerManager;
    }

    protected void bindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.rsa = rsa;
    }

    protected void unbindRemoteServiceAdmin(RemoteServiceAdmin rsa) {
        this.rsa = null;
    }

    public RemoteServiceAdmin getRSA() {
        return this.rsa;
    }

    protected void bindContainerManager(IContainerManager cm) {
        this.containerManager = cm;
    }

    protected void unbindContainerManager(IContainerManager cm) {
        this.containerManager = null;
    }

    public ContainerTypeDescription getContainerTypeDescription(ID containerID) {
        IContainerManager cm = this.getContainerManager();
        return cm != null ? cm.getContainerTypeDescription(containerID) : null;
    }

    public IContainer getContainerConnectedToID(ID id) {
        IContainer[] iContainerArray = this.getContainerManager().getAllContainers();
        int n = iContainerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            ID targetID = c.getConnectedID();
            if (targetID != null && targetID.equals((Object)id)) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    protected void logException(String string, Throwable e) {
        System.out.println(string);
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected void activate(BundleContext context) throws Exception {
        this.context = context;
    }

    protected void deactivate() {
        this.context = null;
    }

    protected BundleContext getContext() {
        return this.context;
    }

    protected String getCallbackPackageVersion(Class<?> clazz, String packageName) {
        Version v = this.getVersionForPackage(FrameworkUtil.getBundle(clazz), packageName);
        return v != null ? v.toString() : null;
    }

    protected String getPackageName(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        return className.substring(0, lastDotIndex);
    }

    protected Version getVersionForPackage(final Bundle providingBundle, String packageName) {
        Version result = null;
        BundleRevision providingBundleRevision = AccessController.doPrivileged(new PrivilegedAction<BundleRevision>(){

            @Override
            public BundleRevision run() {
                return (BundleRevision)providingBundle.adapt(BundleRevision.class);
            }
        });
        if (providingBundleRevision == null) {
            return null;
        }
        List providerCapabilities = providingBundleRevision.getDeclaredCapabilities("osgi.wiring.package");
        for (BundleCapability c : providerCapabilities) {
            result = this.getVersionForMatchingCapability(packageName, c);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    protected Class<?> findInterface(List<String> intfNames, Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            if (intfNames.contains(cls.getName())) {
                return cls;
            }
            ++n2;
        }
        return null;
    }

    protected Class<?> findMatchingInterface(List<String> intfNames, Class<?> root) {
        Class<?> cls = root;
        while (cls != null) {
            Class<?> intf = this.findInterface(intfNames, cls);
            if (intf != null) {
                return intf;
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    protected Version getVersionForMatchingCapability(String packageName, BundleCapability capability) {
        Map attributes = capability.getAttributes();
        String p = (String)attributes.get("osgi.wiring.package");
        if (p != null && packageName.equals(p)) {
            return (Version)attributes.get("version");
        }
        return null;
    }
}

