/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class CountConstraintFactsService
extends FactsService {
    @Text(value="Must have at least one")
    private static LocalizableText atLeastOneStatement;
    @Text(value="Must have at least {0} items")
    private static LocalizableText minCountStatement;
    @Text(value="Must have at most {0} items")
    private static LocalizableText maxCountStatement;

    static {
        LocalizableText.init(CountConstraintFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        CountConstraint constraint = this.context(PropertyDef.class).getAnnotation(CountConstraint.class);
        int min = constraint.min();
        int max = constraint.max();
        if (min == 1) {
            facts.add(atLeastOneStatement.text());
        } else if (min > 1) {
            facts.add(minCountStatement.format(min));
        }
        if (max < Integer.MAX_VALUE) {
            facts.add(maxCountStatement.format(max));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ListProperty property = context.find(ListProperty.class);
            if (property != null) {
                CountConstraint constraint = property.getAnnotation(CountConstraint.class);
                return constraint != null && (constraint.min() > 0 || constraint.max() < Integer.MAX_VALUE);
            }
            return false;
        }
    }
}

