/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.conversion.enumeration;

import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.conversion.enumeration.ThreeChoiceAnswer;
import org.eclipse.sapphire.tests.conversion.enumeration.ThreeChoiceAnswerCustomized;
import org.eclipse.sapphire.tests.conversion.enumeration.ThreeChoiceAnswerToString;
import org.junit.Test;

public final class EnumConversionTests
extends SapphireTestCase {
    @Test
    public void testStringToEnum_Plain() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)service.convert((Object)"YES", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)service.convert((Object)"yes", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.YES), (Object)service.convert((Object)"yEs", ThreeChoiceAnswer.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"1", ThreeChoiceAnswer.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"true", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.MAYBE), (Object)service.convert((Object)"MAYBE", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.MAYBE), (Object)service.convert((Object)"maybe", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.MAYBE), (Object)service.convert((Object)"mAyBe", ThreeChoiceAnswer.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"0", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.NO), (Object)service.convert((Object)"NO", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.NO), (Object)service.convert((Object)"no", ThreeChoiceAnswer.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswer.NO), (Object)service.convert((Object)"nO", ThreeChoiceAnswer.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"-1", ThreeChoiceAnswer.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"false", ThreeChoiceAnswer.class));
    }

    @Test
    public void testStringToEnum_Customized() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"YES", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"yes", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"yEs", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"1", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"TRUE", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"true", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.YES), (Object)service.convert((Object)"tRuE", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)service.convert((Object)"MAYBE", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)service.convert((Object)"maybe", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)service.convert((Object)"mAyBe", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.MAYBE), (Object)service.convert((Object)"0", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"NO", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.NO), (Object)service.convert((Object)"no", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"nO", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.NO), (Object)service.convert((Object)"-1", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"FALSE", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerCustomized.NO), (Object)service.convert((Object)"false", ThreeChoiceAnswerCustomized.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"fAlSe", ThreeChoiceAnswerCustomized.class));
    }

    @Test
    public void testStringToEnum_ToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerToString.YES), (Object)service.convert((Object)"YES", ThreeChoiceAnswerToString.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerToString.MAYBE), (Object)service.convert((Object)"MAYBE", ThreeChoiceAnswerToString.class));
        EnumConversionTests.assertEquals((Object)((Object)ThreeChoiceAnswerToString.NO), (Object)service.convert((Object)"NO", ThreeChoiceAnswerToString.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"1", ThreeChoiceAnswerToString.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"0", ThreeChoiceAnswerToString.class));
        EnumConversionTests.assertNull((Object)service.convert((Object)"-1", ThreeChoiceAnswerToString.class));
    }

    @Test
    public void testEnumToString_Plain() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        EnumConversionTests.assertEquals((Object)"YES", (Object)service.convert((Object)ThreeChoiceAnswer.YES, String.class));
        EnumConversionTests.assertEquals((Object)"MAYBE", (Object)service.convert((Object)ThreeChoiceAnswer.MAYBE, String.class));
        EnumConversionTests.assertEquals((Object)"NO", (Object)service.convert((Object)ThreeChoiceAnswer.NO, String.class));
    }

    @Test
    public void testEnumToString_Customized() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        EnumConversionTests.assertEquals((Object)"yes", (Object)service.convert((Object)ThreeChoiceAnswerCustomized.YES, String.class));
        EnumConversionTests.assertEquals((Object)"maybe", (Object)service.convert((Object)ThreeChoiceAnswerCustomized.MAYBE, String.class));
        EnumConversionTests.assertEquals((Object)"no", (Object)service.convert((Object)ThreeChoiceAnswerCustomized.NO, String.class));
    }

    @Test
    public void testEnumToString_ToString() throws Exception {
        MasterConversionService service = (MasterConversionService)Sapphire.service(MasterConversionService.class);
        EnumConversionTests.assertEquals((Object)"YES", (Object)service.convert((Object)ThreeChoiceAnswerToString.YES, String.class));
        EnumConversionTests.assertEquals((Object)"MAYBE", (Object)service.convert((Object)ThreeChoiceAnswerToString.MAYBE, String.class));
        EnumConversionTests.assertEquals((Object)"NO", (Object)service.convert((Object)ThreeChoiceAnswerToString.NO, String.class));
    }
}

