/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.operators;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.operators.AbstractOperatorTests;
import org.eclipse.sapphire.tests.modeling.el.operators.TestElement;
import org.junit.Test;

public final class InequalityOperatorTests
extends AbstractOperatorTests {
    @Test
    public void testInequalityOperator1() {
        this.test("${ 3 != 3 }", false);
    }

    @Test
    public void testInequalityOperator2() {
        this.test("${ 3 != 5 }", true);
    }

    @Test
    public void testInequalityOperator3() {
        this.test("${ 3.2 != 3.2 }", false);
    }

    @Test
    public void testInequalityOperator4() {
        this.test("${ 3.2 != 5 }", true);
    }

    @Test
    public void testInequalityOperator5() {
        this.test("${ 'abc' != 'abc' }", false);
    }

    @Test
    public void testInequalityOperator6() {
        this.test("${ 'abc' != 'xyz' }", true);
    }

    @Test
    public void testInequalityOperator7() {
        this.test("${ 3 ne 3 }", false);
    }

    @Test
    public void testInequalityOperator8() {
        this.test("${ 3 ne 5 }", true);
    }

    @Test
    public void testInequalityOperator9() {
        this.test("${ 3.2 ne 3.2 }", false);
    }

    @Test
    public void testInequalityOperator10() {
        this.test("${ 3.2 ne 5 }", true);
    }

    @Test
    public void testInequalityOperator11() {
        this.test("${ 'abc' ne 'abc' }", false);
    }

    @Test
    public void testInequalityOperator12() {
        this.test("${ 'abc' ne 'xyz' }", true);
    }

    @Test
    public void testInequalityOperator13() {
        this.test("${ Integer3 != 7 }", true);
    }

    @Test
    public void testInequalityOperator14() {
        this.test("${ 7 != Integer5 }", true);
    }

    @Test
    public void testInequalityOperator15() {
        this.test("${ Integer3 != Integer5 }", true);
    }

    @Test
    public void InequalityOperator_ElementProperty_Null() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ ChildElement != null }").evaluate((FunctionContext)context);
        try {
            InequalityOperatorTests.assertEquals((Object)Boolean.FALSE, (Object)fr.value());
            element.getChildElement().content(true);
            InequalityOperatorTests.assertEquals((Object)Boolean.TRUE, (Object)fr.value());
            element.getChildElement().clear();
            InequalityOperatorTests.assertEquals((Object)Boolean.FALSE, (Object)fr.value());
        }
        finally {
            fr.dispose();
        }
    }
}

