/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.misc.t0002;

import java.util.List;
import org.eclipse.sapphire.modeling.util.DependencySorter;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.junit.Test;

public final class TestModelingMisc0002
extends SapphireTestCase {
    @Test
    public void testNoItems() throws Exception {
        DependencySorter sorter = new DependencySorter();
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)0L, (long)sorted.size());
    }

    @Test
    public void testOneItem() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)1L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
    }

    @Test
    public void testMultipleUnrelatedItems() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        Object b = new Object();
        sorter.add((Object)"b", b);
        Object c = new Object();
        sorter.add((Object)"c", c);
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)3L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(b));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(c));
    }

    @Test
    public void testSimpleDependency() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency((Object)"a", (Object)"c");
        Object b = new Object();
        sorter.add((Object)"b", b);
        Object c = new Object();
        sorter.add((Object)"c", c);
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)3L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(b));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(c));
        TestModelingMisc0002.assertTrue((sorted.indexOf(c) < sorted.indexOf(a) ? 1 : 0) != 0);
    }

    @Test
    public void testMultiLevelDependency() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency((Object)"a", (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency((Object)"b", (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)3L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(b));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(c));
        TestModelingMisc0002.assertTrue((sorted.indexOf(c) < sorted.indexOf(b) ? 1 : 0) != 0);
        TestModelingMisc0002.assertTrue((sorted.indexOf(b) < sorted.indexOf(a) ? 1 : 0) != 0);
    }

    @Test
    public void testCycleBreaking1() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency((Object)"a", (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency((Object)"b", (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        sorter.dependency((Object)"c", (Object)"b");
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)3L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(b));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(c));
    }

    @Test
    public void testCycleBreaking2() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency((Object)"a", (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency((Object)"b", (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        sorter.dependency((Object)"c", (Object)"a");
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)3L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(b));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(c));
    }

    @Test
    public void testCycleBreaking3() throws Exception {
        DependencySorter sorter = new DependencySorter();
        Object a = new Object();
        sorter.add((Object)"a", a);
        sorter.dependency((Object)"a", (Object)"b");
        Object b = new Object();
        sorter.add((Object)"b", b);
        sorter.dependency((Object)"b", (Object)"c");
        Object c = new Object();
        sorter.add((Object)"c", c);
        sorter.dependency((Object)"c", (Object)"a");
        Object d = new Object();
        sorter.add((Object)"d", d);
        List sorted = sorter.sort();
        TestModelingMisc0002.assertEquals((long)4L, (long)sorted.size());
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(a));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(b));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(c));
        TestModelingMisc0002.assertTrue((boolean)sorted.contains(d));
    }
}

