/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.properties.element;

import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.properties.element.TestElement;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ElementPropertyTests
extends SapphireTestCase {
    private TestElement element;

    @Before
    public void before() {
        if (this.element != null) {
            throw new IllegalStateException();
        }
        this.element = (TestElement)TestElement.TYPE.instantiate();
    }

    @After
    public void after() {
        if (this.element == null) {
            throw new IllegalStateException();
        }
        this.element.dispose();
        this.element = null;
    }

    @Test
    public void Homogeneous_Content() {
        ElementPropertyTests.assertNull((Object)this.element.getHomogeneous().content());
        TestElement.Child child = (TestElement.Child)this.element.getHomogeneous().content(true);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content());
    }

    @Test
    public void Homogeneous_Content_Boolean() {
        ElementPropertyTests.assertNull((Object)this.element.getHomogeneous().content(false));
        TestElement.Child child = (TestElement.Child)this.element.getHomogeneous().content(true);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content(false));
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content(true));
    }

    @Test
    public void Homogeneous_Content_Boolean_ElementType() {
        ElementPropertyTests.assertNull((Object)this.element.getHomogeneous().content(false, TestElement.Child.TYPE));
        TestElement.Child child = (TestElement.Child)this.element.getHomogeneous().content(true, TestElement.Child.TYPE);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content(false, TestElement.Child.TYPE));
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content(true, TestElement.Child.TYPE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void Homogeneous_Content_Boolean_ElementType_UnsupportedType() {
        this.element.getHomogeneous().content(true, TestElement.ChildVariant1.TYPE);
    }

    @Test
    public void Homogeneous_Content_Boolean_ElementType_NullType() {
        TestElement.Child child = (TestElement.Child)this.element.getHomogeneous().content(true, null);
        ElementPropertyTests.assertNotNull((Object)child);
    }

    @Test
    public void Homogeneous_Content_Boolean_Class() {
        ElementPropertyTests.assertNull((Object)this.element.getHomogeneous().content(false, TestElement.Child.class));
        TestElement.Child child = (TestElement.Child)this.element.getHomogeneous().content(true, TestElement.Child.class);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content(false, TestElement.Child.class));
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHomogeneous().content(true, TestElement.Child.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void Homogeneous_Content_Boolean_Class_UnsupportedType() {
        this.element.getHomogeneous().content(true, TestElement.ChildVariant1.class);
    }

    @Test
    public void Homogeneous_Content_Boolean_Class_NullType() {
        TestElement.Child child = (TestElement.Child)this.element.getHomogeneous().content(true, null);
        ElementPropertyTests.assertNotNull((Object)child);
    }

    @Test
    public void Heterogeneous_Content() {
        ElementPropertyTests.assertNull((Object)this.element.getHeterogeneous().content());
        TestElement.ChildVariant1 child = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.class);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHeterogeneous().content());
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean() {
        ElementPropertyTests.assertNull((Object)this.element.getHeterogeneous().content(false));
        TestElement.Child child = (TestElement.Child)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.class);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHeterogeneous().content(false));
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHeterogeneous().content(true));
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_Exception() {
        this.element.getHeterogeneous().content(true);
    }

    @Test
    public void Heterogeneous_Content_Boolean_ElementType() {
        ElementPropertyTests.assertNull((Object)this.element.getHeterogeneous().content(false, TestElement.ChildVariant1.TYPE));
        TestElement.ChildVariant1 child = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.TYPE);
        ElementPropertyTests.assertNotNull((Object)child);
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHeterogeneous().content(false, TestElement.ChildVariant1.TYPE));
        ElementPropertyTests.assertSame((Object)child, (Object)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.TYPE));
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_ElementType_TypeChange_WithoutForce() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.TYPE);
        ElementPropertyTests.assertNotNull((Object)x);
        this.element.getHeterogeneous().content(false, TestElement.ChildVariant2.TYPE);
    }

    @Test
    public void Heterogeneous_Content_Boolean_ElementType_TypeChange_WithForce() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.TYPE);
        ElementPropertyTests.assertNotNull((Object)x);
        TestElement.ChildVariant2 y = (TestElement.ChildVariant2)this.element.getHeterogeneous().content(true, TestElement.ChildVariant2.TYPE);
        ElementPropertyTests.assertNotNull((Object)y);
        ElementPropertyTests.assertTrue((boolean)x.disposed());
    }

    @Test
    public void Heterogeneous_Content_Boolean_ElementType_NullType_WithoutForce_OnEmpty() {
        TestElement.Child x = (TestElement.Child)this.element.getHeterogeneous().content(false, null);
        ElementPropertyTests.assertNull((Object)x);
    }

    @Test
    public void Heterogeneous_Content_Boolean_ElementType_NullType_WithoutForce_OnFull() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.TYPE);
        ElementPropertyTests.assertNotNull((Object)x);
        TestElement.Child y = (TestElement.Child)this.element.getHeterogeneous().content(false, null);
        ElementPropertyTests.assertNotNull((Object)y);
        ElementPropertyTests.assertSame((Object)x, (Object)y);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_ElementType_NullType_WithForce_OnEmpty() {
        this.element.getHeterogeneous().content(true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_ElementType_NullType_WithForce_OnFull() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.TYPE);
        ElementPropertyTests.assertNotNull((Object)x);
        this.element.getHeterogeneous().content(true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_ElementType_UnsupportedType() {
        this.element.getHeterogeneous().content(true, TestElement.ChildVariant3.TYPE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_Class_TypeChange_WithoutForce() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.class);
        ElementPropertyTests.assertNotNull((Object)x);
        this.element.getHeterogeneous().content(false, TestElement.ChildVariant2.class);
    }

    @Test
    public void Heterogeneous_Content_Boolean_Class_TypeChange_WithForce() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.class);
        ElementPropertyTests.assertNotNull((Object)x);
        TestElement.ChildVariant2 y = (TestElement.ChildVariant2)this.element.getHeterogeneous().content(true, TestElement.ChildVariant2.class);
        ElementPropertyTests.assertNotNull((Object)y);
        ElementPropertyTests.assertTrue((boolean)x.disposed());
    }

    @Test
    public void Heterogeneous_Content_Boolean_Class_NullType_WithoutForce_OnEmpty() {
        TestElement.Child x = (TestElement.Child)this.element.getHeterogeneous().content(false, null);
        ElementPropertyTests.assertNull((Object)x);
    }

    @Test
    public void Heterogeneous_Content_Boolean_Class_NullType_WithoutForce_OnFull() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.class);
        ElementPropertyTests.assertNotNull((Object)x);
        TestElement.Child y = (TestElement.Child)this.element.getHeterogeneous().content(false, null);
        ElementPropertyTests.assertNotNull((Object)y);
        ElementPropertyTests.assertSame((Object)x, (Object)y);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_Class_NullType_WithForce_OnEmpty() {
        this.element.getHeterogeneous().content(true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_Class_NullType_WithForce_OnFull() {
        TestElement.ChildVariant1 x = (TestElement.ChildVariant1)this.element.getHeterogeneous().content(true, TestElement.ChildVariant1.class);
        ElementPropertyTests.assertNotNull((Object)x);
        this.element.getHeterogeneous().content(true, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void Heterogeneous_Content_Boolean_Class_UnsupportedType() {
        this.element.getHeterogeneous().content(true, TestElement.ChildVariant3.class);
    }
}

