/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.reference.element;

import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.reference.element.ExternalElementReferenceService;
import org.eclipse.sapphire.tests.reference.element.TestElement;
import org.junit.Test;

public final class ElementReferenceTests
extends SapphireTestCase {
    @Test
    public void testDeclarativeElementReference() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            TestElement.Item b = (TestElement.Item)element.getItemList1().insert();
            b.setName("b");
            TestElement.Item c = (TestElement.Item)element.getItemList1().insert();
            c.setName("c");
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
            element.setDeclarativeReference("a");
            ElementReferenceTests.assertSame((Object)a, (Object)element.getDeclarativeReference().target());
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
            element.setDeclarativeReference("c");
            ElementReferenceTests.assertSame((Object)c, (Object)element.getDeclarativeReference().target());
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
            element.setDeclarativeReference("d");
            ElementReferenceTests.assertNull((Object)element.getDeclarativeReference().target());
            ElementReferenceTests.assertValidationError(element.getDeclarativeReference(), "Could not resolve declarative reference \"d\"");
            PossibleValuesService possibleValuesService = (PossibleValuesService)element.getDeclarativeReference().service(PossibleValuesService.class);
            ElementReferenceTests.assertNotNull((Object)possibleValuesService);
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c"), (Object)possibleValuesService.values());
            TestElement.Item d = (TestElement.Item)element.getItemList1().insert();
            d.setName("d");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "d"), (Object)possibleValuesService.values());
            ElementReferenceTests.assertValidationOk(element.getDeclarativeReference());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testDeclarativeElementReferenceRefactoring() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            this.testRefactoring(element.getItemList1(), element.getDeclarativeReference());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testCustomElementReference() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement.Item a = (TestElement.Item)element.getItemList1().insert();
            a.setName("a");
            a.setValue("1");
            TestElement.Item b = (TestElement.Item)element.getItemList1().insert();
            b.setName("b");
            b.setValue("2");
            TestElement.Item c = (TestElement.Item)element.getItemList1().insert();
            c.setName("c");
            c.setValue("3");
            TestElement.Item x = (TestElement.Item)element.getItemList2().insert();
            x.setName("x");
            x.setValue("4");
            TestElement.Item y = (TestElement.Item)element.getItemList2().insert();
            y.setName("y");
            y.setValue("5");
            TestElement.Item z = (TestElement.Item)element.getItemList2().insert();
            z.setName("z");
            z.setValue("6");
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setCustomReference("a");
            ElementReferenceTests.assertSame((Object)a, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setCustomReference("c");
            ElementReferenceTests.assertSame((Object)c, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setCustomReference("d");
            ElementReferenceTests.assertNull((Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"d\"");
            PossibleValuesService possibleValuesService = (PossibleValuesService)element.getCustomReference().service(PossibleValuesService.class);
            ElementReferenceTests.assertNotNull((Object)possibleValuesService);
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c"), (Object)possibleValuesService.values());
            TestElement.Item d = (TestElement.Item)element.getItemList1().insert();
            d.setName("d");
            d.setValue("7");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "d"), (Object)possibleValuesService.values());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setUseItemList2(true);
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"d\"");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("x", "y", "z"), (Object)possibleValuesService.values());
            element.setCustomReference("y");
            ElementReferenceTests.assertSame((Object)y, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            element.setUseValueAsKey(true);
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"y\"");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("4", "5", "6"), (Object)possibleValuesService.values());
            element.setCustomReference("6");
            ElementReferenceTests.assertSame((Object)z, (Object)element.getCustomReference().target());
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
            z.setValue("67");
            ElementReferenceTests.assertValidationError(element.getCustomReference(), "Could not resolve custom reference \"6\"");
            ElementReferenceTests.assertEquals(ElementReferenceTests.set("4", "5", "67"), (Object)possibleValuesService.values());
            element.setCustomReference("67");
            ElementReferenceTests.assertValidationOk(element.getCustomReference());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testCustomElementReferenceRefactoring() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            this.testRefactoring(element.getItemList1(), element.getCustomReference());
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testExternalElementReference() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement external = (TestElement)TestElement.TYPE.instantiate();
            try {
                TestElement.Item a = (TestElement.Item)external.getItemList1().insert();
                a.setName("a");
                TestElement.Item b = (TestElement.Item)external.getItemList1().insert();
                b.setName("b");
                TestElement.Item c = (TestElement.Item)external.getItemList1().insert();
                c.setName("c");
                ((ExternalElementReferenceService)element.getExternalReference().service(ExternalElementReferenceService.class)).list(external.getItemList1());
                ElementReferenceTests.assertValidationOk(element.getExternalReference());
                element.setExternalReference("a");
                ElementReferenceTests.assertSame((Object)a, (Object)element.getExternalReference().target());
                ElementReferenceTests.assertValidationOk(element.getExternalReference());
                element.setExternalReference("c");
                ElementReferenceTests.assertSame((Object)c, (Object)element.getExternalReference().target());
                ElementReferenceTests.assertValidationOk(element.getExternalReference());
                element.setExternalReference("d");
                ElementReferenceTests.assertNull((Object)element.getExternalReference().target());
                ElementReferenceTests.assertValidationError(element.getExternalReference(), "Could not resolve external reference \"d\"");
                PossibleValuesService possibleValuesService = (PossibleValuesService)element.getExternalReference().service(PossibleValuesService.class);
                ElementReferenceTests.assertNotNull((Object)possibleValuesService);
                ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c"), (Object)possibleValuesService.values());
                TestElement.Item d = (TestElement.Item)external.getItemList1().insert();
                d.setName("d");
                ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "d"), (Object)possibleValuesService.values());
                ElementReferenceTests.assertValidationOk(element.getExternalReference());
                d.getName().write((Object)"dd", true);
                ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "dd"), (Object)possibleValuesService.values());
                ElementReferenceTests.assertEquals((Object)"dd", (Object)element.getExternalReference().content());
                ElementReferenceTests.assertValidationOk(element.getExternalReference());
            }
            finally {
                external.dispose();
            }
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testExternalElementReferenceRefactoring() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement external = (TestElement)TestElement.TYPE.instantiate();
            try {
                ((ExternalElementReferenceService)element.getExternalReference().service(ExternalElementReferenceService.class)).list(external.getItemList1());
                this.testRefactoring(external.getItemList1(), element.getExternalReference());
            }
            finally {
                external.dispose();
            }
        }
        finally {
            element.dispose();
        }
    }

    private void testRefactoring(ElementList<TestElement.Item> list, ReferenceValue<String, TestElement.Item> reference) {
        String referenceLabel = reference.definition().getLabel(true, CapitalizationType.NO_CAPS, false);
        PossibleValuesService possibleValuesService = (PossibleValuesService)reference.service(PossibleValuesService.class);
        TestElement.Item a = (TestElement.Item)list.insert();
        a.setName("a");
        TestElement.Item b = (TestElement.Item)list.insert();
        b.setName("b");
        TestElement.Item c = (TestElement.Item)list.insert();
        c.setName("c");
        TestElement.Item d = (TestElement.Item)list.insert();
        d.setName("d");
        reference.write((Object)"d");
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"dd", true);
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "dd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dd", (Object)reference.content());
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"ddd", false);
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "ddd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dd", (Object)reference.content());
        ElementReferenceTests.assertValidationError(reference, "Could not resolve " + referenceLabel + " \"dd\"");
        reference.write((Object)"ddd");
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"dddd", true);
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "dddd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dddd", (Object)reference.content());
        ElementReferenceTests.assertValidationOk(reference);
        d.getName().write((Object)"ddddd");
        ElementReferenceTests.assertEquals(ElementReferenceTests.set("a", "b", "c", "ddddd"), (Object)possibleValuesService.values());
        ElementReferenceTests.assertEquals((Object)"dddd", (Object)reference.content());
        ElementReferenceTests.assertValidationError(reference, "Could not resolve " + referenceLabel + " \"dddd\"");
    }
}

