/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.MustExist;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.services.ReferenceService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class ReferenceValidationService
extends ValidationService {
    @Text(value="Could not resolve {0} \"{1}\"")
    private static LocalizableText message;
    private ReferenceService referenceService;
    private Listener referenceServiceListener;

    static {
        LocalizableText.init(ReferenceValidationService.class);
    }

    @Override
    protected void initValidationService() {
        Property property = this.context(Property.class);
        this.referenceService = property.service(ReferenceService.class);
        if (this.referenceService != null) {
            this.referenceServiceListener = new Listener(){

                @Override
                public void handle(Event event) {
                    ReferenceValidationService.this.refresh();
                }
            };
            this.referenceService.attach(this.referenceServiceListener);
        }
    }

    @Override
    protected Status compute() {
        ReferenceValue reference = this.context(ReferenceValue.class);
        if (reference.target() == null && reference.text() != null) {
            ValueProperty property = reference.definition();
            String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
            String str = reference.text();
            String msg = message.format(label, str);
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.referenceServiceListener != null) {
            this.referenceService.detach(this.referenceServiceListener);
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(Reference.class) && property.hasAnnotation(MustExist.class);
        }
    }
}

