/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.element;

import org.eclipse.sapphire.Disposable;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.element.TestElement;
import org.junit.Test;

public final class ElementTests
extends SapphireTestCase {
    @Test
    public void HoldsElement() throws Exception {
        TestElement a = (TestElement)TestElement.TYPE.instantiate();
        try {
            TestElement aa = (TestElement)a.getElement().content(true);
            ElementTests.assertTrue((boolean)a.holds(aa));
            ElementTests.assertFalse((boolean)aa.holds(a));
            TestElement aaa = (TestElement)aa.getList().insert();
            ElementTests.assertTrue((boolean)a.holds(aaa));
            ElementTests.assertTrue((boolean)aa.holds(aaa));
            ElementTests.assertFalse((boolean)aaa.holds(a));
            ElementTests.assertFalse((boolean)aaa.holds(aa));
            TestElement ab = (TestElement)a.getList().insert();
            ElementTests.assertTrue((boolean)a.holds(ab));
            ElementTests.assertFalse((boolean)aa.holds(ab));
            ElementTests.assertFalse((boolean)ab.holds(aa));
            TestElement b = (TestElement)TestElement.TYPE.instantiate();
            try {
                ElementTests.assertFalse((boolean)a.holds(b));
                ElementTests.assertFalse((boolean)b.holds(a));
            }
            finally {
                b.dispose();
            }
        }
        finally {
            a.dispose();
        }
    }

    @Test
    public void HoldsProperty() throws Exception {
        TestElement a = (TestElement)TestElement.TYPE.instantiate();
        try {
            ElementTests.assertTrue((boolean)a.holds((Property)a.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)a.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)a.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)a.getList()));
            TestElement aa = (TestElement)a.getElement().content(true);
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)aa.getList()));
            TestElement aaa = (TestElement)aa.getList().insert();
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)aaa.getList()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getValue()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getTransient()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getElement()));
            ElementTests.assertTrue((boolean)aa.holds((Property)aaa.getList()));
            TestElement ab = (TestElement)a.getList().insert();
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getValue()));
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getTransient()));
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getElement()));
            ElementTests.assertTrue((boolean)a.holds((Property)ab.getList()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getValue()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getTransient()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getElement()));
            ElementTests.assertFalse((boolean)aa.holds((Property)ab.getList()));
            TestElement b = (TestElement)TestElement.TYPE.instantiate();
            try {
                ElementTests.assertFalse((boolean)a.holds((Property)b.getValue()));
                ElementTests.assertFalse((boolean)b.holds((Property)a.getValue()));
            }
            finally {
                b.dispose();
            }
        }
        finally {
            a.dispose();
        }
    }

    @Test
    public void Suspend() {
        EventLog log = new EventLog();
        TestElement a = (TestElement)TestElement.TYPE.instantiate();
        try {
            a.attach(log, "*");
            TestElement aa = (TestElement)a.getElement().content(true);
            aa.setValue("abc");
            aa.getList().insert();
            ElementTests.assertEquals((long)3L, (long)log.size());
            ElementTests.assertPropertyContentEvent(log.event(0), a.getElement());
            ElementTests.assertPropertyContentEvent(log.event(1), aa.getValue());
            ElementTests.assertPropertyContentEvent(log.event(2), aa.getList());
            log.clear();
            Disposable suspension = aa.suspend();
            try {
                aa.setValue("def");
                ((TestElement)aa.getList().insert()).setValue("ghi");
                ((TestElement)aa.getElement().content(true)).setValue("klm");
                ElementTests.assertEquals((long)0L, (long)log.size());
                a.setValue("nop");
                ElementTests.assertEquals((long)1L, (long)log.size());
                ElementTests.assertPropertyContentEvent(log.event(0), a.getValue());
                log.clear();
            }
            finally {
                suspension.dispose();
            }
            ElementTests.assertEquals((long)5L, (long)log.size());
            ElementTests.assertPropertyContentEvent(log.event(0), aa.getValue());
            ElementTests.assertPropertyContentEvent(log.event(1), aa.getList());
            ElementTests.assertPropertyContentEvent(log.event(2), ((TestElement)aa.getList().get(1)).getValue());
            ElementTests.assertPropertyContentEvent(log.event(3), aa.getElement());
            ElementTests.assertPropertyContentEvent(log.event(4), ((TestElement)aa.getElement().content()).getValue());
        }
        finally {
            a.dispose();
        }
    }
}

