/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.enabled;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.enabled.TestElement;
import org.junit.Test;

public final class EnabledFunctionTests
extends TestExpr {
    @Test
    public void testEnabledFunctionOnValueProperty() {
        this.testEnabledFunctionOnProperty((PropertyDef)TestElement.PROP_VALUE);
    }

    @Test
    public void testEnabledFunctionOnListProperty() {
        this.testEnabledFunctionOnProperty((PropertyDef)TestElement.PROP_LIST);
    }

    @Test
    public void testEnabledFunctionOnElementProperty() {
        this.testEnabledFunctionOnProperty((PropertyDef)TestElement.PROP_ELEMENT);
    }

    @Test
    public void testEnabledFunctionOnImpliedElementProperty() {
        this.testEnabledFunctionOnProperty((PropertyDef)TestElement.PROP_ELEMENT_IMPLIED);
    }

    private void testEnabledFunctionOnProperty(PropertyDef property) {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)("${ " + property.name() + ".Enabled }")).evaluate((FunctionContext)context);
        try {
            EnabledFunctionTests.assertFalse((boolean)((Boolean)fr.value()));
            element.setEnable(true);
            EnabledFunctionTests.assertTrue((boolean)((Boolean)fr.value()));
            element.setEnable(false);
            EnabledFunctionTests.assertFalse((boolean)((Boolean)fr.value()));
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testEnabledFunctionNull() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Enabled( null ) }").evaluate((FunctionContext)context);
        try {
            Status st = fr.status();
            EnabledFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            EnabledFunctionTests.assertEquals((Object)"Function Enabled does not accept nulls in position 0.", (Object)st.message());
        }
        finally {
            fr.dispose();
        }
    }

    @Test
    public void testEnabledFunctionWrongType() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
        FunctionResult fr = ExpressionLanguageParser.parse((String)"${ Enabled( 'abc' ) }").evaluate((FunctionContext)context);
        try {
            Status st = fr.status();
            EnabledFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
            EnabledFunctionTests.assertEquals((Object)"Function Enabled( java.lang.String ) is undefined.", (Object)st.message());
        }
        finally {
            fr.dispose();
        }
    }
}

