/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.functions.index;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.tests.modeling.el.functions.index.TestElement;
import org.junit.Test;

public final class IndexFunctionTests
extends TestExpr {
    @Test
    public void testIndexFunction() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            Element entry = element.getList().insert();
            ModelElementFunctionContext context = new ModelElementFunctionContext(entry);
            FunctionResult fr = ExpressionLanguageParser.parse((String)"${ This.Index }").evaluate((FunctionContext)context);
            try {
                IndexFunctionTests.assertEquals((Object)0, (Object)fr.value());
                element.getList().insert();
                IndexFunctionTests.assertEquals((Object)0, (Object)fr.value());
                element.getList().insert(0);
                IndexFunctionTests.assertEquals((Object)1, (Object)fr.value());
                element.getList().moveDown(entry);
                IndexFunctionTests.assertEquals((Object)2, (Object)fr.value());
                element.getList().remove(0);
                IndexFunctionTests.assertEquals((Object)1, (Object)fr.value());
                element.getList().remove(0);
                IndexFunctionTests.assertEquals((Object)0, (Object)fr.value());
            }
            finally {
                fr.dispose();
            }
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testIndexFunctionOnRoot() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            ModelElementFunctionContext context = new ModelElementFunctionContext((Element)element);
            FunctionResult fr = ExpressionLanguageParser.parse((String)"${ This.Index }").evaluate((FunctionContext)context);
            try {
                Status st = fr.status();
                IndexFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
                IndexFunctionTests.assertEquals((Object)"Cannot determine index if parent is not a list.", (Object)st.message());
            }
            finally {
                fr.dispose();
            }
        }
        finally {
            element.dispose();
        }
    }

    @Test
    public void testIndexFunctionOnElementPropertyContent() {
        TestElement element = (TestElement)TestElement.TYPE.instantiate();
        try {
            Element child = element.getElement().content(true);
            ModelElementFunctionContext context = new ModelElementFunctionContext(child);
            FunctionResult fr = ExpressionLanguageParser.parse((String)"${ This.Index }").evaluate((FunctionContext)context);
            try {
                Status st = fr.status();
                IndexFunctionTests.assertEquals((Object)Status.Severity.ERROR, (Object)st.severity());
                IndexFunctionTests.assertEquals((Object)"Cannot determine index if parent is not a list.", (Object)st.message());
            }
            finally {
                fr.dispose();
            }
        }
        finally {
            element.dispose();
        }
    }
}

