/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.el.t0017;

import java.util.List;
import org.eclipse.sapphire.modeling.el.AndFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.OrFunction;
import org.eclipse.sapphire.tests.modeling.el.TestExpr;
import org.eclipse.sapphire.util.ListFactory;
import org.junit.Test;

public final class TestExpr0017
extends TestExpr {
    @Test
    public void testAndFunction() {
        Function function = AndFunction.create((Function[])new Function[0]);
        TestExpr0017.assertNull((Object)function);
        function = AndFunction.create((Function[])new Function[]{Literal.TRUE});
        TestExpr0017.assertSame((Object)Literal.TRUE, (Object)function);
        function = AndFunction.create((List)ListFactory.singleton((Object)Literal.TRUE));
        TestExpr0017.assertSame((Object)Literal.TRUE, (Object)function);
        AndTestLogic testLogic = new AndTestLogic();
        this.test(2, testLogic);
        this.test(3, testLogic);
        this.test(4, testLogic);
    }

    @Test
    public void testOrFunction() {
        Function function = OrFunction.create((Function[])new Function[0]);
        TestExpr0017.assertNull((Object)function);
        function = OrFunction.create((Function[])new Function[]{Literal.TRUE});
        TestExpr0017.assertSame((Object)Literal.TRUE, (Object)function);
        function = OrFunction.create((List)ListFactory.singleton((Object)Literal.TRUE));
        TestExpr0017.assertSame((Object)Literal.TRUE, (Object)function);
        OrTestLogic testLogic = new OrTestLogic();
        this.test(2, testLogic);
        this.test(3, testLogic);
        this.test(4, testLogic);
    }

    private void test(int operands, TestLogic testLogic) {
        this.test(ListFactory.empty(), operands, testLogic);
    }

    private void test(List<Function> operands, int operandsToAdd, TestLogic testLogic) {
        if (operandsToAdd == 0) {
            testLogic.execute(operands);
        } else {
            int nextOperandsToAdd = operandsToAdd - 1;
            this.test(ListFactory.start().add(operands).add((Object)Literal.TRUE).result(), nextOperandsToAdd, testLogic);
            this.test(ListFactory.start().add(operands).add((Object)Literal.FALSE).result(), nextOperandsToAdd, testLogic);
        }
    }

    private static final class AndTestLogic
    extends TestLogic {
        private AndTestLogic() {
        }

        @Override
        public void execute(List<Function> operands) {
            boolean expectedResult = true;
            for (Function operand : operands) {
                boolean bl = expectedResult = expectedResult && operand == Literal.TRUE;
            }
            this.verify(operands, expectedResult, AndFunction.create(operands));
            this.verify(operands, expectedResult, AndFunction.create((Function[])operands.toArray(new Function[operands.size()])));
        }
    }

    private static final class OrTestLogic
    extends TestLogic {
        private OrTestLogic() {
        }

        @Override
        public void execute(List<Function> operands) {
            boolean expectedResult = false;
            for (Function operand : operands) {
                boolean bl = expectedResult = expectedResult || operand == Literal.TRUE;
            }
            this.verify(operands, expectedResult, OrFunction.create(operands));
            this.verify(operands, expectedResult, OrFunction.create((Function[])operands.toArray(new Function[operands.size()])));
        }
    }

    private static abstract class TestLogic {
        private TestLogic() {
        }

        public abstract void execute(List<Function> var1);

        protected final void verify(List<Function> inputOperands, boolean expectedResult, Function function) {
            TestExpr0017.assertEquals((long)inputOperands.size(), (long)function.operands().size());
            int i = 0;
            int n = inputOperands.size();
            while (i < n) {
                TestExpr0017.assertSame((Object)inputOperands.get(i), (Object)function.operand(i));
                ++i;
            }
            TestExpr0017.testForExpectedValue(new FunctionContext(), function, expectedResult);
        }
    }
}

