/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.modeling.xml.xsd.t0004;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlContentModelReference;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchemasCache;
import org.eclipse.sapphire.modeling.xml.schema.XmlElementDefinition;
import org.eclipse.sapphire.modeling.xml.schema.XmlGroupContentModel;
import org.eclipse.sapphire.modeling.xml.schema.XmlSequenceGroup;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0004.TestXmlXsd0004Circle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0004.TestXmlXsd0004Rectangle;
import org.eclipse.sapphire.tests.modeling.xml.xsd.t0004.TestXmlXsd0004Workbook;
import org.eclipse.sapphire.util.StringUtil;
import org.junit.Test;

public final class TestXmlXsd0004
extends SapphireTestCase {
    private static final String NAMESPACE = "http://www.eclipse.org/sapphire/tests/xml/xsd/0004/workbook";

    @Test
    public void testSchemaParsing() throws Exception {
        XmlDocumentSchema schema = XmlDocumentSchemasCache.getSchema((String)NAMESPACE);
        XmlElementDefinition workbookElementDef = schema.getElement("workbook");
        XmlSequenceGroup workbookContentModel = (XmlSequenceGroup)workbookElementDef.getContentModel();
        List workbookNestedContent = workbookContentModel.getNestedContent();
        TestXmlXsd0004.assertEquals((long)1L, (long)workbookNestedContent.size());
        XmlContentModelReference shapesGroupRef = (XmlContentModelReference)workbookNestedContent.get(0);
        XmlGroupContentModel shapesGroup = (XmlGroupContentModel)shapesGroupRef.getContentModel();
        List shapesGroupNestedContent = shapesGroup.getNestedContent();
        TestXmlXsd0004.assertEquals((long)2L, (long)shapesGroupNestedContent.size());
        XmlElementDefinition circleElementDef = (XmlElementDefinition)shapesGroupNestedContent.get(0);
        XmlSequenceGroup circleContentModel = (XmlSequenceGroup)circleElementDef.getContentModel();
        List circleNestedContent = circleContentModel.getNestedContent();
        TestXmlXsd0004.assertEquals((Object)"circle", (Object)circleElementDef.getName().getLocalPart());
        TestXmlXsd0004.assertEquals((long)3L, (long)circleNestedContent.size());
        TestXmlXsd0004.assertEquals((Object)"x", (Object)((XmlElementDefinition)circleNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0004.assertEquals((Object)"y", (Object)((XmlElementDefinition)circleNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0004.assertEquals((Object)"radius", (Object)((XmlElementDefinition)circleNestedContent.get(2)).getName().getLocalPart());
        XmlElementDefinition rectangleElementDef = (XmlElementDefinition)shapesGroupNestedContent.get(1);
        XmlSequenceGroup rectangleContentModel = (XmlSequenceGroup)rectangleElementDef.getContentModel();
        List rectangleNestedContent = rectangleContentModel.getNestedContent();
        TestXmlXsd0004.assertEquals((Object)"rectangle", (Object)rectangleElementDef.getName().getLocalPart());
        TestXmlXsd0004.assertEquals((long)4L, (long)rectangleNestedContent.size());
        TestXmlXsd0004.assertEquals((Object)"x", (Object)((XmlElementDefinition)rectangleNestedContent.get(0)).getName().getLocalPart());
        TestXmlXsd0004.assertEquals((Object)"y", (Object)((XmlElementDefinition)rectangleNestedContent.get(1)).getName().getLocalPart());
        TestXmlXsd0004.assertEquals((Object)"width", (Object)((XmlElementDefinition)rectangleNestedContent.get(2)).getName().getLocalPart());
        TestXmlXsd0004.assertEquals((Object)"height", (Object)((XmlElementDefinition)rectangleNestedContent.get(3)).getName().getLocalPart());
        XmlContentModel foundCircleContentModel = workbookContentModel.findChildElementContentModel(new QName(NAMESPACE, "circle"));
        TestXmlXsd0004.assertNotNull((Object)foundCircleContentModel);
        XmlContentModel foundRectangleContentModel = workbookContentModel.findChildElementContentModel(new QName(NAMESPACE, "rectangle"));
        TestXmlXsd0004.assertNotNull((Object)foundRectangleContentModel);
    }

    @Test
    public void testInsertOrder() throws Exception {
        ByteArrayResourceStore resourceStore = new ByteArrayResourceStore();
        TestXmlXsd0004Workbook workbook = (TestXmlXsd0004Workbook)TestXmlXsd0004Workbook.TYPE.instantiate((Resource)new RootXmlResource(new XmlResourceStore(resourceStore)));
        TestXmlXsd0004Circle circle = (TestXmlXsd0004Circle)workbook.getShapes().insert(TestXmlXsd0004Circle.class);
        circle.setRadius(3);
        circle.setY(2);
        circle.setX(1);
        TestXmlXsd0004Rectangle rectangle = (TestXmlXsd0004Rectangle)workbook.getShapes().insert(TestXmlXsd0004Rectangle.class);
        rectangle.setHeight(4);
        rectangle.setWidth(3);
        rectangle.setY(2);
        rectangle.setX(1);
        workbook.resource().save();
        String result = new String(resourceStore.getContents(), StringUtil.UTF8);
        TestXmlXsd0004.assertEqualsIgnoreNewLineDiffs(this.loadResource("ExpectedInsertionOrder.txt"), result);
    }
}

