/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.observable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ObservableList;
import org.eclipse.sapphire.tests.EventLog;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.util.ListFactory;
import org.junit.Test;

public final class ObservableListTests
extends SapphireTestCase {
    @Test
    public void Size() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        ObservableListTests.assertEquals((long)0L, (long)observable.size());
        base.add("a");
        base.add("b");
        ObservableListTests.assertEquals((long)2L, (long)observable.size());
        base.clear();
        ObservableListTests.assertEquals((long)0L, (long)observable.size());
    }

    @Test
    public void Empty() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        ObservableListTests.assertTrue((boolean)observable.isEmpty());
        base.add("a");
        ObservableListTests.assertFalse((boolean)observable.isEmpty());
        base.clear();
        ObservableListTests.assertTrue((boolean)observable.isEmpty());
    }

    @Test
    public void Contains() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        ObservableListTests.assertTrue((boolean)observable.contains((Object)"a"));
        ObservableListTests.assertFalse((boolean)observable.contains((Object)"b"));
        ObservableListTests.assertFalse((boolean)observable.contains(new Object()));
    }

    @Test
    public void IndexOf() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("a");
        base.add("c");
        ObservableListTests.assertEquals((long)0L, (long)observable.indexOf((Object)"a"));
        ObservableListTests.assertEquals((long)-1L, (long)observable.indexOf((Object)"d"));
    }

    @Test
    public void LastIndexOf() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("a");
        base.add("c");
        ObservableListTests.assertEquals((long)2L, (long)observable.lastIndexOf((Object)"a"));
        ObservableListTests.assertEquals((long)-1L, (long)observable.indexOf((Object)"d"));
    }

    @Test
    public void ContainsAll() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        ObservableListTests.assertTrue((boolean)observable.containsAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"a", "b"})));
        ObservableListTests.assertFalse((boolean)observable.containsAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"a", "d"})));
    }

    @Test
    public void Iterator() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        Iterator itr = observable.iterator();
        ObservableListTests.assertTrue((boolean)itr.hasNext());
        ObservableListTests.assertEquals((Object)"a", itr.next());
        ObservableListTests.assertTrue((boolean)itr.hasNext());
        ObservableListTests.assertEquals((Object)"b", itr.next());
        itr.remove();
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
        ObservableListTests.assertTrue((boolean)itr.hasNext());
        ObservableListTests.assertEquals((Object)"c", itr.next());
        ObservableListTests.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void ToArray1() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        Object[] array = observable.toArray();
        ObservableListTests.assertEquals((long)2L, (long)array.length);
        ObservableListTests.assertEquals((Object)"a", (Object)array[0]);
        ObservableListTests.assertEquals((Object)"b", (Object)array[1]);
    }

    @Test
    public void ToArray2() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        Object[] array = new String[2];
        String[] result = (String[])observable.toArray(array);
        ObservableListTests.assertSame((Object)array, (Object)result);
        ObservableListTests.assertEquals((Object)"a", (Object)array[0]);
        ObservableListTests.assertEquals((Object)"b", (Object)array[1]);
    }

    @Test
    public void Get() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        ObservableListTests.assertEquals((Object)"a", (Object)observable.get(0));
        ObservableListTests.assertEquals((Object)"b", (Object)observable.get(1));
    }

    @Test
    public void Set() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.set(1, (Object)"c");
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.set(1, (Object)"c");
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Add1() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.add((Object)"c");
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "b", "c"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
    }

    @Test
    public void Add2() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.add(1, (Object)"c");
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c", "b"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
    }

    @Test
    public void AddAll1() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.addAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"a", "c", "d"}));
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "b", "a", "c", "d"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
    }

    @Test
    public void AddAll2() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.addAll(1, (Collection)ListFactory.unmodifiable((Object[])new String[]{"a", "c", "d"}));
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "a", "c", "d", "b"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
    }

    @Test
    public void Remove1() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.remove((Object)"b");
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.remove((Object)"d");
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Remove2() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.remove(1);
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
    }

    @Test
    public void RemoveAll() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.removeAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"b", "c", "d"}));
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.removeAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"d", "e"}));
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a"}), base);
        ObservableListTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void RetainAll() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.retainAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}));
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.retainAll((Collection)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}));
        ObservableListTests.assertEquals((Object)ListFactory.unmodifiable((Object[])new String[]{"a", "c"}), base);
        ObservableListTests.assertEquals((long)0L, (long)log.size());
    }

    @Test
    public void Clear() throws Exception {
        ArrayList<String> base = new ArrayList<String>();
        ObservableList observable = new ObservableList(base);
        base.add("a");
        base.add("b");
        base.add("c");
        EventLog log = new EventLog();
        observable.attach((Listener)log);
        observable.clear();
        ObservableListTests.assertTrue((boolean)base.isEmpty());
        ObservableListTests.assertEquals((long)1L, (long)log.size());
        log.clear();
        observable.clear();
        ObservableListTests.assertTrue((boolean)base.isEmpty());
        ObservableListTests.assertEquals((long)0L, (long)log.size());
    }
}

