/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.tests.ui.def.loader;

import org.eclipse.core.runtime.Platform;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.osgi.BundleBasedContext;
import org.eclipse.sapphire.tests.SapphireTestCase;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.junit.Test;
import org.osgi.framework.Bundle;

public final class DefinitionLoaderTests
extends SapphireTestCase {
    @Test
    public void testCacheInClassContext() {
        DefinitionLoader.Reference h1 = DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("TestDefinition").dialog();
        try {
            DefinitionLoader.Reference h2 = DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("TestDefinition").dialog();
            try {
                DefinitionLoaderTests.assertSame((Object)h1.resolve(), (Object)h2.resolve());
            }
            finally {
                h2.dispose();
            }
        }
        finally {
            h1.dispose();
        }
    }

    @Test
    public void testCacheInClassLoaderContext() {
        Class<?> cl = ((Object)((Object)this)).getClass();
        ClassLoader cldr = cl.getClassLoader();
        String pkg = cl.getPackage().getName();
        DefinitionLoader.Reference h1 = DefinitionLoader.context((ClassLoader)cldr).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();
        try {
            DefinitionLoader.Reference h2 = DefinitionLoader.context((ClassLoader)cldr).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();
            try {
                DefinitionLoaderTests.assertSame((Object)h1.resolve(), (Object)h2.resolve());
            }
            finally {
                h2.dispose();
            }
        }
        finally {
            h1.dispose();
        }
    }

    @Test
    public void testCacheInBundleContext() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.sapphire.tests");
        Class<?> cl = ((Object)((Object)this)).getClass();
        String pkg = cl.getPackage().getName();
        DefinitionLoader.Reference h1 = DefinitionLoader.context((Context)BundleBasedContext.adapt((Bundle)bundle)).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();
        try {
            DefinitionLoader.Reference h2 = DefinitionLoader.context((Context)BundleBasedContext.adapt((Bundle)bundle)).sdef(String.valueOf(pkg) + ".TestDefinition").dialog();
            try {
                DefinitionLoaderTests.assertSame((Object)h1.resolve(), (Object)h2.resolve());
            }
            finally {
                h2.dispose();
            }
        }
        finally {
            h1.dispose();
        }
    }
}

