/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.graphics.swt;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.graphics.IRemoteDisplay;
import org.eclipse.tml.vncviewer.graphics.swt.ISWTPainter;
import org.eclipse.tml.vncviewer.graphics.swt.SWTVNCEventTranslator;
import org.eclipse.tml.vncviewer.network.IProtoClient;
import org.eclipse.tml.vncviewer.network.VNCKeyEvent;

public class SWTRemoteDisplay
extends Composite
implements IRemoteDisplay {
    private Canvas canvas;
    private IProtoClient protoClient;
    private Image screen = null;
    private int retries;
    private Properties configurationProperties;
    private static String NOT_AVAILABLE_MESSAGE = "View not available due to errors";
    private String host;
    private int port;
    private boolean active = false;
    private long firstRefreshDelayMs;
    private long refreshDelayPeriodMs;
    private int connectionRetries;
    private Timer refreshTimer;
    private Listener keyListener;
    private Listener mouseListener;
    private double zoomFactor;
    protected ISWTPainter painter;
    private volatile int connectionSerialNumber = 0;

    public SWTRemoteDisplay(Composite parent, Properties properties) {
        super(parent, 8);
        this.configurationProperties = properties;
        this.setLayout(parent.getLayout());
        this.canvas = new Canvas((Composite)this, 8);
        this.initConfiguration();
    }

    private void initConfiguration() {
        this.retries = this.connectionRetries = Integer.valueOf(this.configurationProperties.getProperty("CONNECTION_RETRIES")).intValue();
        this.zoomFactor = Double.valueOf(this.configurationProperties.getProperty("ZOOM_FACTOR"));
        this.firstRefreshDelayMs = Long.valueOf(this.configurationProperties.getProperty("FIRST_REFRESH_DELAY_MS"));
        this.refreshDelayPeriodMs = Long.valueOf(this.configurationProperties.getProperty("REFRESH_DELAY_PERIOD_MS"));
    }

    private void addKeyListener() {
        final SWTRemoteDisplay swtDisplay = this;
        this.keyListener = new Listener(){

            public void handleEvent(Event event) {
                Event ev = event;
                if (SWTRemoteDisplay.this.isActive()) {
                    try {
                        swtDisplay.keyEvent(ev);
                        swtDisplay.updateScreen();
                    }
                    catch (Exception exception) {
                        VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display error on key event.");
                    }
                }
                GC gc = new GC((Drawable)SWTRemoteDisplay.this.getCanvas());
                gc.drawImage(SWTRemoteDisplay.this.getScreen(), 0, 0);
                gc.dispose();
            }
        };
        this.getCanvas().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.addListener(1, SWTRemoteDisplay.this.keyListener);
                SWTRemoteDisplay.this.canvas.addListener(2, SWTRemoteDisplay.this.keyListener);
            }
        });
    }

    private void addMouseListener() {
        final SWTRemoteDisplay swtDisplay = this;
        this.mouseListener = new Listener(){

            public void handleEvent(Event event) {
                Event ev = event;
                if (SWTRemoteDisplay.this.isActive()) {
                    try {
                        swtDisplay.mouseEvent(ev);
                        boolean incremental = ev.type != 4;
                        swtDisplay.updateRequest(incremental);
                    }
                    catch (Exception exception) {
                        VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display error on key event.");
                    }
                }
                GC gc = new GC((Drawable)SWTRemoteDisplay.this.getCanvas());
                gc.drawImage(SWTRemoteDisplay.this.getScreen(), 0, 0);
                gc.dispose();
            }
        };
        this.getCanvas().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SWTRemoteDisplay.this.canvas.addListener(5, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.addListener(4, SWTRemoteDisplay.this.mouseListener);
                SWTRemoteDisplay.this.canvas.addListener(3, SWTRemoteDisplay.this.mouseListener);
            }
        });
    }

    private void addRefreshTimer() {
        this.refreshTimer = new Timer();
        final Display display = this.getDisplay();
        final SWTRemoteDisplay swtDisplay = this;
        this.refreshTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                display.syncExec(new Runnable(){

                    public void run() {
                        try {
                            SWTRemoteDisplay.this.updateScreen();
                        }
                        catch (Exception e) {
                            SWTRemoteDisplay.this.refreshTimer.cancel();
                            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Update screen error: " + e.getMessage());
                        }
                        if (swtDisplay.isActive() && !SWTRemoteDisplay.this.canvas.isDisposed()) {
                            GC gc = new GC((Drawable)SWTRemoteDisplay.this.getCanvas());
                            gc.drawImage(SWTRemoteDisplay.this.getScreen(), 0, 0);
                            gc.dispose();
                        } else {
                            SWTRemoteDisplay.this.refreshTimer.cancel();
                        }
                    }
                });
            }
        }, this.firstRefreshDelayMs, this.refreshDelayPeriodMs);
    }

    private synchronized void decreaseRetries() {
        --this.retries;
    }

    private synchronized int getRetries() {
        return this.retries;
    }

    private synchronized void setRetries(int newValue) {
        this.retries = newValue;
    }

    public synchronized void restart() throws Exception {
        int currentId = this.connectionSerialNumber;
        this.restart(currentId);
    }

    private synchronized void restart(int connectionId) throws Exception {
        if (connectionId == this.connectionSerialNumber) {
            if (this.getRetries() > 0) {
                this.decreaseRetries();
                try {
                    this.protoClient.stopProtocol();
                }
                catch (Exception e) {
                    VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display stop error : " + e.getMessage());
                }
                this.stop();
                this.protoClient.restartProtocol();
                this.start(this.protoClient);
            } else {
                throw new Exception("Number of connection retries exceeded the limit of " + this.connectionRetries + ".");
            }
        }
    }

    public synchronized void start(IProtoClient protocol) throws Exception {
        this.host = this.host;
        this.port = this.port;
        try {
            this.protoClient = protocol;
            this.painter = (ISWTPainter)this.protoClient.getPainter();
            this.protoClient.setPaintEnabled(true);
            this.addRefreshTimer();
            this.addKeyListener();
            this.addMouseListener();
            ++this.connectionSerialNumber;
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display start error: " + e.getMessage());
            int currentConnection = this.connectionSerialNumber;
            this.restart(currentConnection);
        }
        this.setRetries(this.connectionRetries);
        this.setRunning(true);
    }

    public synchronized void stop() {
        this.setRunning(false);
        this.refreshTimer.cancel();
        this.canvas.removeListener(2, this.keyListener);
        this.canvas.removeListener(1, this.keyListener);
        this.canvas.removeListener(5, this.mouseListener);
        this.canvas.removeListener(4, this.mouseListener);
        this.canvas.removeListener(3, this.mouseListener);
        this.keyListener = null;
        if (this.canvas != null) {
            GC gc = new GC((Drawable)this.canvas);
            gc.fillRectangle(0, 0, this.painter.getWidth(), this.painter.getHeight());
            gc.dispose();
        }
    }

    private void updateRequest(boolean incremental) throws Exception {
        try {
            this.protoClient.fbUpdateRequest(incremental);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display update screen error : " + e.getMessage());
            int currentConnection = this.connectionSerialNumber;
            this.restart(currentConnection);
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
        this.screen = new Image((Device)this.canvas.getDisplay(), this.painter.getImageData().scaledTo((int)((double)this.painter.getWidth() * this.zoomFactor), (int)((double)this.painter.getHeight() * this.zoomFactor)));
    }

    public void updateScreen() throws Exception {
        this.updateRequest(true);
    }

    public void keyEvent(Event event) throws Exception {
        try {
            VNCKeyEvent keyEvent = SWTVNCEventTranslator.getKeyEvent(event);
            this.protoClient.keyEvent(keyEvent);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display key event error : " + e.getMessage());
            this.setRunning(false);
            int currentConnection = this.connectionSerialNumber;
            this.restart(currentConnection);
        }
    }

    public void mouseEvent(Event event) throws Exception {
        try {
            this.protoClient.mouseEvent(SWTVNCEventTranslator.getMouseEvent(event));
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display mouse event error : " + e.getMessage());
            this.setRunning(false);
            int currentConnection = this.connectionSerialNumber;
            this.restart(currentConnection);
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public Image getScreen() {
        return this.screen;
    }

    public void setScreen(Image screen) {
        this.screen = screen;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    private synchronized void setRunning(boolean running) {
        this.active = running;
    }

    public void dispose() {
        try {
            this.protoClient.setPaintEnabled(false);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(SWTRemoteDisplay.class).error("Remote Display Stop error: " + e.getMessage());
        }
        if (this.screen != null) {
            this.screen.dispose();
        }
        if (this.canvas != null) {
            this.canvas.dispose();
        }
        super.dispose();
    }

    public int getScreenWidth() {
        return this.painter.getWidth();
    }

    public int getScreenHeight() {
        return this.painter.getHeight();
    }

    public Timer getRefreshTimer() {
        return this.refreshTimer;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(double zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.canvas != null) {
            this.canvas.setBackground(color);
        }
    }

    public IProtoClient getProtocol() {
        return this.protoClient;
    }
}

