/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.vncviewer.network;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.tml.vncviewer.VNCViewerPlugin;
import org.eclipse.tml.vncviewer.exceptions.ProtoClientException;
import org.eclipse.tml.vncviewer.network.Consumer;
import org.eclipse.tml.vncviewer.network.IPainter;
import org.eclipse.tml.vncviewer.network.IVNCPainter;
import org.eclipse.tml.vncviewer.network.PixelFormat;
import org.eclipse.tml.vncviewer.network.Protocol;
import org.eclipse.tml.vncviewer.network.VNCKeyEvent;
import org.eclipse.tml.vncviewer.network.VNCMouseEvent;

public abstract class VNCProtocol
extends Protocol {
    private int fbWidth;
    private int fbHeight;
    private IVNCPainter vncPainter;
    private PixelFormat pixelFormat;
    private String serverName;
    private static int SHARED_FLAG = 1;
    private Consumer consumer;
    private Thread consumerThread;
    static final int FB_UPDATE_REQUEST_MESSAGE_SIZE = 10;
    public static final int SET_PIXEL_FORMAT = 0;
    public static final int SET_ENCODINGS = 2;
    public static final int FRAMEBUFFER_UPDATE_REQUEST = 3;
    public static final int KEY_EVENT = 4;
    public static final int POINTER_EVENT = 5;
    public static final int CLIENT_CUT_TEXT = 6;
    public static final int FRAMEBUFFER_UPDATE = 0;
    public static final int SET_COLOUR_MAP_ENTRIES = 1;
    public static final int BELL = 2;
    public static final int SERVER_CUT_TEXT = 3;
    public static final int RAW_ENCODING = 0;
    public static final int COPY_RECT_ENCODING = 1;
    public static final int RRE_ENCODING = 2;
    public static final int HEXTILE_ENCODING = 5;
    public static final int ZRLE_ENCODING = 16;

    protected abstract void compareVersion(byte[] var1) throws Exception;

    protected abstract void handShake() throws Exception;

    protected void startConsumer() throws Exception {
        if (this.in == null) {
            throw new ProtoClientException("Not connected!");
        }
        this.consumer = new Consumer(this.in, this);
        this.consumerThread = new Thread(this.consumer);
        this.consumerThread.start();
    }

    private void initPhase() throws Exception {
        this.out.write(SHARED_FLAG);
        this.fbWidth = this.in.readUnsignedShort();
        this.fbHeight = this.in.readUnsignedShort();
        this.pixelFormat = new PixelFormat();
        this.pixelFormat.getPixelFormat(this.in);
        this.vncPainter.setPixelFormat(this.pixelFormat);
        this.vncPainter.setSize(this.fbWidth, this.fbHeight);
        int nameLen = this.in.readInt();
        byte[] serverName = new byte[nameLen];
        this.in.read(serverName, 0, nameLen);
        this.serverName = "";
        int i = 0;
        while (i < serverName.length) {
            char c = (char)serverName[i];
            this.serverName = String.valueOf(this.serverName) + c;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fbUpdateRequest(boolean incremental) throws Exception {
        byte[] upReq = new byte[10];
        upReq[0] = 3;
        upReq[1] = (byte)(incremental ? 1 : 0);
        upReq[5] = 0;
        upReq[4] = 0;
        upReq[3] = 0;
        upReq[2] = 0;
        upReq[6] = (byte)(this.fbWidth >> 8 & 0xFF);
        upReq[7] = (byte)((byte)this.fbWidth & 0xFF);
        upReq[8] = (byte)(this.fbHeight >> 8 & 0xFF);
        upReq[9] = (byte)((byte)this.fbHeight & 0xFF);
        Socket socket = this.socket;
        synchronized (socket) {
            try {
                this.out.write(upReq);
                this.out.flush();
            }
            catch (IOException ioe) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Framebuffer Update Request message error: " + ioe.getMessage());
                throw new ProtoClientException("Framebuffer Update Request message error.");
            }
        }
    }

    private void readRect() throws Exception {
        this.readRect(this.vncPainter);
    }

    protected void readRect(IVNCPainter vncPainter) throws Exception {
        int encType;
        int h;
        int w;
        int y;
        int x;
        try {
            x = this.in.readUnsignedShort();
            y = this.in.readUnsignedShort();
            w = this.in.readUnsignedShort();
            h = this.in.readUnsignedShort();
            encType = this.in.readInt();
        }
        catch (IOException ioe) {
            VNCViewerPlugin.log(VNCProtocol.class).error("Rectangle message error: " + ioe.getMessage());
            throw new ProtoClientException("Rectangle message error.");
        }
        int pixelsNum = w * h;
        int bytesNum = pixelsNum * (this.pixelFormat.getBitsPerPixel() / 8);
        byte[] pixelsb = new byte[bytesNum];
        int bytesRead = 0;
        while (bytesRead < bytesNum) {
            int numRead;
            try {
                numRead = this.in.read(pixelsb, bytesRead, bytesNum - bytesRead);
            }
            catch (IOException ioe) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Rectangle message error: " + ioe.getMessage());
                throw new ProtoClientException("Rectangle message error.");
            }
            if (numRead < 0) continue;
            bytesRead += numRead;
        }
        if (this.paintEnabled) {
            vncPainter.processRectangle(encType, pixelsb, x, y, w, h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fbUpdate() throws Exception {
        try {
            this.in.readByte();
        }
        catch (IOException ioe) {
            VNCViewerPlugin.log(VNCProtocol.class).error("Framebuffer Update error: " + ioe.getMessage());
            throw new ProtoClientException("Framebuffer Update error.");
        }
        Socket socket = this.socket;
        synchronized (socket) {
            int fbNumRect;
            try {
                fbNumRect = this.in.readUnsignedShort();
            }
            catch (IOException ioe) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Framebuffer Update error: " + ioe.getMessage());
                throw new ProtoClientException("Framebuffer Update error.");
            }
            int i = 0;
            while (i < fbNumRect) {
                this.readRect();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyEvent(VNCKeyEvent event) throws Exception {
        byte[] keyMsg = new byte[8];
        keyMsg[0] = 4;
        keyMsg[1] = event.isPressed() ? (byte)1 : 0;
        keyMsg[3] = 0;
        keyMsg[2] = 0;
        int keysym = event.getKeysym();
        keyMsg[4] = (byte)(keysym >> 24 & 0xFF);
        keyMsg[5] = (byte)(keysym >> 16 & 0xFF);
        keyMsg[6] = (byte)(keysym >> 8 & 0xFF);
        keyMsg[7] = (byte)(keysym & 0xFF);
        Socket socket = this.socket;
        synchronized (socket) {
            try {
                this.out.write(keyMsg);
                this.out.flush();
            }
            catch (IOException ioe) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Key Event message error: " + ioe.getMessage());
                throw new ProtoClientException("Key Event message error.");
            }
        }
    }

    public void runProtocol(String host, int port) throws IOException, Exception {
        try {
            this.openConnection(host, port);
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("Open Connection error: " + e.getMessage());
            throw new ProtoClientException("Open Connection error.");
        }
        try {
            this.handShake();
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC Handshake Phase error: " + e.getMessage());
            throw new ProtoClientException("VNC Handshake Phase error.");
        }
        try {
            this.initPhase();
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC Init Phase error: " + e.getMessage());
            throw new ProtoClientException("VNC Init Phase error.");
        }
        try {
            this.startConsumer();
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("VNC Consumer start error: " + e.getMessage());
            throw new ProtoClientException("VNC Consumer start error.");
        }
    }

    public void restartProtocol() throws Exception {
        if (this.isConnected()) {
            this.stopProtocol();
        }
        this.runProtocol(this.host, this.port);
    }

    public void stopProtocol() throws ProtoClientException {
        if (this.consumer != null) {
            this.consumer.setRunning(false);
        }
        try {
            this.closeConnection();
        }
        catch (Exception e) {
            VNCViewerPlugin.log(VNCProtocol.class).error("Close connection error: " + e.getMessage());
            throw new ProtoClientException("Close connection error.");
        }
    }

    public IVNCPainter getVncPainter() {
        return this.vncPainter;
    }

    public void setVncPainter(IVNCPainter vncPainter) {
        this.vncPainter = vncPainter;
    }

    public IPainter getPainter() {
        return this.vncPainter;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getHeight() {
        return this.fbHeight;
    }

    public int getwidth() {
        return this.fbWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseEvent(VNCMouseEvent event) throws Exception {
        byte[] keyMsg = new byte[]{5, event.isButtonPressed() ? (byte)1 : 0, (byte)(event.getX() >> 8 & 0xFF), (byte)event.getX(), (byte)(event.getY() >> 8 & 0xFF), (byte)event.getY()};
        Socket socket = this.socket;
        synchronized (socket) {
            try {
                this.out.write(keyMsg);
                this.out.flush();
            }
            catch (IOException ioe) {
                VNCViewerPlugin.log(VNCProtocol.class).error("Mouse Event message error: " + ioe.getMessage());
                throw new ProtoClientException("Mouse Event message error.");
            }
        }
    }
}

