/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCharacteristic;

public class BluetoothService {
    private final UUID uuid;
    private final int handleStart;
    private final int handleEnd;
    protected int instanceId;
    protected boolean primaryService;
    protected final Map<UUID, BluetoothCharacteristic> supportedCharacteristics = new ConcurrentHashMap<UUID, BluetoothCharacteristic>();

    public BluetoothService(UUID uuid) {
        this(uuid, true, 0, 0);
    }

    public BluetoothService(UUID uuid, boolean primaryService) {
        this(uuid, primaryService, 0, 0);
    }

    public BluetoothService(UUID uuid, boolean primaryService, int handleStart, int handleEnd) {
        this.uuid = uuid;
        this.primaryService = primaryService;
        this.handleStart = handleStart;
        this.handleEnd = handleEnd;
    }

    public BluetoothCharacteristic getCharacteristic(UUID uuid) {
        return this.supportedCharacteristics.get(uuid);
    }

    public List<BluetoothCharacteristic> getCharacteristics() {
        return new ArrayList<BluetoothCharacteristic>(this.supportedCharacteristics.values());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getHandleStart() {
        return this.handleStart;
    }

    public int getHandleEnd() {
        return this.handleEnd;
    }

    public boolean isPrimary() {
        return this.primaryService;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public boolean providesCharacteristic(UUID uuid) {
        return this.supportedCharacteristics.containsKey(uuid);
    }

    public boolean addCharacteristic(BluetoothCharacteristic characteristic) {
        if (this.supportedCharacteristics.get(characteristic.getUuid()) != null) {
            return false;
        }
        this.supportedCharacteristics.put(characteristic.getUuid(), characteristic);
        characteristic.setService(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothCharacteristic getCharacteristicByHandle(int handle) {
        Map<UUID, BluetoothCharacteristic> map = this.supportedCharacteristics;
        synchronized (map) {
            for (BluetoothCharacteristic characteristic : this.supportedCharacteristics.values()) {
                if (characteristic.getHandle() != handle) continue;
                return characteristic;
            }
        }
        return null;
    }

    public GattService getService() {
        return GattService.getService(this.uuid);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BluetoothService [uuid=");
        builder.append(this.uuid);
        builder.append(", handleStart=");
        builder.append(this.handleStart);
        builder.append(", handleEnd=");
        builder.append(this.handleEnd);
        builder.append(']');
        return builder.toString();
    }

    public static enum GattService {
        ALERT_NOTIFICATION_SERVICE(6161L),
        AUTOMATION_IO(6165L),
        BATTERY_SERVICE(6159L),
        BLOOD_PRESSURE(6160L),
        BODY_COMPOSITION(6171L),
        BOND_MANAGEMENT(6174L),
        CONTINUOUS_GLUCOSE_MONITORING(6175L),
        CURRENT_TIME_SERVICE(6149L),
        CYCLING_POWER(6168L),
        CYCLING_SPEED_AND_CADENCE(6166L),
        DEVICE_INFORMATION(6154L),
        ENVIRONMENTAL_SENSING(6170L),
        GENERIC_ACCESS(6144L),
        GENERIC_ATTRIBUTE(6145L),
        GLUCOSE(6152L),
        HEALTH_THERMOMETER(6153L),
        HEART_RATE(6157L),
        HTTP_PROXY(6179L),
        HUMAN_INTERFACE_DEVICE(6162L),
        IMMEDIATE_ALERT(6146L),
        INDOOR_POSITIONING(6177L),
        INTERNET_PROTOCOL_SUPPORT(6176L),
        LINK_LOSS(6147L),
        LOCATION_AND_NAVIGATION(6169L),
        NEXT_DST_CHANGE_SERVICE(6151L),
        PHONE_ALERT_STATUS_SERVICE(6158L),
        REFERENCE_TIME_UPDATE_SERVICE(6150L),
        RUNNING_SPEED_AND_CADENCE(6164L),
        SCAN_PARAMETERS(6163L),
        TX_POWER(6148L),
        USER_DATA(6172L),
        WEIGHT_SCALE(6173L);

        private static Map<UUID, GattService> uuidToServiceMapping;
        private UUID uuid;

        private GattService(long key) {
            this.uuid = new UUID(key << 32 | 0x1000L, -9223371485494954757L);
        }

        private static void initMapping() {
            uuidToServiceMapping = new HashMap<UUID, GattService>();
            GattService[] gattServiceArray = GattService.values();
            int n = gattServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                GattService s = gattServiceArray[n2];
                uuidToServiceMapping.put(s.uuid, s);
                ++n2;
            }
        }

        public static GattService getService(UUID uuid) {
            if (uuidToServiceMapping == null) {
                GattService.initMapping();
            }
            return uuidToServiceMapping.get(uuid);
        }

        public UUID getUUID() {
            return this.uuid;
        }
    }
}

