/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth.discovery.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.smarthome.binding.bluetooth.BluetoothAdapter;
import org.eclipse.smarthome.binding.bluetooth.BluetoothBindingConstants;
import org.eclipse.smarthome.binding.bluetooth.BluetoothCompanyIdentifiers;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDevice;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDiscoveryListener;
import org.eclipse.smarthome.binding.bluetooth.discovery.BluetoothDiscoveryParticipant;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.UID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.bluetooth")
public class BluetoothDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(BluetoothDiscoveryService.class);
    private static final int SEARCH_TIME = 15;
    private final Set<BluetoothAdapter> adapters = new CopyOnWriteArraySet<BluetoothAdapter>();
    private final Set<BluetoothDiscoveryParticipant> participants = new CopyOnWriteArraySet<BluetoothDiscoveryParticipant>();
    private final Map<UID, BluetoothDiscoveryListener> registeredListeners = new ConcurrentHashMap<UID, BluetoothDiscoveryListener>();
    private final Set<ThingTypeUID> supportedThingTypes = new CopyOnWriteArraySet<ThingTypeUID>();

    public BluetoothDiscoveryService() {
        super(15);
        this.supportedThingTypes.add(BluetoothBindingConstants.THING_TYPE_BEACON);
    }

    @Activate
    protected void activate(Map<String, Object> configProperties) {
        this.logger.debug("Activating Bluetooth discovery service");
        super.activate(configProperties);
        this.startScan();
    }

    @Modified
    protected void modified(Map<String, Object> configProperties) {
        super.modified(configProperties);
    }

    @Deactivate
    public void deactivate() {
        this.logger.debug("Deactivating Bluetooth discovery service");
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addBluetoothAdapter(final BluetoothAdapter adapter) {
        this.adapters.add(adapter);
        BluetoothDiscoveryListener listener = new BluetoothDiscoveryListener(){

            @Override
            public void deviceDiscovered(BluetoothDevice device) {
                BluetoothDiscoveryService.this.deviceDiscovered(adapter, device);
            }
        };
        adapter.addDiscoveryListener(listener);
        this.registeredListeners.put((UID)adapter.getUID(), listener);
    }

    protected void removeBluetoothAdapter(BluetoothAdapter adapter) {
        this.adapters.remove(adapter);
        adapter.removeDiscoveryListener(this.registeredListeners.remove(adapter.getUID()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addBluetoothDiscoveryParticipant(BluetoothDiscoveryParticipant participant) {
        this.participants.add(participant);
        this.supportedThingTypes.addAll(participant.getSupportedThingTypeUIDs());
    }

    protected void removeBluetoothDiscoveryParticipant(BluetoothDiscoveryParticipant participant) {
        this.supportedThingTypes.removeAll(participant.getSupportedThingTypeUIDs());
        this.participants.remove(participant);
    }

    public Set<ThingTypeUID> getSupportedThingTypes() {
        return this.supportedThingTypes;
    }

    public void startScan() {
        for (BluetoothAdapter adapter : this.adapters) {
            adapter.scanStart();
        }
    }

    public void stopScan() {
        for (BluetoothAdapter adapter : this.adapters) {
            adapter.scanStop();
        }
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    private void deviceDiscovered(BluetoothAdapter adapter, BluetoothDevice device) {
        String manufacturer;
        for (BluetoothDiscoveryParticipant participant : this.participants) {
            try {
                DiscoveryResult result = participant.createResult(device);
                if (result == null) continue;
                this.thingDiscovered(result);
                return;
            }
            catch (Exception e) {
                this.logger.error("Participant '{}' threw an exception", (Object)participant.getClass().getName(), (Object)e);
            }
        }
        String label = device.getName();
        if (label == null || label.length() == 0 || label.equals(device.getAddress().toString().replace(':', '-'))) {
            label = "Bluetooth Device";
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("address", device.getAddress().toString());
        Integer txPower = device.getTxPower();
        if (txPower != null && txPower > 0) {
            properties.put("txpower", Integer.toString(txPower));
        }
        if ((manufacturer = BluetoothCompanyIdentifiers.get(device.getManufacturerId())) != null) {
            properties.put("vendor", manufacturer);
            label = String.valueOf(label) + " (" + manufacturer + ")";
        }
        ThingUID thingUID = new ThingUID(BluetoothBindingConstants.THING_TYPE_BEACON, (ThingUID)adapter.getUID(), device.getAddress().toString().toLowerCase().replace(":", ""));
        DiscoveryResult discoveryResult = DiscoveryResultBuilder.create((ThingUID)thingUID).withProperties(properties).withRepresentationProperty("address").withBridge((ThingUID)adapter.getUID()).withLabel(label).build();
        this.thingDiscovered(discoveryResult);
    }
}

