/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.editors.forms.widgets;

import org.eclipse.core.runtime.Assert;
import org.eclipse.sphinx.emf.editors.forms.widgets.IFormWidgetFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class FormWidgetFactory
implements IFormWidgetFactory {
    protected static final int MAX_WITDH = 175;
    protected FormToolkit toolkit;

    public FormWidgetFactory(FormToolkit toolkit) {
        Assert.isNotNull((Object)toolkit);
        this.toolkit = toolkit;
    }

    public Button createButton(Composite parent, String text) {
        return this.createButton(parent, text, 0, 128, 16, false, false, 1, 1);
    }

    public Button createButton(Composite parent, String text, int style) {
        return this.createButton(parent, text, style, 128, 16, false, false, 1, 1);
    }

    public Button createButton(Composite parent, String text, int style, int valign, boolean hgrab, int hspan) {
        return this.createButton(parent, text, style, 128, valign, hgrab, false, hspan, 1);
    }

    public Button createButton(Composite parent, String text, int style, int halign, int valign, boolean hgrab, boolean vgrab, int hspan, int vspan) {
        Button button = this.toolkit.createButton(parent, text, style);
        TableWrapData data = new TableWrapData(128);
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = hspan;
        data.rowspan = vspan;
        button.setLayoutData((Object)data);
        return button;
    }

    public Label createLabel(Composite parent, String text) {
        return this.createLabel(parent, text, 0, 1, false, 16);
    }

    public Label createLabel(Composite parent, String text, int colspan, boolean grabHorizontal) {
        return this.createLabel(parent, text, 0, colspan, grabHorizontal, 16);
    }

    public Label createLabel(Composite parent, String text, int valign) {
        return this.createLabel(parent, text, 0, 1, false, valign);
    }

    public Label createLabel(Composite parent, String text, int colspan, boolean grabHorizontal, int valign) {
        return this.createLabel(parent, text, 0, colspan, grabHorizontal, valign);
    }

    public Label createLabel(Composite parent, String text, boolean multiLine, int hspan, boolean hgrab) {
        return this.createLabel(parent, text, 0, 128, 16, hgrab, false, hspan, 1);
    }

    public Label createLabel(Composite parent, String text, int style, int colspan, boolean grabHorizontal, int valign) {
        return this.createLabel(parent, text, style, 128, valign, grabHorizontal, false, colspan, 1);
    }

    public Label createLabel(Composite parent, String text, int style, int halign, int valign, boolean hgrab, boolean vgrab, int colspan, int rowspan) {
        Label label = this.toolkit.createLabel(parent, text, style);
        TableWrapData data = new TableWrapData(128);
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = colspan;
        data.rowspan = rowspan;
        label.setLayoutData((Object)data);
        return label;
    }

    public Hyperlink createHyperlink(Composite parent, String text) {
        return this.createHyperlink(parent, text, 0, 1, false, 16);
    }

    public Hyperlink createHyperlink(Composite parent, String text, int colspan, boolean grabHorizontal) {
        return this.createHyperlink(parent, text, 0, colspan, grabHorizontal, 16);
    }

    public Hyperlink createHyperlink(Composite parent, String text, int valign) {
        return this.createHyperlink(parent, text, 0, 1, false, valign);
    }

    public Hyperlink createHyperlink(Composite parent, String text, int colspan, boolean grabHorizontal, int valign) {
        return this.createHyperlink(parent, text, 0, colspan, grabHorizontal, valign);
    }

    public Hyperlink createHyperlink(Composite parent, String text, int style, int colspan, boolean grabHorizontal, int valign) {
        return this.createHyperlink(parent, text, style, 128, valign, grabHorizontal, false, colspan, 1);
    }

    public Hyperlink createHyperlink(Composite parent, String text, int style, int halign, int valign, boolean hgrab, boolean vgrab, int colspan, int rowspan) {
        Hyperlink link = this.toolkit.createHyperlink(parent, text, style);
        TableWrapData data = new TableWrapData(128);
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = colspan;
        data.rowspan = rowspan;
        link.setLayoutData((Object)data);
        return link;
    }

    @Override
    public FormText createFormText(Composite parent) {
        return this.createFormText(parent, 1, true);
    }

    @Override
    public FormText createFormText(Composite parent, int colspan, boolean grabHorizontal) {
        FormText text = this.toolkit.createFormText(parent, true);
        TableWrapData data = new TableWrapData(128);
        data.colspan = colspan;
        data.grabHorizontal = grabHorizontal;
        text.setLayoutData((Object)data);
        return text;
    }

    public Text createText(Composite parent) {
        return this.createText(parent, false, 0, 1, true);
    }

    public Text createText(Composite parent, int style) {
        return this.createText(parent, false, style, 1, true);
    }

    public Text createText(Composite parent, boolean multiLine) {
        return this.createText(parent, multiLine, 0, 1, true);
    }

    public Text createText(Composite parent, int colspan, boolean grabHorizontal) {
        return this.createText(parent, false, 0, colspan, grabHorizontal);
    }

    public Text createText(Composite parent, boolean multiLine, int colspan, boolean grabHorizontal) {
        return this.createText(parent, multiLine, 0, colspan, grabHorizontal);
    }

    public Text createText(Composite parent, boolean multiLine, int style, int colspan, boolean grabHorizontal) {
        return this.createText(parent, multiLine, style, 128, 16, grabHorizontal, false, colspan, 1);
    }

    public Text createText(Composite parent, boolean multiLine, int style, int halign, int valign, boolean hgrab, boolean vgrab, int hspan, int vspan) {
        style = multiLine ? (style |= 0x242) : (style |= 4);
        Text text = this.toolkit.createText(parent, null, style);
        TableWrapData data = new TableWrapData(128);
        data.heightHint = multiLine ? text.getLineHeight() * 5 + 6 : text.getLineHeight() + 4;
        data.maxWidth = 175;
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = hspan;
        data.rowspan = vspan;
        text.setLayoutData((Object)data);
        return text;
    }

    public Combo createCombo(Composite parent, int style, boolean hgrab, int hspan) {
        return this.createCombo(parent, style, 128, 128, hgrab, false, hspan, 1);
    }

    public Combo createCombo(Composite parent, int style, int halign, int valign, boolean hgrab, boolean vgrab, int hspan, int vspan) {
        Combo combo = new Combo(parent, style);
        combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.adapt((Control)combo, true, true);
        TableWrapData data = new TableWrapData(128);
        data.maxWidth = 175;
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = hspan;
        data.rowspan = vspan;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public CCombo createCCombo(Composite parent) {
        return this.createCCombo(parent, false, 0, 1, true);
    }

    public CCombo createCCombo(Composite parent, boolean editable) {
        return this.createCCombo(parent, editable, 0, 1, true);
    }

    public CCombo createCCombo(Composite parent, int colspan, boolean grabHorizontal) {
        return this.createCCombo(parent, false, 0, colspan, grabHorizontal);
    }

    public CCombo createCCombo(Composite parent, boolean editable, int colspan, boolean grabHorizontal) {
        return this.createCCombo(parent, editable, 0, colspan, grabHorizontal);
    }

    public CCombo createCCombo(Composite parent, boolean editable, int style, int colspan, boolean grabHorizontal) {
        return this.createCCombo(parent, editable, style, 128, 16, grabHorizontal, false, colspan, 1);
    }

    public CCombo createCCombo(Composite parent, int style, boolean hgrab, int hspan) {
        return this.createCCombo(parent, style, 128, 128, hgrab, false, hspan, 1);
    }

    public CCombo createCCombo(Composite parent, boolean editable, int style, int halign, int valign, boolean hgrab, boolean vgrab, int hspan, int vspan) {
        if (!editable) {
            style |= 8;
        }
        return this.createCCombo(parent, style, halign, valign, hgrab, vgrab, hspan, vspan);
    }

    public CCombo createCCombo(Composite parent, int style, int halign, int valign, boolean hgrab, boolean vgrab, int hspan, int vspan) {
        CCombo combo = new CCombo(parent, style);
        combo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.adapt((Control)combo, true, true);
        TableWrapData data = new TableWrapData(128);
        data.maxWidth = 175;
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = hspan;
        data.rowspan = vspan;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public Button createCheckBoxButton(Composite parent, String text) {
        return this.createCheckBoxButton(parent, text, 0, 1, true);
    }

    public Button createCheckBoxButton(Composite parent, String text, int colspan, boolean grabHorizontal) {
        return this.createCheckBoxButton(parent, text, 0, colspan, grabHorizontal);
    }

    public Button createCheckBoxButton(Composite parent, String text, int style, int colspan, boolean grabHorizontal) {
        return this.createCheckBoxButton(parent, text, style, 128, 16, grabHorizontal, false, colspan, 1);
    }

    public Button createCheckBoxButton(Composite parent, String text, int style, int halign, int valign, boolean hgrab, boolean vgrab, int hspan, int vspan) {
        Button button = this.toolkit.createButton(parent, text, 0x20 | style);
        TableWrapData data = new TableWrapData(128);
        data.grabHorizontal = hgrab;
        data.grabVertical = vgrab;
        data.align = halign;
        data.valign = valign;
        data.colspan = hspan;
        data.rowspan = vspan;
        button.setLayoutData((Object)data);
        return button;
    }
}

