/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LanguageCultureName implements Enumerator
{
    EN_US(0, "enUS", "en-US"),
    DE_DE(1, "deDE", "de-DE"),
    FR_FR(2, "frFR", "fr-FR");

    public static final int EN_US_VALUE = 0;
    public static final int DE_DE_VALUE = 1;
    public static final int FR_FR_VALUE = 2;
    private static final LanguageCultureName[] VALUES_ARRAY;
    public static final List<LanguageCultureName> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LanguageCultureName[]{EN_US, DE_DE, FR_FR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LanguageCultureName get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageCultureName result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageCultureName getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LanguageCultureName result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LanguageCultureName get(int value) {
        switch (value) {
            case 0: {
                return EN_US;
            }
            case 1: {
                return DE_DE;
            }
            case 2: {
                return FR_FR;
            }
        }
        return null;
    }

    private LanguageCultureName(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

