/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflow;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.mwe.dynamic.IWorkflowHandler;
import org.eclipse.sphinx.emf.mwe.dynamic.ModelWorkflowContext;
import org.eclipse.sphinx.emf.mwe.dynamic.WorkflowHandlerRegistry;
import org.eclipse.sphinx.emf.mwe.dynamic.WorkspaceWorkflow;
import org.eclipse.sphinx.emf.mwe.dynamic.components.IModelWorkflowComponent;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.WorkflowInstanceFactory;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.messages.Messages;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.IWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.util.WorkflowRunnerHelper;
import org.eclipse.sphinx.emf.mwe.dynamic.util.XtendUtil;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.platform.operations.AbstractLabeledRunnable;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;
import org.eclipse.sphinx.platform.operations.ILabeledRunnable;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class BasicWorkflowRunnerOperation
extends AbstractWorkspaceOperation
implements IWorkflowRunnerOperation {
    private Object workflow;
    private Object model;
    private List<URI> modelURIs = new ArrayList<URI>();
    private Set<IModelDescriptor> modelDescriptors = new HashSet<IModelDescriptor>();
    private Set<Resource> emfModelResources = new HashSet<Resource>();
    private boolean autoSave = false;
    private Map<String, Object> arguments = new HashMap<String, Object>();
    protected WorkflowInstanceFactory workflowInstanceFactory = new WorkflowInstanceFactory();
    protected WorkflowRunnerHelper helper = new WorkflowRunnerHelper();

    public BasicWorkflowRunnerOperation(String label, Object workflow) {
        super(label);
        this.workflow = workflow;
    }

    @Override
    public Object getWorkflow() {
        return this.workflow;
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public List<URI> getModelURIs() {
        return this.modelURIs;
    }

    @Override
    public boolean isAutoSave() {
        return this.autoSave;
    }

    @Override
    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    @Override
    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public ISchedulingRule getRule() {
        return null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            final Workflow workflowInstance = this.createWorkflowInstance();
            if (workflowInstance == null) {
                return;
            }
            this.model = this.loadModel((IProgressMonitor)progress.newChild(5));
            Map<String, Class<?>> parameters = this.workflowInstanceFactory.getWorkflowParameters(workflowInstance);
            Map<String, Object> convertedArguments = this.helper.toArgumentObjects(this.arguments, parameters);
            this.workflowInstanceFactory.injectArguments(workflowInstance, convertedArguments);
            final IWorkflowContext context = this.createWorkflowContext(this.model, convertedArguments, (IProgressMonitor)progress.newChild(90));
            List<IWorkflowHandler> sortedHandlers = WorkflowHandlerRegistry.INSTANCE.getSortedHandlers(workflowInstance.getClass().asSubclass(IWorkflow.class));
            for (IWorkflowHandler workflowHandler : sortedHandlers) {
                workflowHandler.preRun((IWorkflow)workflowInstance, context);
            }
            AbstractLabeledRunnable runnable = new AbstractLabeledRunnable(this.getLabel()){

                public void run() {
                    workflowInstance.run(context);
                }
            };
            TransactionalEditingDomain editingDomain = this.getEditingDomain(this.model);
            if (editingDomain != null && this.hasModelWorkflowComponents(workflowInstance)) {
                if (this.isModifyingModel(workflowInstance)) {
                    WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (ILabeledRunnable)runnable);
                } else {
                    editingDomain.runExclusive((Runnable)runnable);
                }
            } else {
                runnable.run();
            }
            for (IWorkflowHandler workflowHandler : sortedHandlers) {
                workflowHandler.postRun((IWorkflow)workflowInstance, context);
            }
            if (this.isAutoSave()) {
                this.saveModel((IProgressMonitor)progress.newChild(5));
            } else {
                progress.worked(5);
            }
        }
        catch (OperationCanceledException ex) {
            throw ex;
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }

    protected Workflow createWorkflowInstance() throws CoreException {
        return this.workflowInstanceFactory.createWorkflowInstance(this.workflow);
    }

    protected IWorkflowContext createWorkflowContext(Object model, Map<String, Object> arguments, IProgressMonitor monitor) {
        return new ModelWorkflowContext(model, arguments, monitor);
    }

    protected TransactionalEditingDomain getEditingDomain(Object model) {
        List models;
        if (model instanceof EObject || model instanceof Resource) {
            return TransactionUtil.getEditingDomain((Object)model);
        }
        if (model instanceof List && !(models = (List)model).isEmpty()) {
            return this.getEditingDomain(models.get(0));
        }
        return null;
    }

    protected boolean hasModelWorkflowComponents(Workflow workflow) {
        if (workflow instanceof WorkspaceWorkflow) {
            List<IWorkflowComponent> children = ((WorkspaceWorkflow)workflow).getChildren();
            for (IWorkflowComponent component : children) {
                if (!(component instanceof IModelWorkflowComponent)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isModifyingModel(Workflow workflow) {
        if (workflow instanceof WorkspaceWorkflow) {
            List<IWorkflowComponent> children = ((WorkspaceWorkflow)workflow).getChildren();
            for (IWorkflowComponent component : children) {
                if (!(component instanceof IModelWorkflowComponent) || !((IModelWorkflowComponent)component).isModifyingModel()) continue;
                return true;
            }
        }
        return false;
    }

    protected Object loadModel(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.modelURIs.isEmpty()) {
            return null;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.modelURIs.size() * 2));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ArrayList<EObject> modelObjects = new ArrayList<EObject>();
        ModelLoadManager.INSTANCE.loadURIs(this.modelURIs, false, (IProgressMonitor)progress.newChild(this.modelURIs.size()));
        ResourceSetImpl resouceSet = new ResourceSetImpl();
        for (URI modelURI : this.modelURIs) {
            Resource modelResource;
            IStatus status;
            EObject eObject;
            String fragment;
            IFile file = EcorePlatformUtil.getFile((URI)modelURI.trimFragment());
            if (ModelDescriptorRegistry.INSTANCE.isModelFile(file)) {
                IModelDescriptor modelDescriptor;
                fragment = modelURI.fragment();
                if (fragment != null) {
                    eObject = EcorePlatformUtil.getEObject((URI)modelURI);
                    if (eObject == null) {
                        status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)NLS.bind((String)Messages.error_modelResourceContainsNoMatchingElement, (Object)modelURI.toPlatformString(true), (Object)fragment));
                        throw new CoreException(status);
                    }
                    modelObjects.add(eObject);
                    modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(eObject.eResource());
                    this.modelDescriptors.add(modelDescriptor);
                } else if (!XtendUtil.isXtendResource(modelURI)) {
                    modelResource = EcorePlatformUtil.getResource((URI)modelURI);
                    if (modelResource == null) {
                        status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)NLS.bind((String)Messages.error_modelResourceCouldNotBeLoaded, (Object)modelURI.toPlatformString(true)));
                        throw new CoreException(status);
                    }
                    modelObjects.addAll((Collection<EObject>)modelResource.getContents());
                    modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(modelResource);
                    this.modelDescriptors.add(modelDescriptor);
                }
            } else {
                fragment = modelURI.fragment();
                if (fragment != null) {
                    eObject = EcoreResourceUtil.loadEObject((ResourceSet)resouceSet, (URI)modelURI);
                    if (eObject == null) {
                        status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)NLS.bind((String)Messages.error_modelResourceContainsNoMatchingElement, (Object)modelURI.toPlatformString(true), (Object)fragment));
                        throw new CoreException(status);
                    }
                    modelObjects.add(eObject);
                    this.emfModelResources.add(eObject.eResource());
                } else if (!XtendUtil.isXtendResource(modelURI)) {
                    modelResource = EcoreResourceUtil.loadResource((ResourceSet)resouceSet, (URI)modelURI, null);
                    if (modelResource == null) {
                        status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)NLS.bind((String)Messages.error_modelResourceCouldNotBeLoaded, (Object)modelURI.toPlatformString(true)));
                        throw new CoreException(status);
                    }
                    modelObjects.addAll((Collection<EObject>)modelResource.getContents());
                    this.emfModelResources.add(modelResource);
                }
            }
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return !modelObjects.isEmpty() ? modelObjects : null;
    }

    protected void saveModel(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.modelDescriptors.size() + this.emfModelResources.size()));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IModelDescriptor modelDescriptor : this.modelDescriptors) {
            if (SaveIndicatorUtil.isDirty((IModelDescriptor)modelDescriptor)) {
                EcorePlatformUtil.saveModel((Object)modelDescriptor, (boolean)false, (IProgressMonitor)progress.newChild(1));
                if (!progress.isCanceled()) continue;
                throw new OperationCanceledException();
            }
            progress.worked(1);
        }
        for (Resource modelResource : this.emfModelResources) {
            EcoreResourceUtil.saveModelResource((Resource)modelResource, null);
            progress.worked(1);
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
    }
}

