/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSetImpl;
import org.eclipse.sphinx.emf.resource.ScopingResourceSet;
import org.eclipse.sphinx.emf.scoping.DefaultResourceScope;
import org.eclipse.sphinx.emf.scoping.IResourceScope;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;

public class ScopingResourceSetImpl
extends ExtendedResourceSetImpl
implements ScopingResourceSet {
    private IResourceScope outsideWorkspaceScope;

    protected IResourceScope getOutsideWorkspaceScope() {
        if (this.outsideWorkspaceScope == null) {
            this.outsideWorkspaceScope = this.createOutsideWorkspaceScope();
        }
        return this.outsideWorkspaceScope;
    }

    protected IResourceScope createOutsideWorkspaceScope() {
        return new DefaultResourceScope(){

            @Override
            public boolean belongsTo(Resource resource, boolean includeReferencedScopes) {
                Assert.isNotNull((Object)resource);
                return !resource.getURI().isPlatform() || this.isShared(resource);
            }

            @Override
            public boolean isShared(Resource resource) {
                Assert.isNotNull((Object)resource);
                return resource.getURI().isPlatformPlugin();
            }
        };
    }

    @Override
    public List<Resource> getResourcesInModel(Object contextObject) {
        return this.getResourcesInScope(contextObject, true, false);
    }

    @Override
    public List<Resource> getResourcesInModel(Object contextObject, boolean includeReferencedScopes) {
        return this.getResourcesInScope(contextObject, includeReferencedScopes, false);
    }

    @Override
    public List<Resource> getResourcesInScope(Object contextObject) {
        return this.getResourcesInScope(contextObject, true, true);
    }

    @Override
    public List<Resource> getResourcesInScope(Object contextObject, boolean includeReferencedScopes) {
        return this.getResourcesInScope(contextObject, includeReferencedScopes, true);
    }

    protected List<Resource> getResourcesInScope(Object contextObject, boolean includeReferencedScopes, boolean ignoreMetaModel) {
        Map<IResourceScope, Set<IMetaModelDescriptor>> contextResourceScopes = this.getContextResourceScopes(contextObject);
        LinkedHashSet<Resource> resourcesInScope = new LinkedHashSet<Resource>();
        ArrayList<Resource> safeResources = new ArrayList<Resource>((Collection<Resource>)this.getResources());
        block0: for (Resource resource : safeResources) {
            for (IResourceScope contextResourceScope : contextResourceScopes.keySet()) {
                if (!contextResourceScope.belongsTo(resource, includeReferencedScopes) || !ignoreMetaModel && !this.hasMatchingMetaModel(contextResourceScopes.get(contextResourceScope), resource)) continue;
                resourcesInScope.add(resource);
                continue block0;
            }
        }
        return Collections.unmodifiableList(new ArrayList(resourcesInScope));
    }

    protected boolean isResourceInScope(Resource resource, Object contextObject, boolean includeReferencedScopes, boolean ignoreMetaModel) {
        Map<IResourceScope, Set<IMetaModelDescriptor>> contextResourceScopes = this.getContextResourceScopes(contextObject);
        for (IResourceScope contextResourceScope : contextResourceScopes.keySet()) {
            if (!contextResourceScope.belongsTo(resource, includeReferencedScopes) || !ignoreMetaModel && !this.hasMatchingMetaModel(contextResourceScopes.get(contextResourceScope), resource)) continue;
            return true;
        }
        return false;
    }

    protected Map<IResourceScope, Set<IMetaModelDescriptor>> getContextResourceScopes(Object contextObject) {
        HashMap<IResourceScope, Set<IMetaModelDescriptor>> resourceScopes = new HashMap<IResourceScope, Set<IMetaModelDescriptor>>(1);
        Resource resource = EcoreResourceUtil.getResource(contextObject);
        if (resource != null) {
            contextObject = resource;
        }
        if (contextObject instanceof IFile) {
            IFile contextFile = (IFile)contextObject;
            contextObject = EcorePlatformUtil.createURI(contextFile.getFullPath());
        }
        if (contextObject instanceof URI) {
            URI contextURI = (URI)contextObject;
            resource = this.getResource(contextURI.trimFragment().trimQuery(), false);
            if (resource != null) {
                contextObject = resource;
            } else if (contextURI.isPlatformResource()) {
                Path contextPath = new Path(contextURI.toPlatformString(true));
                IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)contextPath);
                if (member instanceof IContainer) {
                    contextObject = member;
                }
            }
        }
        if (contextObject instanceof Resource) {
            Resource contextResource = (Resource)contextObject;
            IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(contextResource);
            if (modelDescriptor != null) {
                resourceScopes.put(modelDescriptor.getScope(), Collections.singleton(modelDescriptor.getMetaModelDescriptor()));
            } else if (this.getOutsideWorkspaceScope().belongsTo(contextResource, false)) {
                IMetaModelDescriptor contextMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(contextResource);
                resourceScopes.put(this.getOutsideWorkspaceScope(), Collections.singleton(contextMMDescriptor));
            }
        }
        if (contextObject instanceof IContainer) {
            IContainer contextContainer = (IContainer)contextObject;
            for (IModelDescriptor modelDescriptor : ModelDescriptorRegistry.INSTANCE.getModels(contextContainer)) {
                IResourceScope resourceScope = modelDescriptor.getScope();
                HashSet<IMetaModelDescriptor> mmDescriptors = (HashSet<IMetaModelDescriptor>)resourceScopes.get(resourceScope);
                if (mmDescriptors == null) {
                    mmDescriptors = new HashSet<IMetaModelDescriptor>(1);
                    resourceScopes.put(resourceScope, mmDescriptors);
                }
                mmDescriptors.add(modelDescriptor.getMetaModelDescriptor());
            }
        }
        if (contextObject instanceof IModelDescriptor) {
            IModelDescriptor modelDescriptor = (IModelDescriptor)contextObject;
            resourceScopes.put(modelDescriptor.getScope(), Collections.singleton(modelDescriptor.getMetaModelDescriptor()));
        }
        if (contextObject instanceof IResourceScope) {
            resourceScopes.put((IResourceScope)contextObject, Collections.singleton(MetaModelDescriptorRegistry.ANY_MM));
        }
        return resourceScopes;
    }

    protected boolean hasMatchingMetaModel(Set<IMetaModelDescriptor> mmDescriptors, Resource resource) {
        Assert.isNotNull(mmDescriptors);
        IMetaModelDescriptor resourceMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(resource);
        if (resourceMMDescriptor != null) {
            for (IMetaModelDescriptor mmDescriptor : mmDescriptors) {
                if (!resourceMMDescriptor.equals(mmDescriptor) && MetaModelDescriptorRegistry.ANY_MM != mmDescriptor) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected EObject getEObject(URI uri, IMetaModelDescriptor targetMetaModelDescriptor, Object contextObject, boolean loadOnDemand) {
        Assert.isNotNull((Object)uri);
        if (uri.segmentCount() == 0) {
            List<Resource> resources = this.getResourcesToSearchIn(this.getResourcesInScope(contextObject), uri, targetMetaModelDescriptor);
            return this.safeFindEObjectInResources(resources, uri, loadOnDemand);
        }
        Resource resource = this.safeGetResource(uri.trimFragment().trimQuery(), loadOnDemand);
        if (resource != null) {
            if (contextObject != null) {
                if (this.isResourceInScope(resource, contextObject, true, true)) {
                    return this.safeGetEObjectFromResource(resource, uri.fragment());
                }
            } else {
                return this.safeGetEObjectFromResource(resource, uri.fragment());
            }
        }
        return null;
    }

    @Deprecated
    protected List<Resource> getResourcesToSearchIn(URI uri, boolean loadOnDemand, EObject contextObject) {
        if (contextObject != null) {
            return this.getResourcesInScope(contextObject);
        }
        return Collections.unmodifiableList(this.getResources());
    }
}

