/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.incquery.proxymanagment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolver;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolverService;
import org.eclipse.sphinx.emf.incquery.IncQueryEngineHelper;

public abstract class AbstractProxyResolverService
implements IProxyResolverService {
    private List<IProxyResolver> proxyResolvers = new ArrayList<IProxyResolver>();
    private IncQueryEngineHelper incQueryEngineHelper;

    public AbstractProxyResolverService() {
        this.initProxyResolvers();
    }

    protected abstract void initProxyResolvers();

    protected abstract EClass getTargetEClass(URI var1);

    protected List<IProxyResolver> getProxyResolvers() {
        if (this.proxyResolvers == null) {
            this.proxyResolvers = new ArrayList<IProxyResolver>();
        }
        return this.proxyResolvers;
    }

    protected IProxyResolver getProxyResolver(EClass eType) {
        for (IProxyResolver resolver : this.getProxyResolvers()) {
            if (!resolver.canResolve(eType)) continue;
            return resolver;
        }
        return null;
    }

    protected IncQueryEngineHelper getIncQueryEngineHelper() {
        if (this.incQueryEngineHelper == null) {
            this.incQueryEngineHelper = new IncQueryEngineHelper();
        }
        return this.incQueryEngineHelper;
    }

    public EObject getEObject(EObject proxy, EObject contextObject, boolean loadOnDemand) {
        IProxyResolver proxyResolver = this.getProxyResolver(proxy.eClass());
        if (proxyResolver != null) {
            return proxyResolver.getEObject(proxy, contextObject, loadOnDemand);
        }
        return null;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        IProxyResolver proxyResolver;
        EClass targetEClass = this.getTargetEClass(uri);
        if (targetEClass != null && (proxyResolver = this.getProxyResolver(targetEClass)) != null) {
            return proxyResolver.getEObject(uri, loadOnDemand);
        }
        return null;
    }
}

