/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.EclipseHomeInitializer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;

public class LoadTargetDefinitionJob
extends WorkspaceJob {
    private static final String JOB_FAMILY_ID = "LoadTargetDefinitionJob";
    private ITargetDefinition fTarget;
    private boolean fNone = false;
    static /* synthetic */ Class class$0;

    public static void load(ITargetDefinition target) {
        LoadTargetDefinitionJob.load(target, null);
    }

    public static void load(ITargetDefinition target, IJobChangeListener listener) {
        Job.getJobManager().cancel((Object)JOB_FAMILY_ID);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
        job.setUser(true);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    public LoadTargetDefinitionJob(ITargetDefinition target) {
        super(Messages.LoadTargetDefinitionJob_0);
        this.fTarget = target;
        if (target == null) {
            this.fNone = true;
            PDECore pDECore = PDECore.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.core.target.ITargetPlatformService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITargetPlatformService service = (ITargetPlatformService)pDECore.acquireService(clazz.getName());
            this.fTarget = service.newTarget();
        }
    }

    public boolean belongsTo(Object family) {
        return JOB_FAMILY_ID.equals(family);
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
            monitor.beginTask(Messages.LoadTargetOperation_mainTaskName, 100);
            this.loadEnvironment(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadArgs(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadJRE(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadImplicitPlugins(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadPlugins(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.loadAdditionalPreferences(preferences);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            PDECore.getDefault().getPreferencesManager().savePluginPreferences();
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private void loadArgs(PDEPreferencesManager pref, IProgressMonitor monitor) {
        monitor.beginTask(Messages.LoadTargetOperation_argsTaskName, 2);
        String args = this.fTarget.getProgramArguments();
        pref.setValue("program_args", args != null ? args : "");
        monitor.worked(1);
        args = this.fTarget.getVMArguments();
        pref.setValue("vm_args", args != null ? args : "");
        monitor.done();
    }

    private void loadEnvironment(PDEPreferencesManager pref, IProgressMonitor monitor) {
        monitor.beginTask(Messages.LoadTargetOperation_envTaskName, 1);
        this.setEnvironmentPref(pref, "org.eclipse.pde.ui.arch", this.fTarget.getArch());
        this.setEnvironmentPref(pref, "org.eclipse.pde.ui.nl", this.fTarget.getNL());
        this.setEnvironmentPref(pref, "org.eclipse.pde.ui.os", this.fTarget.getOS());
        this.setEnvironmentPref(pref, "org.eclipse.pde.ui.ws", this.fTarget.getWS());
        monitor.done();
    }

    private void setEnvironmentPref(PDEPreferencesManager pref, String key, String value) {
        if (value == null) {
            pref.setToDefault(key);
        } else {
            pref.setValue(key, value);
        }
    }

    private void loadJRE(PDEPreferencesManager pref, IProgressMonitor monitor) {
        IVMInstall def;
        IVMInstall jre;
        IPath container = this.fTarget.getJREContainer();
        monitor.beginTask(Messages.LoadTargetOperation_jreTaskName, 1);
        if (container != null && (jre = JavaRuntime.getVMInstall((IPath)container)) != null && !jre.equals(def = JavaRuntime.getDefaultVMInstall())) {
            try {
                JavaRuntime.setDefaultVMInstall((IVMInstall)jre, null);
            }
            catch (CoreException coreException) {}
        }
        monitor.done();
    }

    private void loadImplicitPlugins(PDEPreferencesManager pref, IProgressMonitor monitor) {
        NameVersionDescriptor[] infos = this.fTarget.getImplicitDependencies();
        if (infos != null) {
            monitor.beginTask(Messages.LoadTargetOperation_implicitPluginsTaskName, infos.length + 1);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < infos.length) {
                buffer.append(infos[i].getId()).append(',');
                monitor.worked(1);
                ++i;
            }
            if (infos.length > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            pref.setValue("implicit_dependencies", buffer.toString());
        }
        monitor.done();
    }

    private void loadPlugins(PDEPreferencesManager pref, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.LoadTargetOperation_loadPluginsTaskName, 100);
        String currentPath = pref.getString("platform_path");
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        String path = null;
        if (containers != null && containers.length > 0) {
            path = ((AbstractBundleContainer)containers[0]).getLocation(true);
        }
        if (path == null) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                path = manager.performStringSubstitution(path);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        monitor.worked(10);
        List additional = this.getAdditionalLocs();
        pref.setValue("platform_path", path);
        String mode = new Path(path).equals((Object)new Path(TargetPlatform.getDefaultLocation())) ? "useThis" : "useOther";
        pref.setValue("target_mode", mode);
        ListIterator li = additional.listIterator();
        StringBuffer buffer = new StringBuffer();
        while (li.hasNext()) {
            buffer.append(li.next()).append(",");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        pref.setValue("additional_locations", buffer.toString());
        String newValue = currentPath;
        int i = 0;
        while (i < 4) {
            String value = pref.getString("saved_platform" + i);
            pref.setValue("saved_platform" + i, newValue);
            if (value.equals(currentPath)) break;
            newValue = value;
            ++i;
        }
        this.handleReload(path, additional, pref, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
        monitor.done();
    }

    private void loadAdditionalPreferences(PDEPreferencesManager pref) throws CoreException {
        pref.setValue("target.profile", "");
        String memento = this.fTarget.getHandle().getMemento();
        if (this.fNone) {
            memento = "NO_TARGET";
        }
        pref.setValue("workspace_target_handle", memento);
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        boolean profile = false;
        if (containers != null && containers.length > 0) {
            profile = containers[0] instanceof ProfileBundleContainer || containers[0] instanceof FeatureBundleContainer;
        }
        pref.setValue("target_platform_realization", profile);
    }

    private List getAdditionalLocs() throws CoreException {
        ArrayList<String> additional = new ArrayList<String>();
        ITargetLocation[] containers = this.fTarget.getTargetLocations();
        if (containers != null && containers.length > 1) {
            int i = 1;
            while (i < containers.length) {
                additional.add(((AbstractBundleContainer)containers[i]).getLocation(true));
                ++i;
            }
        }
        return additional;
    }

    private void handleReload(String targetLocation, List additionalLocations, PDEPreferencesManager pref, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.LoadTargetOperation_reloadTaskName, (int)100);
        try {
            int i;
            TargetFeature[] allFeatures;
            TargetBundle[] allBundles;
            HashSet<BundleInfo> included = new HashSet<BundleInfo>();
            HashSet<NameVersionDescriptor> duplicates = new HashSet<NameVersionDescriptor>();
            ArrayList<BundleInfo> infos = new ArrayList<BundleInfo>();
            HashSet<String> includedIds = new HashSet<String>();
            if (!this.fTarget.isResolved()) {
                this.fTarget.resolve((IProgressMonitor)subMon.newChild(20));
            } else {
                subMon.worked(20);
            }
            if (subMon.isCanceled()) {
                return;
            }
            TargetBundle[] includedBundles = this.fTarget.getBundles();
            if (includedBundles == null) {
                includedBundles = new TargetBundle[]{};
            }
            if ((allBundles = this.fTarget.getAllBundles()) == null) {
                allBundles = new TargetBundle[]{};
            }
            if ((allFeatures = this.fTarget.getAllFeatures()) == null) {
                allFeatures = new TargetFeature[]{};
            }
            ArrayList<File> pooled = new ArrayList<File>();
            boolean considerPool = false;
            int i2 = 0;
            while (i2 < includedBundles.length) {
                if (includedBundles[i2].getStatus().isOK()) {
                    BundleInfo bundleInfo = includedBundles[i2].getBundleInfo();
                    NameVersionDescriptor desc = new NameVersionDescriptor(bundleInfo.getSymbolicName(), bundleInfo.getVersion());
                    File file = new File(bundleInfo.getLocation());
                    boolean inPool = P2TargetUtils.BUNDLE_POOL.isPrefixOf((IPath)new Path(file.getAbsolutePath()));
                    boolean bl = considerPool = considerPool || inPool;
                    if (!duplicates.contains(desc)) {
                        if (inPool) {
                            pooled.add(file);
                        }
                        infos.add(bundleInfo);
                        included.add(bundleInfo);
                        includedIds.add(bundleInfo.getSymbolicName());
                        duplicates.add(desc);
                    }
                }
                ++i2;
            }
            ArrayList<BundleInfo> missing = new ArrayList<BundleInfo>();
            NameVersionDescriptor[] restrictions = this.fTarget.getIncluded();
            if (restrictions != null) {
                int j = 0;
                while (j < allBundles.length) {
                    TargetBundle bi = allBundles[j];
                    if (bi.getStatus().isOK() && !included.contains(bi.getBundleInfo())) {
                        missing.add(bi.getBundleInfo());
                    }
                    ++j;
                }
            }
            ArrayList<URL> paths = new ArrayList<URL>(infos.size() + missing.size());
            Iterator iterator = infos.iterator();
            while (iterator.hasNext()) {
                BundleInfo info = (BundleInfo)iterator.next();
                try {
                    paths.add(new File(info.getLocation()).toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.LoadTargetDefinitionJob_1, (Throwable)e));
                }
            }
            StringBuffer checked = new StringBuffer();
            StringBuffer versions = new StringBuffer();
            int count = 0;
            iterator = missing.iterator();
            HashSet<NameVersionDescriptor> missingDescriptions = new HashSet<NameVersionDescriptor>(missing.size());
            while (iterator.hasNext()) {
                BundleInfo bi = (BundleInfo)iterator.next();
                NameVersionDescriptor desc = new NameVersionDescriptor(bi.getSymbolicName(), bi.getVersion());
                missingDescriptions.add(desc);
                try {
                    paths.add(new File(bi.getLocation()).toURL());
                }
                catch (MalformedURLException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.LoadTargetDefinitionJob_1, (Throwable)e));
                }
                if (count > 0) {
                    checked.append(" ");
                }
                checked.append(bi.getSymbolicName());
                ++count;
                if (!includedIds.contains(bi.getSymbolicName())) continue;
                if (versions.length() > 0) {
                    versions.append(" ");
                }
                versions.append(desc.toPortableString());
            }
            URL[] urls = paths.toArray(new URL[paths.size()]);
            PDEState state = new PDEState(urls, true, (IProgressMonitor)new SubProgressMonitor(monitor, 45));
            IPluginModelBase[] models = state.getTargetModels();
            int i3 = 0;
            while (i3 < models.length) {
                NameVersionDescriptor nv = new NameVersionDescriptor(models[i3].getPluginBase().getId(), models[i3].getPluginBase().getVersion());
                models[i3].setEnabled(!missingDescriptions.contains(nv));
                ++i3;
            }
            if (subMon.isCanceled()) {
                return;
            }
            if (urls.length == 0) {
                pref.setValue("checkedPlugins", "[savedNone]");
            } else if (missing.size() == 0) {
                pref.setValue("checkedPlugins", "[savedAll]");
            } else {
                pref.setValue("checkedPlugins", checked.toString());
            }
            if (versions.length() > 0) {
                pref.setValue("checkedVersionPlugins", versions.toString());
            } else {
                pref.setValue("checkedVersionPlugins", "[savedNone]");
            }
            if (pooled.isEmpty()) {
                if (considerPool) {
                    pref.setValue("pooled_urls", "[savedNone]");
                } else {
                    pref.setValue("pooled_urls", "");
                }
            } else {
                StringBuffer buf = new StringBuffer();
                Iterator iterator2 = pooled.iterator();
                while (iterator2.hasNext()) {
                    File bundle = (File)iterator2.next();
                    buf.append(bundle.getName());
                    if (!iterator2.hasNext()) continue;
                    buf.append(',');
                }
                pref.setValue("pooled_urls", buf.toString());
                pref.setValue("pooled_bundles", "");
            }
            StringBuffer featureList = new StringBuffer();
            NameVersionDescriptor[] includes = this.fTarget.getIncluded();
            boolean featuresFound = false;
            if (includes != null) {
                i = 0;
                while (i < includes.length) {
                    if (includes[i].getType() == "feature") {
                        featuresFound = true;
                        TargetFeature bestMatch = null;
                        int j = 0;
                        while (j < allFeatures.length) {
                            TargetFeature feature = allFeatures[j];
                            if (feature.getId().equals(includes[i].getId())) {
                                Version v2;
                                Version v1;
                                if (includes[i].getVersion() != null) {
                                    if (includes[i].getVersion().equals(feature.getVersion())) {
                                        bestMatch = feature;
                                        break;
                                    }
                                } else if (bestMatch != null && (v1 = Version.parseVersion((String)feature.getVersion())).compareTo((Object)(v2 = Version.parseVersion((String)feature.getVersion()))) > 0) {
                                    bestMatch = feature;
                                }
                                if (bestMatch == null) {
                                    bestMatch = feature;
                                }
                            }
                            ++j;
                        }
                        if (bestMatch != null) {
                            if (featureList.length() > 0) {
                                featureList.append(',');
                            }
                            featureList.append(bestMatch.getId());
                            featureList.append('@');
                            featureList.append(bestMatch.getVersion());
                        }
                    }
                    ++i;
                }
            }
            if (includes == null || !featuresFound) {
                i = 0;
                while (i < allFeatures.length) {
                    featureList.append(allFeatures[i].getId());
                    featureList.append('@');
                    featureList.append(allFeatures[i].getVersion());
                    if (i < allFeatures.length - 1) {
                        featureList.append(',');
                    }
                    ++i;
                }
            }
            pref.setValue("external_features", featureList.toString());
            this.performPlatformReset(state);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
            subMon.done();
        }
    }

    private void performPlatformReset(PDEState state) {
        EclipseHomeInitializer.resetEclipseHomeVariable();
        PDECore.getDefault().getSourceLocationManager().reset();
        PDECore.getDefault().getJavadocLocationManager().reset();
        IPluginModelBase[] models = state.getTargetModels();
        this.removeDisabledBundles(state, models);
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        manager.getExternalModelManager().setModels(models);
        PDECore.getDefault().getExtensionsRegistry().targetReloaded();
        manager.resetState(state);
        PDECore.getDefault().getFeatureModelManager().targetReloaded();
    }

    private void removeDisabledBundles(PDEState state, IPluginModelBase[] models) {
        int number = models.length;
        int i = 0;
        while (i < models.length) {
            if (!models[i].isEnabled()) {
                state.removeBundleDescription(models[i].getBundleDescription());
                --number;
            }
            ++i;
        }
        if (number < models.length) {
            state.resolveState(true);
        }
    }
}

