/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.plugin.PluginObjectNode;
import org.eclipse.pde.internal.ui.editor.plugin.ExtensionsSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.search.AttributesMatch;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;

public class ManifestEditorOpener {
    public static IEditorPart open(Match match, boolean activate) throws PartInitException {
        IEditorPart editorPart = null;
        editorPart = ManifestEditor.open(match.getElement(), true);
        if (editorPart != null && editorPart instanceof ManifestEditor) {
            ManifestEditor editor = (ManifestEditor)editorPart;
            if (match.getBaseUnit() != 3) {
                IDocument doc = editor.getDocument(match);
                if (doc != null) {
                    Match exact = ManifestEditorOpener.findExactMatch(doc, match, (IEditorPart)editor);
                    editor.openToSourcePage(match.getElement(), exact.getOffset(), exact.getLength());
                }
            } else {
                IFormPage page = editor.setActivePage("extensions");
                IManagedForm form = page.getManagedForm();
                IFormPart[] parts = form.getParts();
                if (parts != null && parts.length > 0) {
                    ExtensionsSection section = (ExtensionsSection)parts[0];
                    String searchPattern = ((AttributesMatch)match).getSearchPattern();
                    Text filterText = section.getFormFilteredTree().getFilterControl();
                    if (!filterText.getText().equals(searchPattern)) {
                        section.setBypassFilterDelay(true);
                        filterText.setText(searchPattern);
                    }
                }
            }
        }
        return editorPart;
    }

    public static Match findExactMatch(IDocument document, Match match, IEditorPart editor) {
        if (match.getOffset() == -1 && match.getBaseUnit() == 1) {
            return new Match(match.getElement(), 2, 0, 0);
        }
        IPluginObject element = (IPluginObject)match.getElement();
        String name = null;
        String value = null;
        IRegion region = null;
        if (editor instanceof ManifestEditor && (element instanceof IPluginExtension || element instanceof IPluginExtensionPoint)) {
            region = ManifestEditorOpener.getAttributeMatch((ManifestEditor)editor, element, document);
        } else {
            if (element instanceof IPluginImport) {
                name = "plugin";
                value = ((IPluginImport)element).getId();
            } else if (element instanceof IPlugin) {
                name = "id";
                value = ((IPlugin)element).getId();
            } else if (element instanceof IFragment) {
                name = "id";
                value = ((IFragment)element).getId();
            }
            region = ManifestEditorOpener.getAttributeRegionForLine(document, name, value, match.getOffset());
        }
        if (region != null) {
            return new Match((Object)element, 2, region.getOffset(), region.getLength());
        }
        return match;
    }

    private static IRegion getAttributeRegionForLine(IDocument document, String name, String value, int line) {
        try {
            int offset = document.getLineOffset(line) + document.getLineLength(line);
            return ManifestEditorOpener.getAttributeRegion(document, name, value, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static IRegion getAttributeRegion(IDocument document, String name, String value, int offset) {
        try {
            FindReplaceDocumentAdapter findReplaceAdapter = new FindReplaceDocumentAdapter(document);
            IRegion nameRegion = findReplaceAdapter.find(offset, String.valueOf(name) + "\\s*=\\s*\"" + value, false, false, false, true);
            if (nameRegion != null && document.get(nameRegion.getOffset() + nameRegion.getLength() - value.length(), value.length()).equals(value)) {
                return new Region(nameRegion.getOffset() + nameRegion.getLength() - value.length(), value.length());
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    private static IRegion getAttributeRegion(IDocument document, String value, int offset) {
        try {
            FindReplaceDocumentAdapter findReplaceAdapter = new FindReplaceDocumentAdapter(document);
            IRegion nameRegion = findReplaceAdapter.find(offset, value, true, true, false, false);
            if (nameRegion != null && document.get(nameRegion.getOffset() + nameRegion.getLength() - value.length(), value.length()).equals(value)) {
                return new Region(nameRegion.getOffset() + nameRegion.getLength() - value.length(), value.length());
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public static IRegion getAttributeMatch(ManifestEditor editor, Object object, IDocument document) {
        if (object instanceof IPluginObject) {
            return ManifestEditorOpener.getAttributeMatch(editor, (IPluginObject)object, document);
        }
        String value = ((BaseDescription)object).getName();
        IManifestHeader header = ((IBundlePluginModelBase)editor.getAggregateModel()).getBundleModel().getBundle().getManifestHeader("Export-Package");
        return ManifestEditorOpener.getAttributeRegion(document, value, header.getOffset());
    }

    public static IRegion getAttributeMatch(ManifestEditor editor, String value, IDocument document) {
        return ManifestEditorOpener.getAttributeRegion(document, value, 0);
    }

    private static IRegion getAttributeMatch(ManifestEditor editor, IPluginObject object, IDocument document) {
        Object[] elements = null;
        elements = object instanceof IPluginExtension ? ((IPluginModelBase)editor.getAggregateModel()).getPluginBase().getExtensions() : ((IPluginModelBase)editor.getAggregateModel()).getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < elements.length) {
            IPluginExtension element = elements[i];
            if (element != null && object.equals(element)) {
                int offset = ((PluginObjectNode)element).getOffset();
                String name = object instanceof IPluginExtension ? "point" : "id";
                String value = object instanceof IPluginExtension ? ((IPluginExtension)object).getPoint() : ((IPluginExtensionPoint)object).getId();
                return ManifestEditorOpener.getAttributeRegion(document, name, value, offset += ((PluginObjectNode)element).getLength());
            }
            ++i;
        }
        return null;
    }
}

