/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.TemplateSelectionPage;
import org.eclipse.pde.ui.templates.AbstractNewPluginTemplateWizard;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.widgets.Composite;

public class NewPluginTemplateChoiceWizard
extends AbstractNewPluginTemplateWizard {
    private TemplateSelectionPage fSelectionPage;
    private ITemplateSection[] fCandidates;

    public ITemplateSection[] getTemplateSections() {
        if (this.fSelectionPage != null) {
            return this.fSelectionPage.getSelectedTemplates();
        }
        return this.getCandidates();
    }

    public void addAdditionalPages() {
        this.fSelectionPage = new TemplateSelectionPage(this.getCandidates());
        this.addPage((IWizardPage)this.fSelectionPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.fSelectionPage == null) {
            return null;
        }
        return this.fSelectionPage.getNextVisiblePage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return null;
    }

    private ITemplateSection[] getCandidates() {
        if (this.fCandidates == null) {
            this.createCandidates();
        }
        return this.fCandidates;
    }

    public boolean canFinish() {
        ITemplateSection[] sections = this.fSelectionPage.getSelectedTemplates();
        int i = 0;
        while (i < sections.length) {
            int pageCount = sections[i].getPageCount();
            int j = 0;
            while (j < pageCount) {
                WizardPage page = sections[i].getPage(j);
                if (page != null && !page.isPageComplete()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void createCandidates() {
        ArrayList candidates = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(PDEPlugin.getPluginId(), "templates");
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            this.addTemplate(element, candidates);
            ++i;
        }
        this.fCandidates = candidates.toArray(new ITemplateSection[candidates.size()]);
    }

    private void addTemplate(IConfigurationElement config, ArrayList result) {
        if (!config.getName().equalsIgnoreCase("template")) {
            return;
        }
        try {
            Object template = config.createExecutableExtension("class");
            if (template instanceof ITemplateSection) {
                result.add(template);
            }
        }
        catch (CoreException e) {
            PDEPlugin.log(e);
        }
    }

    public void createPageControls(Composite pageContainer) {
        this.fSelectionPage.createControl(pageContainer);
    }
}

