/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.adapters.executable.emf;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.util.ScenarioAdapterFactory;
import org.eclipse.stem.jobs.adapters.executable.emf.ExecutableAdapter;
import org.eclipse.stem.jobs.adapters.executable.emf.ExecutableAdapterFactory;
import org.eclipse.stem.jobs.execution.IExecutable;
import org.eclipse.stem.jobs.simulation.SimulationManager;

public class ScenarioExecutableAdapterFactory
extends ScenarioAdapterFactory
implements ExecutableAdapterFactory {
    public ScenarioExecutableAdapterFactory() {
        ExecutableAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public Adapter createScenarioAdapter() {
        return new ScenarioExecutableAdapter();
    }

    public boolean isFactoryForType(Object type) {
        return type == IExecutable.class || super.isFactoryForType(type);
    }

    protected static class ScenarioExecutableAdapter
    extends ExecutableAdapter {
        protected ScenarioExecutableAdapter() {
        }

        @Override
        public void run() {
            Scenario newScenario = (Scenario)Utility.getIdentifiableForceLoad((URI)((Scenario)this.getTarget()).getURI());
            SimulationManager.getManager().createAndRunSimulation(newScenario);
        }

        @Override
        public void step() {
            Scenario newScenario = (Scenario)Utility.getIdentifiableForceLoad((URI)((Scenario)this.getTarget()).getURI());
            SimulationManager.getManager().createAndStepSimulation(newScenario);
        }
    }
}

